@extends('layouts.admin')

@section('title',tr('view_coupon'))

@section('content-header',tr('view_coupon'))

@section('breadcrumb')

	<li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>

	<li><a href="{{ route('admin.coupons.index') }}"><i class="fa fa-gift"></i>{{ tr('coupons') }}</a></li>

	<li class="active">{{ tr('view_coupon') }}</li>

@endsection

@section('content')

	<div class="row">

		<div class="col-md-10 col-md-offset-1">

	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">

            		<b>{{ tr('view_coupon') }}</b>

					@if($coupon_details->status == APPROVED)
							
              			<a href="{{ route('admin.coupons.status' , [ 'coupon_id' => $coupon_details->id ] ) }}" onclick="return confirm(&quot;{{ $coupon_details->title }} - {{ tr('coupon_decline_confirmation') }}&quot;);" class="pull-right btn btn-danger text-center" style="margin-right: 4px;"><b><i class="fa fa-pen"></i> {{ tr('decline') }}</b></a>
             
                  	@else

              			<a href="{{ route('admin.coupons.status' , [ 'coupon_id' => $coupon_details->id ] ) }}" class="btn btn-success text-center" style="margin-right: 4px;"><b><i class="fa fa-pen"></i> {{ tr('approve') }}</b></a>
                  		
                  	@endif

            		@if(Setting::get('admin_demo_control'))

						<a href="javascript:;" class="pull-right btn btn-danger disabled text-center" style="margin-right: 4px;"><b><i class="fa fa-pen"></i> {{ tr('delete') }}</b></a>

						<a href="javascript:;" class="pull-right btn btn-warning disabled text-center" style="margin-right: 4px;"><b><i class="fa fa-pen"></i> {{ tr('edit') }}</b></a>

					@else

						<a class="pull-right btn btn-danger text-center" onclick="return confirm(&quot;{{ tr('admin_coupon_delete_confirmation' , $coupon_details->title) }}&quot;);"  href="{{ route('admin.coupons.delete', ['coupon_id' => $coupon_details->id] ) }}" style="margin-right: 4px;">
						    <b><i class="fa fa-pen"></i> {{ tr('delete') }}</b>
						</a>

						<a href="{{ route('admin.coupons.edit' , ['coupon_id' => $coupon_details->id] ) }}" class="pull-right btn btn-warning text-center" style="margin-right: 4px;"><b><i class="fa fa-pen"></i> {{ tr('edit') }}</b></a>

					@endif	

				</div>

				<div class="box box-body">
				
					<div class="col-md-6">

						<strong>{{ tr('title') }}</strong>

						<h5 class="pull-right">{{ $coupon_details->title }}</h5><hr>

						<strong>{{ tr('coupon_code') }}</strong>

						<h4 class="pull-right" style="border: 2px solid #20bd99">{{ $coupon_details->coupon_code }}</h4><hr>

						<strong>{{ tr('amount_type') }}</strong>

						@if($coupon_details->amount_type == 0)
							<span class="label label-primary pull-right">{{ tr('percentage') }}</span>
						@else
							<span class="label label-primary pull-right">{{ tr('absolute') }}</span>
						@endif
						<hr>

						<strong>{{ tr('amount') }}</strong>
						@if($coupon_details->amount_type == 0)
							<span class="label label-primary pull-right">{{ $coupon_details->amount }} % </span>
						@else
							<span class="label label-primary pull-right">{{ Setting::get('currency') }} {{ $coupon_details->amount }}</span>
						@endif
						<hr>

						<strong>{{ tr('expiry_date') }}</strong>

						<h5 class="pull-right">
							{{ date('d M y', strtotime($coupon_details->expiry_date)) }}
						</h5>
						<hr>

						<strong>{{ tr('no_of_users_limit') }}</strong>
						<h5 class="pull-right">
							{{ $coupon_details->no_of_users_limit }} 
						</h5>
						<hr>

					
					</div>
					
					<div class="col-md-6">

						<strong>{{ tr('per_users_limit') }}</strong>

						<h5 class="pull-right">
							{{ $coupon_details->per_users_limit }}
						</h5>
						<hr>
						
						<strong>{{ tr('status') }}</strong>
						
						@if($coupon_details->status == DECLINED)
							<span class="label label-warning pull-right">{{ tr('declined') }}</span>
						@else
							<span class="label label-success pull-right">{{ tr('approved') }}</span>
						@endif
						
						<hr>

				        <strong>{{ tr('created') }}</strong>
				        
				        <h5 class="pull-right"> {{ date('d/m/Y , H:i:s', strtotime($coupon_details->created_at)) }} </h5>

				        <hr>

				        <strong>{{ tr('updated_at') }}</strong>
				        
				        <h5 class="pull-right">{{ date('d/m/Y , H:i:s', strtotime($coupon_details->updated_at)) }}</h5>

						@if($coupon_details->description == '')

						@else
							<hr>
							<strong>{{ tr('description') }}</strong><br>
							<?php echo $coupon_details->description ?>
						@endif
					
					</div>

				</div>
			
			</div>
		
		</div>
	
	</div>


@endsection