@extends('layouts.admin')

@section('title', tr('documents'))

@section('content-header', tr('documents'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li class="active"><i class="fa fa-book"></i> {{ tr('documents') }}</li>
@endsection

@section('content')

    @include('notification.notify')

    <div class="row">
        
        <div class="col-xs-12">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b>{{ tr('documents') }}</b>
                    
                    <a href="{{ route('admin.documents.create') }}" style="float:right" class="btn btn-warning">
                        <b><i class="fa fa-plus"></i> {{ tr('add_document') }} </b>
                    </a>
                </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                        
                            <tr>
                                <th>{{ tr('id') }}</th>
                                <th>{{ tr('name') }}</th>
                                <th>{{ tr('status') }}</th>
                                <th>{{ tr('action') }}</th>
                            </tr>

                        </thead>

                        <tbody>

                            @foreach($documents as $i => $document_details)
                    
                                <tr>
                                    <td>{{ showEntries($_GET,$i+1) }}</td>

                                    <td>{{ $document_details->name }}</td>

                                    <td>
                                        @if($document_details->status == COMMON_APPROVED)

                                            <span class="label label-success">{{ tr('approved') }}</span>

                                        @else
                                            <span class="label label-warning">{{ tr('pending') }}</span>

                                        @endif
                                    </td>

                                    <td>

                                        <div class="dropdown">
                                                
                                            <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                {{ tr('action') }}
                                                <span class="caret"></span>
                                            </button>

                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenu">
                                                
                                                <li>
                                                    <a href="{{  route('admin.providers.document' ,['document_id' => $document_details->id] ) }}"><b>{{ tr('view') }}</b></a>
                                                </li>

                                                @if(Setting::get('admin_demo_control'))
                                                    
                                                    <li>
                                                        <a href="javascript:;" class="btn disabled" style="text-align: left"><b>{{ tr('edit') }}</b></a>
                                                    </li>

                                                    <li>      
                                                        <a href="javascript:;" class="btn disabled" style="text-align: left"><b>{{ tr('delete') }}</b></a>
                                                    </li>

                                                    <li class="divider" role="presentation"></li>

                                                    @if($document_details->status == COMMON_APPROVED)

                                                        <li>
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left">
                                                            <b>{{ tr('decline') }}</b>
                                                            </a>
                                                        </li>

                                                    @else

                                                        <li>
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left">
                                                            <b>{{ tr('approve') }}</b>
                                                            </a>
                                                        </li>

                                                    @endif

                                                @else

                                                    <li>
                                                        <a href="{{  route('admin.documents.edit', ['document_id' => $document_details->id]) }}"><b>{{ tr('edit') }}</b></a>
                                                    </li>

                                                    <li>
                                                        <a onclick="return confirm(&quot;{{  tr('admin_document_delete_confirmation' , $document_details->name)  }}&quot;)" href="{{  route('admin.documents.delete', ['document_id' => $document_details->id]) }}"><b>{{ tr('delete') }}</b></a>
                                                    </li>

                                                    <li class="divider" role="presentation"></li>

                                                    @if($document_details->status == COMMON_APPROVED)

                                                        <li>
                                                            <a onclick="return confirm(&quot;{{ $document_details->name }} - {{ tr('document_decline_confirmation') }}&quot;)" href="{{  route('admin.documents.status', ['document_id' => $document_details->id] ) }}"><b>{{ tr('decline') }}</b></a>
                                                        </li>

                                                    @else

                                                        <li>
                                                            <a href="{{  route('admin.documents.status', ['document_id' => $document_details->id] ) }}"><b>{{ tr('approve') }}</b></a>
                                                        </li>

                                                    @endif

                                                @endif                  

                                            </ul>

                                        </div>

                                    </td>
                                
                                </tr>

                            @endforeach

                        </tbody>

                    </table>

                    <div align="right">{{ $documents->links() }}</div>
                
                </div>
                
            </div>

        </div>

    </div>

@endsection