<form  action="{{(Setting::get('admin_demo_control') == 1) ? '' : route('admin.static_pages.edit.save')}}" method="POST" enctype="multipart/form-data" role="form">

    <div class="box-body">

        <input type="hidden" name="static_page_id" value="{{$page_details->id}}">
   
        @if($page_details->id != '')

            <div class="form-group">
                <label for="type">*{{ tr('page_type') }}</label>
                <input type="text" class="form-control" name="type" id="title" value="{{  $page_details->type }}" placeholder="{{ tr('enter_type') }}" disabled="true">
            </div>

        @else

            <div class="form-group">

                <label for="select2">*{{tr('page_type')}}</label>
                <select id="select2" name="type" class="form-control" required>
                    <option value="" selected="true">{{tr('choose')}} {{tr('page_type')}}</option>
                    <option value="about">{{tr('about')}}</option>
                    <option value="terms">{{tr('terms')}}</option>
                    <option value="privacy">{{tr('privacy')}}</option>
                    <option value="contact">{{tr('contact')}}</option>
                    <option value="help">{{tr('help')}}</option>
                    <option value="faq">{{tr('faq')}}</option>
                    <option value="others">{{tr('others')}}</option>
                </select>            
            </div>
        @endif  

        <div class="form-group">
            <label for="heading">{{ tr('heading') }} *</label>
            <input type="text" class="form-control" name="heading"  required value="{{ old('heading') ?: $page_details->heading }}" id="heading" placeholder="{{ tr('enter_heading') }}">
        </div>

        <div class="form-group">
            <label for="description">{{ tr('description') }} *</label>

            <textarea id="ckeditor" name="description" class="form-control"  required placeholder="Enter text ...">{{ old('description') ?: $page_details->description }}</textarea>
            
        </div>

    </div>

    <div class="box-footer">

        <button type="reset" class="btn btn-danger">{{tr('cancel')}}</button>

        @if(Setting::get('admin_demo_control'))                     
            <button type="submit" class="btn btn-success pull-right" disabled>{{tr('submit')}}</button>
        @else
            <button type="submit" class="btn btn-success pull-right">{{tr('submit')}}</button>
        @endif

    </div>

</form>