@extends('layouts.admin')

@section('title', tr('edit_page'))

@section('content-header', tr('edit_page'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li><a href="{{route('admin.static_pages.index')}}"><i class="fa fa-book"></i> {{tr('pages')}}</a></li>
    <li class="active"> {{tr('edit_page')}}</li>
@endsection

@section('content')

    <div class="row">

        <div class="col-md-10">

            @include('notification.notify')

        </div>

    </div>
    
    <div class="row">

        <div class="col-md-10">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">
                    <b style="font-size:18px;">{{tr('pages')}}</b>
                    <a href="{{route('admin.static_pages.create')}}" class="btn btn-warning pull-right">
                        <b><i class="fa fa-plus"></i> {{tr('add_page')}}</b>
                    </a>
                </div>

                @include('admin.pages._form')

            </div>

        </div>

    </div>
   
@endsection

@section('scripts')
    <script src="https://cdn.ckeditor.com/4.5.5/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace( 'ckeditor' );
    </script>
@endsection
