@extends('layouts.admin')

@section('title', tr('pages'))

@section('content-header', tr('pages'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>Home</a></li>
    <li class="active"><i class="fa fa-book"></i> {{tr('pages')}}</li>
@endsection

@section('content')

    @include('notification.notify')

    <div class="row">

        <div class="col-xs-12">
          
            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b style="font-size:18px;">{{tr('pages')}}</b>

                    <a href="{{route('admin.static_pages.create')}}" class="btn btn-warning pull-right">
                        <b><i class="fa fa-plus"></i> {{tr('add_page')}}</b>
                    </a>

                </div>

                <div class="box-body">

                    @if(count($pages) > 0)

                        <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                            <thead>
                                <tr>
                                    <th>#{{tr('id')}}</th>
                                    <th>{{tr('heading')}}</th>
                                    <th>{{tr('page_type')}}</th>
                                    <th>{{tr('action')}}</th>
                                </tr>
                            </thead>

                            <tbody>

                                @foreach($pages as $i => $page_details)
                        
                                    <tr>
                                        <td>{{showEntries($_GET,$i+1)}}</td>

                                        <td><a href="{{route('other.pages' , $page_details->unique_id)}}" target="_blank">{{$page_details->heading}}</a></td>

                                        <td>{{$page_details->type}}</td>

                                        <td>
                                            <div class="dropdown @if($i < 2) dropdown @else dropup @endif">
                                        
                                                <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    
                                                    {{tr('action')}}
                                                    <span class="caret"></span>
                                                </button>


                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenu">
                                                
                                                    
                                                    <li role="presentation">
                                                        <a role="menuitem" tabindex="-1" href="{{route('admin.static_pages.edit', ['static_page_id' => $page_details->id] )}}">
                                                            <b>{{tr('edit')}}</b>
                                                        </a>
                                                    </li>

                                                    
                                                    <li role="presentation">
                                                        @if(Setting::get('admin_demo_control'))

                                                            <a role="button" href="javascript:;" class="btn disabled" style="text-align: left"><b>{{tr('delete')}}</b></a>

                                                        @else
                                                            <a role="menuitem" tabindex="-1" onclick="return confirm(&quot;{{ tr('admin_page_delete_confirmation' , $page_details->type) }}&quot;);" href="{{route('admin.static_pages.delete',['static_page_id' => $page_details->id] )}}">
                                                                <b>{{tr('delete')}}</b>
                                                            </a>
                                                        @endif
                                                    </li>

                                                </ul>
                                                
                                            </div>                                                
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        
                        </table>

                        <div align="right">{{$pages->links()}}</div>
                    @else
                        <h3 class="no-result">{{tr('no_result_found')}}</h3>
                    @endif
                
                </div>

            </div>
        </div>
    </div>

@endsection