@extends('layouts.admin')

@section('title', tr('profile'))

@section('content-header', tr('profile'))

@section('breadcrumb')

    <li><a href="#"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>

    <li class="active"><i class="fa fa-diamond"></i> {{tr('account')}}</li>

@endsection

@section('styles')

<style>
    .nav-tabs-custom>.nav-tabs>li.active {
        border-top-color: #00a65a;
    }
</style>

@endsection

@section('content')

    @include('notification.notify')

    <div class="row">

        <div class="col-md-4">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <h5 class="box-title text-uppercase">{{tr('profile')}}</h5>

                </div>

                <div class="box-body box-profile">

                    <img class="profile-user-img img-responsive img-circle" src="@if($admin_details->picture) {{$admin_details->picture}} @else {{asset('placeholder.png')}} @endif" alt="Picture">

                    <h3 class="profile-username text-center">{{$admin_details->name}}</h3>

                    <p class="text-muted text-center">{{tr('admin')}}</p>

                    <ul class="list-group list-group-unbordered">
                        <li class="list-group-item">
                            <b>{{tr('username')}}</b> <a class="pull-right">{{$admin_details->name}}</a>
                        </li>
                        <li class="list-group-item">
                            <b>{{tr('email')}}</b> <a class="pull-right">{{$admin_details->email}}</a>
                        </li>

                        <li class="list-group-item">
                            <b>{{tr('mobile')}}</b> <a class="pull-right">{{$admin_details->mobile}}</a>
                        </li>

                        <li class="list-group-item">
                            <b>{{tr('address')}}</b> <a class="pull-right">{{$admin_details->address}}</a>
                        </li>
                    </ul>
                
                </div>

            </div>

        </div>

         <div class="col-md-8">
            <div class="nav-tabs-custom">

                <ul class="nav nav-tabs">
                    <li class="active"><a href="#adminprofile" data-toggle="tab">{{tr('update_profile')}}</a></li>
                    <li><a href="#image" data-toggle="tab">{{tr('upload_image')}}</a></li>
                    <li><a href="#password" data-toggle="tab">{{tr('change_password')}}</a></li>
                </ul>
               
                <div class="tab-content">
                   
                    <div class="active tab-pane" id="adminprofile">

                        @if(Setting::get('admin_demo_control'))

                            <form class="form-horizontal" action="#" role="form">

                        @else

                            <form class="form-horizontal" action="{{route('admin.profile.save')}}" method="POST" enctype="multipart/form-data" role="form">
                            
                        @endif

                            <input type="hidden" name="id" value="{{$admin_details->id}}">

                            <div class="form-group">
                                <label for="name" required class="col-sm-2 control-label">{{tr('username')}}</label>
                                <div class="col-sm-10">
                                  <input type="text" class="form-control" id="name"  name="name" value="{{ old('name') ?: $admin_details->name}}" placeholder="{{tr('username')}}" onkeydown="return alphaOnly(event);" >
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="email" class="col-sm-2 control-label">{{tr('email')}}</label>

                                <div class="col-sm-10">
                                  <input type="email" required value="{{old('email') ?: $admin_details->email}}" name="email" class="form-control" id="email" placeholder="{{tr('email')}}">
                                </div>
                            </div>


                            <div class="form-group">
                                <label for="mobile" class="col-sm-2 control-label">{{tr('mobile')}}</label>

                                <div class="col-sm-10">
                                  <input type="text" value="{{old('mobile') ?: $admin_details->mobile}}" name="mobile" class="form-control" id="mobile" placeholder="{{tr('mobile')}}" onkeypress="return isNumber(event)" minlength="6" maxlength="16">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">{{tr('address')}}</label>

                                <div class="col-sm-10">
                                  <input type="text" value="{{old('address') ?: $admin_details->address}}" name="address" class="form-control" id="address" placeholder="{{tr('address')}}">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-offset-2 col-sm-10">
                                  <button type="submit" class="btn btn-danger" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>
                                </div>
                            </div>

                        </form>
                    </div>

                    <div class="tab-pane" id="image">

                        @if(Setting::get('admin_demo_control'))

                            <form class="form-horizontal" action="#" role="form">

                        @else

                            <form class="form-horizontal" action="{{route('admin.profile.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        @endif

                            <input type="hidden" name="id" value="{{$admin_details->id}}">

                            @if($admin_details->picture)
                                <img style="height: 90px; margin-bottom: 15px; border-radius:2em;" src="{{$admin_details->picture}}">
                            @else
                                <img style="margin-left: 15px;margin-bottom: 10px" class="profile-user-img img-responsive img-circle"  src="{{asset('placeholder.png')}}">
                            @endif

                            <div class="form-group">
                                <label for="picture" class="col-sm-2 control-label">{{tr('picture')}}</label>

                                <div class="col-sm-10">
                                  <input type="file" required class="form-control" name="picture" id="picture" accept="image/png,image/jpeg" onchange="loadFile(this)">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-offset-2 col-sm-10">
                                  <button type="submit" class="btn btn-danger" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>
                                </div>
                            </div>

                        </form>
                    </div>

                    <div class="tab-pane" id="password">

                        @if(Setting::get('admin_demo_control'))

                            <form class="form-horizontal" action="#" role="form">

                        @else
                        
                            <form class="form-horizontal" action="{{route('admin.change.password')}}" method="POST" enctype="multipart/form-data" role="form">

                        @endif

                            <input type="hidden" name="id" value="{{$admin_details->id}}">

                            <div class="form-group">
                                <label for="old_password" class="col-sm-3 control-label">{{tr('old_password')}}</label>

                                <div class="col-sm-8">
                                    <input required type="password" class="form-control" name="old_password" id="old_password" placeholder="{{tr('old_password')}}">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="password" class="col-sm-3 control-label">{{tr('new_password')}}</label>

                                <div class="col-sm-8">
                                    <input required type="password" class="form-control" name="password" id="password" placeholder="{{tr('new_password')}}">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="password_confirmation" class="col-sm-3 control-label">{{tr('password_confirmation')}}</label>

                                <div class="col-sm-8">
                                    <input required type="password" class="form-control" name="password_confirmation" id="password_confirmation" placeholder="{{tr('password_confirmation')}}">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-offset-2 col-sm-10">
                                    <button type="submit" class="btn btn-danger" @if(Setting::get('admin_demo_control')) disabled @endif >{{tr('submit')}}</button>
                                </div>
                            </div>

                        </form>

                    </div>

                </div>

            </div>
        </div>

    </div>

@endsection