    <form class="form-horizontal" action="{{ route('admin.provider_subscriptions.save') }}" method="POST" enctype="multipart/form-data" role="form">

        <input type="hidden" name="provider_subscription_id" value="{{ $provider_subscription_details->id }}">

        <div class="box-body">
            
            <div class="form-group">

                <div class="col-md-6">

                    <label for="title" class="">* {{ tr('title') }}</label>

                    <input type="text" name="title" class="form-control" id="title" value="{{ old('title') ?: $provider_subscription_details->title }}" placeholder="{{ tr('title') }}" required >
                    
                </div>
                                
                <div class="form-group">

                    <div class="col-md-6">

                        <label>{{ tr('select_category')}} * </label>
                        
                        <select name="category_id" required class="form-control select2" autofocus>

                            <option value="">{{tr('select_category')}} </option>

                            @foreach($categories as $category)

                                @if( $provider_subscription_details->category_id == $category->category_id)
                                    <option value="{{ $category->category_id }}" selected>{{ $category->category_name }}</option>
                                @else
                                    <option value="{{ $category->category_id }}">{{ $category->category_name }}</option>
                                @endif

                            @endforeach

                        </select>                           
                        
                    </div>

                </div>
            </div>

            <div class="form-group">
                
                <!-- <div class="form-group"> -->
                <div class="col-md-6">

                    <label for="plan">* {{ tr('plan') }}</label>

                    <input type="number" min="1" max="12" required name="plan" class="form-control" id="plan" value="{{ old('plan') ?: $provider_subscription_details->plan }}" title="{{ tr('no_of_months') }}" placeholder="{{ tr('no_of_months') }}">
                </div>
                
                <div class="col-md-6">

                    <label for="amount" class="">* {{ tr('amount') }}</label>

                    <input type="number" value="{{ old('amount') ?: $provider_subscription_details->amount }}" name="amount" class="form-control" id="amount" placeholder="{{ tr('amount') }}" step="any" required>
                </div>

                <!-- <div class="form-group"> -->
                <div class="col-md-6" style="display: none">

                    <label for="expiry_date"> * {{ tr('expiry_date') }}</label>
                
                    <input type="text" id="expiry_date" name="expiry_date"  class="form-control" placeholder="{{ tr('expiry_date') }}" value="{{ old('expiry_date') ?: date('d-m-Y',strtotime($provider_subscription_details->expiry_date)) }}" required readonly>
                
                </div>
            </div>

            
            <!-- 
            <div class="form-group">
                <label for="image" class="">
                    {{ tr('image') }} 
                    <br>
                </label>

                <input type="file" name="image" class="form-control" id="image" value="{{ old('image') }}" placeholder="{{ tr('image') }}" accept="image/png, image/jpeg" onchange="loadFile(this, 'image_preview')">

                <br>

                <img src="{{ $provider_subscription_details->image }}" id="image_preview" style="width:100px;height:100px;">
            </div> -->

            <div class="form-group">
            
                <div class="col-md-12">

                    <label for="description" class="">{{ tr('description') }}</label>

                    <textarea id="ckeditor" name="description" class="form-control" placeholder="{{ tr('description') }}.">{{ old('description') ?: $provider_subscription_details->description }}</textarea>

                </div>

            </div>

        </div>

        <div class="box-footer">
             <button type="reset" class="btn btn-danger">{{  tr('cancel')  }}</button>
        
            <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_delete_control') == YES) disabled @endif) >{{  tr('submit')  }}</button>  
        </div>
    </form>