@extends('layouts.admin')

@section('title', tr('provider_subscriptions'))

@section('content-header')

{{tr('provider_subscriptions')}}

    @if($category_details) -

    <a href="{{route('admin.categories.index')}}">
        {{$category_details->name}}
    </a>

    @endif

@endsection

@section('breadcrumb')
     
    <li class="active"><i class="fa fa-key"></i>{{tr('provider_subscriptions')}}</li>
    
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

            <div class="box box-success solid">

                <div class="box-header with-border admin-panel-success">
                    
                    <h3 class="box-title">{{ tr('provider_subscriptions') }}</h3>

                    <a href="{{ route('admin.provider_subscriptions.create') }}" class="btn bg-navy pull-right">{{ tr('add_provider_subscription') }}</a>

                </div>
 
            	<div class="box-body">

					@if(count($provider_subscriptions) > 0)

		              	<table id="example1" class="table table-bordered table-striped">

							<thead>
							    <tr>
    							    <th>{{ tr('id') }}</th>
    							    <th>{{ tr('title') }}</th>
    							    <th>{{ tr('amount') }}</th>
    							    <th>{{ tr('plan') }}</th>
                                    <th>{{ tr('status') }}</th>
                                    <!-- <th>{{ tr('is_popular') }}</th> -->
    							    <th>{{ tr('action') }}</th>
							    </tr>
							</thead>

							<tbody>

								@foreach($provider_subscriptions as $i =>  $provider_subscription_details)

								    <tr>
								      	<td>{{ $i+1 }}</td>

								      	<td>                                            
                                            <a href="{{ route('admin.provider_subscriptions.view', ['provider_subscription_id' => $provider_subscription_details->id])}}" class=""> {{ $provider_subscription_details->title }} </a> 
                                        </td>

								      	<td>
								      		{{ Setting::get('currency') }} {{  $provider_subscription_details->amount }}
								      	</td>

                                        <td>
                                            {{$provider_subscription_details->plan}} {{$provider_subscription_details->plan_type}}
                                        </td>

                                        <td>
                                            @if($provider_subscription_details->status == APPROVED)

                                                <span class="label label-success">{{ tr('approved') }}</span> 
                                            
                                            @else
                                                
                                                <span class="label label-warning">{{ tr('pending') }}</span> 

                                            @endif

                                        </td> 

                                        <!-- <td>
                                            @if($provider_subscription_details->is_popular == YES )

                                                <span class="label label-success">{{ tr('yes') }}</span> 
                                                
                                            @else
                                                <span class="label label-warning">{{ tr('no') }}</span> 

                                            @endif

                                        </td> -->


									    <td>
 											
 											<div class="dropdown"  id="showBtnGroup">

                                            	<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                {{ tr('action') }}
                                                <span class="caret"></span>
                                            	</button>

                                            	<ul class="dropdown-menu" aria-labelledby="dropdownMenu">

                                            	<li>
                                                    <a href="{{  route('admin.provider_subscriptions.view' , ['provider_subscription_id' => $provider_subscription_details->id] ) }}">
                                                        <b>{{ tr('view') }}</b>
                                                    </a>
                                                </li>    

                                                @if(Setting::get('admin_delete_control') == YES)

                                                    <li>
                                                    	<a href="javascript:;" class="btn disabled text-green" style="text-align: left">
                                                    		<b>{{ tr('edit') }}</b>
                                                    	</a>
                                                    </li>
                                                    <li>
                                                    	<a href="javascript:;" class="btn disabled text-red">
                                                        	<b>{{ tr('delete') }}</b>
                                                    	</a>
                                                    </li>

                                                @else

                                                    <li>
                                                    	<a href="{{ route('admin.provider_subscriptions.edit' , ['provider_subscription_id' => $provider_subscription_details->id] ) }}">
                                                    		<b>{{ tr('edit') }}</b>
                                                    	</a> 
                                                    </li>
                                                    <li>
                                                    	<a onclick="return confirm(&quot;{{ tr('admin_provider_subscription_delete_confirmation', $provider_subscription_details->title) }} ?&quot;)" href="{{ route('admin.provider_subscriptions.delete', ['provider_subscription_id' => $provider_subscription_details->id] ) }}">
                                                        	<b>{{ tr('delete') }}</b>
                                                   		</a>
                                                    </li>

                                                @endif

									    		@if($provider_subscription_details->status == APPROVED)

                                                    <li>
                                                        <a href="{{ route('admin.provider_subscriptions.status.change' ,[ 'provider_subscription_id' => $provider_subscription_details->id] ) }}" onclick="return confirm(&quot;{{  $provider_subscription_details->title }} {{  tr('admin_provider_subscription_decline_confirmation') }} &quot;);">
                                                            <b>{{ tr('decline') }}</b>
                                                        </a>
                                                    </li>

                                                @else

                                                	<li>
                                                		<a href="{{ route('admin.provider_subscriptions.status.change' , [ 'provider_subscription_id' => $provider_subscription_details->id] ) }}">
                                                			<b>{{ tr('approve') }}</b>
                                                		</a>
                                                	</li>

                                                @endif

                                                <li>
                                                    <a href="{{ route('admin.provider_subscriptions.payments', [ 'provider_subscription_id' => $provider_subscription_details->id]) }}"> 
                                                        <b>{{ tr('payments') }}</b>
                                                    </a>

                                                </li>


                                                <!-- ! ! ! !FOR LATER PURPOSE. Don't REMOVE % % % % -->

                                                <!-- @if($provider_subscription_details->is_popular == YES)

                                                     <li>
                                                        <a href="{{ route('admin.provider_subscriptions.is_popular' , [ 'provider_subscription_id' => $provider_subscription_details->id] ) }}">
                                                            <b>{{ tr('remove_populor') }}</b>
                                                        </a>
                                                    </li>

                                                @else

                                                    <li>
                                                        <a href="{{ route('admin.provider_subscriptions.is_popular' , [ 'provider_subscription_id' => $provider_subscription_details->id] ) }}">
                                                            <b>{{ tr('add_populor') }}</b>
                                                        </a>
                                                    </li>

                                                @endif -->

									    		
									    		</ul>
									    	</div>

									    </td>

								    </tr>

								@endforeach
							</tbody>

						</table>

					@else

						<h3 class="no-result">{{ tr('no_provider_subscription_found') }}</h3>

					@endif
			
            	</div>

          </div>

        </div>

    </div>

@endsection
