@extends('layouts.admin')

@section('title', tr('provider_subscriptions'))

@section('content-header', tr('provider_subscriptions'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
     <li><a href="{{route('admin.providers.index')}}"><i class="fa fa-users"></i> {{tr('providers')}}</a></li>
    <li class="active"><a href="{{ route('admin.providers.view' , ['provider_id' => $provider_id] ) }}"><i class="fa fa-user"></i> {{tr('view_provider')}}</a></li>
    
    <li class="active"><i class="fa fa-key"></i> {{ tr('provider_subscriptions') }}</li>
@endsection

@section('after-styles')

<style>

.subscription-image {
	overflow: hidden !important;
	position: relative !important;
	height: 15em !important;
	background-position: center !important;
	background-repeat: no-repeat !important;
	background-size: cover !important;
	margin: 0 !important;
	width: 100%;
}

.subscription-desc {
	min-height: 10em !important;
	max-height: 10em !important;
	overflow: scroll !important;
	margin-bottom: 10px !important;
}

</style>

@endsection

@section('content')
	
	<div class="row">
			
        <div class="col-xs-12">
			
			@include('notification.notify')

          	<div class="box">

	            <div class="box-body table-responsive">

	            	@if(count($payments) > 0)

		              	<table id="example1" class="table table-bordered table-striped">

							<thead>
							    <tr>
							      <th>{{ tr('id') }}</th>
							      <th>{{ tr('name') }}</th>
							      <th>{{ tr('provider_subscription') }}</th>
							      <th>{{ tr('payment_id') }}</th>
							      <th>{{ tr('amount') }}</th>
							      <th>{{ tr('expiry_date') }}</th>
							      <th style="display: none">{{ tr('reason') }}</th>
							      <th style="display: none">{{ tr('action') }}</th>
							    </tr>
							</thead>

							<tbody>

								@foreach($payments as $i => $payment_details)

								    <tr>
								      	<td>{{ $i+1 }}</td>

								      	<td><a href="{{ route('admin.providers.view' , ['provider_id' => $payment_details->provider_id] ) }}"> {{ ($payment_details->provider) ? $payment_details->provider->name : '' }} </a></td>

								      	<td>
								      		@if($payment_details->prividersubscription)		
								      			<a href="{{ route('admin.provider_subscriptions.view' , ['provider_subscription_id' => $payment_details->prividersubscription->id] ) }}" target="_blank">{{ $payment_details->prividersubscription ? $payment_details->prividerSubscription->title : '' }}</a>
								      		@endif
								      	</td>

								      	<td>{{ $payment_details->payment_id }}</td>

								      	<td>{{ Setting::get('currency') }} {{ $payment_details->amount }}</td>

								      	<td>{{ date('d M Y',strtotime($payment_details->expiry_date)) }}</td>

								      	<td style="display: none">{{ $payment_details->cancelled_reason }}</td>

								      	<td class="text-center" style="display :none">

								      		@if($i == 0 && !$payment_details->is_cancelled && $payment_details->status == PAID_STATUS) 
								      		<a data-toggle="modal" data-target="#{{ $payment_details->id }}_cancel_subscription" class="pull-right btn btn-sm btn-danger">{{ tr('cancel_subscription') }}</a>

								      		@elseif($i == 0 && $payment_details->is_cancelled && $payment_details->status == PAID_STATUS)

							      				<?php $enable_subscription_notes = tr('enable_subscription_notes') ; ?>
							      			
							      				<a onclick="return confirm('{{ $enable_subscription_notes }}')" href="{{ route('admin.providers.subscriptions.enable', ['provider_id' => $payment_details->provider_id]) }}" class="pull-right btn btn-sm btn-success">{{ tr('enable_subscription') }}</a>

							      			@else
							      				-		
								      		@endif
								      	</td>

								    </tr>

						            <div class="modal fade error-popup" id="{{ $payment_details->id }}_cancel_subscription" role="dialog">

						                <div class="modal-dialog">

						                    <div class="modal-content">

						                   		<form method="post" action="{{ route('admin.providers.subscriptions.cancel', ['provider_id' => $payment_details->provider_id]) }}">

							                        <div class="modal-body">

							                            <div class="media">

							                        		<div class="media-body">

							                                   <h4 class="media-heading">{{ tr('reason') }} *</h4>

							                                   <textarea rows="5" name="cancel_reason" id='cancel_reason' required style="width: 100%"></textarea>

							                               </div>

							                            </div>

							                            <div class="text-right">

							                           		<br>

							                               <button type="submit" class="btn btn-primary top">{{ tr('submit') }}</button>

							                           </div>

							                        </div>

						                        </form>

						                    </div>

						                </div>

						            </div>

								@endforeach

							</tbody>

						</table>

						<div>
							
						</div>

					@else
						<h3 class="no-result">{{ tr('no_provider_subscription_found') }}</h3>
					@endif

	            </div>

          	</div>

        </div>
    
    </div>

	<div class="row">

		<div class="col-md-12">

			<div class="row">

				@if(count($provider_subscriptions) > 0)

					@foreach($provider_subscriptions as $s => $provider_subscription_details)

						<div class="col-md-4 col-lg-4 col-sm-6 col-xs-12">

							<div class="thumbnail">

								<div class="caption">

									<h3>
										<a href="{{ route('admin.provider_subscriptions.view', ['provider_subscription_id' => $provider_subscription_details->id])}}" target="_blank">{{ $provider_subscription_details->title }}</a>
									</h3>

									<hr>


									<h4><b>{{ tr('description') }} : </b></h4>

									<div class="subscription-desc">
										<?php echo $provider_subscription_details->description; ?>
									</div>

									<br>

									<p>
										<span class="btn btn-danger pull-left" style="cursor: default;">{{  Setting::get('currency') }} {{ $provider_subscription_details->amount }} / {{ $provider_subscription_details->plan }} M</span>

										<a href="{{ route('admin.providers.subscriptions.plans.save' , ['provider_subscription_id' => $provider_subscription_details->id, 'provider_id' => $provider_id]) }}" class="btn btn-success pull-right">{{ tr('choose') }}</a>
									</p>
									<br>
									<br>
								</div>
							
							</div>
						
						</div>

					@endforeach

				@endif
				
			</div>
		</div>
	
	</div>

@endsection