@extends('layouts.admin')

@section('title', tr('view_provider_subscription'))

@section('content-header', tr('view_provider_subscription'))

@section('breadcrumb')
     
    <li><a href="{{ route('admin.provider_subscriptions.index') }}"><i class="fa fa-key"></i> {{ tr('provider_subscriptions') }}</a></li>

    <li class="active"><i class="fa fa-eye"></i>&nbsp;{{ tr('view_provider_subscription') }}</li>
@endsection

@section('styles')

<style type="text/css">
    .user-block .username, .user-block .description, .user-block .comment {
        margin-left: 0px;
    }
</style>

@endsection

@section('content')

	<div class="row">
        
        <div class="col-md-12">   

            @include('notification.notify')

        </div>
        
        <div class="col-md-7">   

            <div class="box box-warning solid">

                <div class="box-header label-yellow">

                    <b>{{ $provider_subscription_details->title }}</b>

                    @if($provider_subscription_details->status == APPROVED)
                        
                        <a style="margin-left: 4px" class="btn btn-warning pull-right" href="{{ route('admin.provider_subscriptions.status.change' ,[ 'provider_subscription_id' => $provider_subscription_details->id] ) }}" onclick="return confirm(&quot;{{  $provider_subscription_details->title  }} {{  tr('admin_provider_subscription_decline_confirmation') }} &quot;);" title="{{ tr('decline') }}">  <b>{{ tr('decline') }}</b> </a>
                        
                    @else

                        <a style="margin-left: 4px" class="btn btn-success pull-right" href="{{ route('admin.provider_subscriptions.status.change' , [ 'provider_subscription_id' => $provider_subscription_details->id] ) }}" title="{{ tr('approve') }}"> <b>{{ tr('approve') }}</b> </a>
                     
                    @endif

                    @if(Setting::get('admin_delete_control') == YES )
                       
                        <a style="margin-left: 4px" href="javascript:;" class="btn btn-warning pull-right disabled"  title="{{ tr('edit') }}">
                            <b>{{ tr('edit') }}</b>
                        </a>

                        <a style="margin-left: 4px" href="javascript:;" class="btn btn-danger pull-right disabled"  title="{{ tr('delete') }}">
                            <b>{{ tr('delete') }}</b>
                        </a>
                      
                    @else

                        <a style="margin-left: 4px" class="btn btn-warning pull-right" href="{{ route('admin.provider_subscriptions.edit' , ['provider_subscription_id' => $provider_subscription_details->id] ) }}"  title="{{ tr('edit') }}"> 
                            <b>{{ tr('edit') }}</b>
                        </a> 

                        <a style="margin-left: 4px" onclick="return confirm(&quot;{{ tr('admin_user_delete_confirmation', $provider_subscription_details->title) }} ?&quot;)" href="{{ route('admin.provider_subscriptions.delete', ['provider_subscription_id' => $provider_subscription_details->id] ) }}" class="btn btn-danger pull-right" title="{{ tr('delete') }}">
                            <b>{{ tr('delete') }}</b>
                        </a>
                      
                    @endif

                    <a style="margin-left: 4px" class="btn btn-info pull-right" href="{{ route('admin.provider_subscriptions.payments' , [ 'provider_subscription_id' => $provider_subscription_details->id] ) }}" title="{{ tr('payments') }}">
                      <b>{{ tr('payments') }}</b>
                    </a>

                </div>

                <div class="box box-body">

                    <div class="row margin-bottom">
                   
                        <div class="col-sm-12">

                            <div class="row">

                                <div class="col-sm-12">
                                    
                                    <h5><strong>{{ tr('title') }}</strong> : {{ $provider_subscription_details->title }}<hr>
                                    
                                    <h5><strong>{{ tr('category') }}</strong> : {{ $provider_subscription_details->category_name }}
                                    <hr>

                                    <h5><strong>{{ tr('amount') }}</strong> :
                                        {{ Setting::get('currency') }} {{ $provider_subscription_details->amount }}
                                    </h5><hr>
                                   
                                    <h5><strong>{{ tr('plan') }}</strong> : {{ $provider_subscription_details->plan }} {{$provider_subscription_details->plan_type}}</h5><hr>
                                    
                                    <div style="display: none">
                                   
                                        <h5><strong>{{ tr('expiry_date') }}</strong> : {{ date('d M y',  strtotime($provider_subscription_details->expiry_date)) }}</h5><hr>                           
                                        <strong>{{ tr('is_popular') }} :  </strong>

                                        @if($provider_subscription_details->is_popular == YES)

                                            <span class="label label-primary label-lg">{{ tr('yes') }}</span>

                                        @else

                                            <span class="label label-primary">{{ tr('no') }}</span>

                                        @endif
                                        
                                        <hr>

                                        <strong>{{ tr('is_free_subscription') }} :  </strong>

                                        @if($provider_subscription_details->is_free_subscription == YES)

                                            <span class="label label-primary label-lg">{{ tr('yes') }}</span>

                                        @else

                                            <span class="label label-primary">{{ tr('no') }}</span>

                                        @endif
                                        <hr>

                                    </div>
                                
                                    <strong>{{ tr('total_subscription') }} :  </strong>

                                    <a href="{{ route('admin.provider_subscriptions.payments' , $provider_subscription_details->id) }}" class="btn btn-success btn-xs ">{{ $provider_subscription_details->total_subscriptions }}</a><hr>
                                
                                </div> 

                                <div class="col-sm-12">

                                    <strong>{{ tr('description') }}</strong>

                                    <p><?= $provider_subscription_details->description ?></p>

                                </div>
                            
                            </div>
                    
                        </div>

                    </div>

                </div>

            </div>

        </div>

        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">

            <div class="small-box bg-blue">

                <div class="inner">
                    <h3>{{Setting::get('currency')}} {{$provider_subscription_details->total_revenue}}</h3>
                    <p>{{ tr('total_revenue') }}</p>
                </div>
                
                <div class="icon">
                    <i class="fa fa-key"></i>
                </div>

                <a href="{{ route('admin.provider_subscriptions.payments' , [ 'provider_subscription_id' => $provider_subscription_details->id] ) }}" target="_blank" class="small-box-footer">
                    {{ tr('more_info') }}
                    <i class="fa fa-arrow-circle-right"></i>
                </a>

            </div>

            <div class="small-box bg-green">

                <div class="inner">
                    <h3>{{$provider_subscription_details->total_subscriptions}}</h3>
                    <p>{{ tr('total_subscribers') }}</p>
                </div>
                
                <div class="icon">
                    <i class="fa fa-user"></i>
                </div>

                <a  href="{{ route('admin.provider_subscriptions.payments' , [ 'provider_subscription_id' => $provider_subscription_details->id] ) }}" target="_blank" href="{{ route('admin.users.index') }}" class="small-box-footer">
                    {{ tr('more_info') }}
                    <i class="fa fa-arrow-circle-right"></i>
                </a>

            </div>

        </div>
    
    </div>

@endsection


