

<form class="" action="{{ Setting::get('admin_demo_control') == YES ? '#' : route('admin.providers.save') }}" method="POST" enctype="multipart/form-data" role="form">

    <div class="box-body">

        <input type="hidden" name="provider_id" value="{{ $provider_details->id }}">

        <div class="row">

            <div class="col-md-6">

                <div class="form-group">
                    <label for="username">{{tr('username')}} *</label>

                    <input type="text" required name="name" value="{{ old('name') ?: $provider_details->name }}" class="form-control" id="username" placeholder="{{tr('username')}}" autofocus>
                </div>

                <div class="form-group">

                    <label for="email">{{tr('email')}} *</label>

                    <input type="email" required class="form-control" value="{{ old('email') ?:   $provider_details->email  }}" id="email" name="email" placeholder="{{tr('email')}}">
                </div> 

                <div class="form-group">

                    <label for="description">{{tr('description')}}</label>

                    <textarea style="resize: none;" name="description" class="form-control" placeholder="{{tr('description')}}">{{  old('description') ?: $provider_details->description  }}</textarea>
                    
                </div>

                <div class="form-group">

                    <label for="picture">{{tr('picture')}}</label>

                    <input type="file" class="form-control" id="picture" name="picture" placeholder="{{tr('picture')}}" onchange="loadFile(this)" accept="image/*">
                </div>

            </div>

            <div class="col-md-6">
            
                <div class="form-group">

                    <label for="mobile">{{tr('mobile')}} *</label>

                    <input type="number" required onkeypress="return isNumber(event)" minlength="6" maxlength="16" name="mobile" value="{{ old('mobile') ?: $provider_details->mobile }}" class="form-control" id="mobile" placeholder="{{tr('mobile')}}">
                </div>   

                @if(!$provider_details->id != '')
                <div class="form-group">

                    <label for="password">{{ tr('password') }}<span> *</span></label>

                    <input type="password" required name="password" class="form-control" id="password" placeholder="{{ tr('password') }}">

                </div>

                <div class="form-group">
                    
                    <label for="confirm-password">{{ tr('confirm_password') }}<span> *</span></label>

                    <input type="password" required name="password_confirmation" class="form-control" id="confirm-password" placeholder="{{ tr('confirm_password') }}">

                </div>

                @endif

                <div class="form-group">

                    <label for="video">{{tr('video')}}</label>

                    <input type="file" class="form-control" id="video" accept="video/*" name="video" placeholder="{{tr('video')}}">
                </div>

            </div>
            
        </div>

        <div class="clearfix"></div>                        

    </div>

    <div class="box-footer">
        <button type="reset" class="btn btn-danger">{{tr('reset')}}</button>
        @if(Setting::get('admin_demo_control'))
        <button type="button" class="btn btn-success pull-right" disabled>{{tr('submit')}}</button>
        @else
        <button type="submit" class="btn btn-success pull-right">{{tr('submit')}}</button>
        @endif
    </div>

</form>