@extends('layouts.admin')

@section('title', tr('dashboard'))

@section('content-header', tr('dashboard'))

@section('breadcrumb')

@endsection

@section('content')

	@include('notification.notify')
    
    @php  $provider_id = $provider_details->id ?? 0 @endphp

    <section>
    
        <div class="row">

        	<div class="col-lg-3 col-xs-6">
        	    <div class="small-box bg-green">
        	        <div class="inner">
        	            <h3>{{$data['provider_requests_ongoing']}}</h3>
        	            <p>{{tr('provider_requests_ongoing')}}</p>
        	        </div>

        	        <div class="icon">
        	            <i class="fa fa-user"></i>
        	        </div>

        	        <a href="{{route('admin.users.index')}}" class="small-box-footer">
        	            {{tr('more_info')}}
        	            <i class="fa fa-arrow-circle-right"></i>
        	       	</a>
        	    </div>
        	</div>

        	<div class="col-lg-3 col-xs-6">
        	    <div class="small-box bg-red">
        	        <div class="inner">
        	            <h3>{{$data['provider_requests_upcoming']}}</h3>
        	            <p>{{tr('provider_requests_upcoming')}}</p>
        	        </div>

        	        <div class="icon">
        	            <i class="fa fa-user"></i>
        	        </div>

        	        <a href="{{route('admin.users.index')}}" class="small-box-footer">
        	            {{tr('more_info')}}
        	            <i class="fa fa-arrow-circle-right"></i>
        	       	</a>
        	    </div>
        	</div>        	

        	<div class="col-lg-3 col-xs-6">
        	    <div class="small-box btn-warning">
        	        <div class="inner">
        	            <h3>{{$data['provider_requests_completed']}}</h3>
        	            <p>{{tr('provider_requests_completed')}}</p>
        	        </div>

        	        <div class="icon">
        	            <i class="fa fa-user"></i>
        	        </div>

        	        <a href="{{route('admin.requests.payments',['provider_id' => $provider_id ])}}" class="small-box-footer">
        	            {{tr('more_info')}}
        	            <i class="fa fa-arrow-circle-right"></i>
        	       	</a>
        	    </div>
        	</div>        	

        	<div class="col-lg-3 col-xs-6">
        	    <div class="small-box bg-maroon">
        	        <div class="inner">
        	            <h3>{{$data['total_ernings']}}</h3>
        	            <p>{{tr('provider_total_ernings')}}</p>
        	        </div>

        	        <div class="icon">
        	            <i class="fa fa-user"></i>
        	        </div>
        	        <a href="{{route('admin.requests.payments',['provider_id' => $provider_id ])}}" class="small-box-footer">
        	            {{tr('more_info')}}
        	            <i class="fa fa-arrow-circle-right"></i>
        	       	</a>
        	    </div>
        	</div>

        	<div class="col-lg-3 col-xs-6">
        	    <div class="small-box btn-warning">
        	        <div class="inner">
        	            <h3>{{formatted_amount($data['provider_amount'])}}</h3>
        	            <p>{{tr('provider_amount')}}</p>
        	        </div>

        	        <div class="icon">
        	            <i class="fa fa-user"></i>
        	        </div>

        	        <a href="{{route('admin.users.index')}}" class="small-box-footer">
        	            {{tr('more_info')}}
        	            <i class="fa fa-arrow-circle-right"></i>
        	       	</a>
        	    </div>
        	</div>        	

        	<div class="col-lg-3 col-xs-6">

        	    <div class="small-box bg-maroon">
        	        <div class="inner">
        	            <h3>{{formatted_amount($data['admin_amount'])}}</h3>
        	            <p>{{tr('admin_amount')}}</p>
        	        </div>

        	        <div class="icon">
        	            <i class="fa fa-user"></i>
        	        </div>

        	        <a href="{{route('admin.users.index')}}" class="small-box-footer">
        	            {{tr('more_info')}}
        	            <i class="fa fa-arrow-circle-right"></i>
        	       	</a>
        	    </div>
        	
        	</div>
        
        </div>

    </section>

@endsection

@section('scripts')


@endsection