@extends('layouts.admin')

@section('title', tr('view_documents'))

@section('content-header')

{{ tr('view_documents') }}

@if($provider_details)

<a href="{{ route('admin.providers.view' , [ 'provider_id' => $provider_details->id]) }}"> 
    - {{ $provider_details ? $provider_details->name : "" }}
</a>

@endif

@if($document_details)

<a href="{{ route('admin.documents.index') }}"> 
   - {{ $document_details ? $document_details->name : "" }}
</a>

@endif

@endsection

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li><a href="{{ route('admin.providers.index') }}"><i class="fa fa-users"></i> {{ tr('providers') }}</a></li>
    <li class="active"><i class="fa fa-file-o"></i> {{ tr('view_documents') }}</li>
@endsection

@section('content')

    @include('notification.notify')

    <div class="row">
        <div class="col-xs-12">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                </div>

                <div class="box-body">

                    @if(count($provider_documents) > 0)

                        <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                            <thead>
                                <tr>
                                    <th>{{ tr('id') }}</th>
                                    <th>{{ tr('provider') }}</th>
                                    <th>{{ tr('document_type') }}</th>
                                    <th>{{ tr('view') }}</th>
                                </tr>
                            </thead>

                            <tbody>

                                @foreach($provider_documents as $index => $provider_document_details)

                                    <tr>
                                        <td>{{ showEntries($_GET,$index+1) }}</td>

                                        <td><a href="{{ route('admin.providers.view' , ['provider_id' => $provider_document_details->provider_id]) }}"> {{ $provider_document_details->provider ? $provider_document_details->provider->name : "" }}</a></td>

                                        <td>{{ $provider_document_details->document->name }}</td>

                                        <td><a href="{{ $provider_document_details->document_url }}" target="_blank"><span class="btn btn-info btn-large">{{ tr('view') }}</span></a></td>

                                    </tr>

                                @endforeach

                            </tbody>

                        </table>

                        <div align="right">{{ $provider_documents->links() }}</div>

                    @else

                        <h3 class="no-result">{{ tr('no_result_found') }}</h3>

                    @endif
               
                </div>

            </div>
            
        </div>

    </div>

@endsection
