@extends('layouts.admin')

@section('title', tr('edit_provider'))

@section('content-header', tr('edit_provider'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li><a href="{{route('admin.providers.index')}}"><i class="fa fa-users"></i> {{tr('providers')}}</a></li>
    <li class="active">{{tr('edit_provider')}}</li>
@endsection

@section('content')

    <div class="row">

        <div class="col-md-10 col-md-offset-1">

            @include('notification.notify')

        </div>

    </div>
    
    <div class="row">

        <div class="col-md-10 col-md-offset-1">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b>{{tr('edit_provider')}}</b>

                    <a href="{{route('admin.providers.create')}}" style="float:right" class="btn btn-warning">
                        <b><i class="fa fa-plus"></i> {{tr('add_provider')}}</b>
                    </a>
                </div>

                @include('admin.providers._form')
                            
            </div>

        </div>

    </div>

@endsection

@section('scripts')


    <script type="text/javascript">

        $(function () {

            $('#category').change(function(){

                var id = $(this).val();
                
                var url = "{{ url('select/sub_category')}}";
                
                $.post(url,{ option: id },
                
                    function(data) {

                        $('#sub_category').empty(); 

                        $('#sub_category').append("<option value=''>Select Sub category</option>");

                        if(data.length != 0) {
                            document.getElementById("sub_category").disabled=false;
                        } else {
                            document.getElementById("sub_category").disabled=true;
                        }

                        $.each(data, function(index, element) {
                            $('#sub_category').append("<option value='"+ element.id +"'>" + element.name + "</option>");
                        });
                });

            });

        });
    </script>

@endsection


