@extends('layouts.admin')

@section('title', tr('galleries'))

@section('content-header')

{{tr('galleries')}} - 

<a href="{{route('admin.providers.view' , ['provider_id' => $provider_details->id])}}"> {{$provider_details->name}}</a>

@endsection

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>

    <li><a href="{{route('admin.providers.index')}}"><i class="fa fa-users"></i> {{tr('providers')}}</a></li>

    <li class="active"> {{tr('galleries')}}</li>
@endsection

@section('after-styles')

<style>
    .btn:focus, .btn:active, button:focus, button:active {
        outline: none !important;
        box-shadow: none !important;
    }

    #image-gallery .modal-footer{
        display: block;
    }

    .thumb{
        margin-top: 15px;
        margin-bottom: 15px;
    }
</style>
@endsection

@section('content')

    @include('notification.notify')

    <div class="row">

        <div class="col-xs-12">

            <form action="{{route('admin.providers.gallery.save')}}" method="POST" enctype="multipart/form-data" role="form">

                <input type="hidden" name="provider_id" value="{{$provider_details->id}}">

                <div class="row">

                    <p style="margin: 10px 10px 10px 20px">{{tr('upload_picture')}}</p>

                    <div class="col-md-4">

                        <div class="form-group">

                            <input type="file" name="picture" class="form-control" accept="image/*">

                        </div>
                    </div>

                    <div class="col-md-4">

                        <button type="submit" class="btn btn-success">{{tr('upload')}}</button>

                    </div>

                </div>

            </form>

        </div>

            @if(count($galleries) > 0)

                @foreach($galleries as $gallery_details)

                <div class="col-lg-3 col-md-4 col-xs-6 thumb">

                    <a class="thumbnail" href="#" data-image-id="" data-toggle="modal" data-title="{{Setting::get('site_name')}}" data-image="{{$gallery_details->picture}}" data-target="#image-gallery">
                        <img class="img-thumbnail" src="{{$gallery_details->picture}}" alt="{{Setting::get('site_name')}}" style="width: 500px; height: 200px;">
                    </a>
                </div>

                @endforeach

            @else

                <div class="col-md-12">

                    <h4 style="color: gray">{{tr('no_result_found')}}</h4>

                    <!-- <a href="{{route('admin.providers.index')}}" class="btn btn-warning text-uppercase"> <i class="fa fa-arrow-left"></i> {{tr('view_providers')}}</a> -->

                </div>

            @endif

        </div>
    </div>

@endsection

@section('after-scripts')

@endsection
