@extends('layouts.admin')

@section('title', tr('view_history'))

@section('content-header')

{{ tr('view_history') }}

<a href="{{ route('admin.providers.view' , ['provider_id' => $provider_details->id]) }}">

- {{ $provider_details->name }}

</a>

@endsection

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li><a href="{{ route('admin.providers.index') }}"><i class="fa fa-users"></i> {{ tr('providers') }}</a></li>
    <li class="active"> {{ tr('view_history') }}</li>
@endsection

@section('content')

    @include('notification.notify')

    <div class="row">

        <div class="col-xs-12">
            
            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">
                    <b>{{ tr('history') }}</b>
                    <a href="{{ route('admin.providers.index') }}" style="float:right" class="btn btn-default">{{ tr('view_providers') }}</a>
                </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                            <tr>
                                <th>{{ tr('s_no') }}</th>
                                <th>{{ tr('title') }}</th>                                
                                <th class="min">{{ tr('user') }}</th>
                                <th>{{ tr('job_type') }}</th>
                                <th class="min">{{ tr('request_date') }}</th>
                                <th>{{ tr('status') }}</th>
                                <th>{{ tr('total') }}</th>
                                <th>{{ tr('action') }}</th>
                            </tr>
                        </thead>

                        <tbody>

                            @foreach($requests as $index => $request_details)
                            
                                <tr>

                                   <td>{{ showEntries($_GET,$index+1) }}</td>

                                    <td><a href="{{ route('admin.requests.view' ,['request_unique_id' =>  $request_details->unique_id] ) }}"> {{ $request_details->name  }}</a></td>
                                    <td>
                                        <a href="{{ route('admin.users.view' , ['user_id' => $request_details->user_id] ) }}"> {{ $request_details->user->name ?? tr('user_not_available') }}</a>
                                    </td>                        
                                    <td>{{ job_type($request_details->job_type) }}</td>   
                                    <td>{{ common_date($request_details->request_date, Auth::guard('admin')->user()->timezone) }}</td>

                                    <td>{{ request_status($request_details->status) }}</td>

                                    <td>{{ $request_details->currency }} {{ $request_details->total }}</td>

                                    <td>
                                        <a href="{{ route('admin.requests.view' , ['request_unique_id' => $request_details->unique_id] ) }}" class="btn btn-success"><i class="fa fa-eye"></i> <b>{{ tr('view') }}</b></a>
                                       
                                    </td>
                                
                                </tr>
                            
                            @endforeach
                        
                        </tbody>

                    </table>

                    <div align="right">{{ $requests->links() }}</div>

                    </div>

            </div>

        </div>

    </div>

@endsection
