@extends('layouts.admin')

@section('title', tr('providers'))

@section('content-header', tr('providers'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li class="active"><i class="fa fa-users"></i> {{ tr('providers') }}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

          	<div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
                
                	<b>{{ tr('providers') }}</b>

	                <a href="{{route('admin.providers.create') }}" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-plus"></i> {{ tr('add_provider' ) }}</b>
	                </a>

	                <!-- EXPORT OPTION START -->

					@if( count( $providers ) > 0 )
	                
		                <ul class="admin-action btn btn-danger pull-right" style="margin-right: 20px">
		                 	
							<li class="dropdown">
				                <a class="dropdown-toggle text-white" data-toggle="dropdown" href="#">
				                  	<b>{{ tr('export') }} <span class="caret"></span></b>
				                </a>
				                <ul class="dropdown-menu">
				                  	<li role="presentation">
				                  		<a role="menuitem" tabindex="-1" href="{{route('admin.providers.export' , ['format' => 'xls'])}}">
				                  			<span class="text-red"><b>{{ tr('excel_sheet') }}</b></span>
				                  		</a>
				                  	</li>

				                  	<li role="presentation">
				                  		<a role="menuitem" tabindex="-1" href="{{route('admin.providers.export' , ['format' => 'csv'])}}">
				                  			<span class="text-blue"><b>{{ tr('csv') }}</b></span>
				                  		</a>
				                  	</li>
				                </ul>
							</li>
						</ul>

					@endif

		            <!-- EXPORT OPTION END -->
            	</div>
            
	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      	<th>{{ tr('id') }}</th>

						      	<th>{{ tr('name') }}</th>

						      	<th>{{ tr('email') }}</th>

						      	<th>{{ tr('mobile') }}</th>
						      	
						      	<th>{{ tr('provider_payout') }}</th>

						      	@if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON)
							      	<th>{{ tr('email_verification') }}</th>
							    @endif

						      	<th>{{ tr('status') }}</th>

						      	@if(Setting::get('redeem_control'))
						      	
						      	<th>{{ tr('redeems') }}</th>

						      	@endif

						      	<th>{{ tr('action') }}</th>

						    </tr>

						</thead>

						<tbody>

							@foreach( $providers as $i => $provider_details)

							    <tr>
							      	<td>{{showEntries($_GET,$i+1)}}</td>

							      	<td>
							      		<a href="{{route('admin.providers.view' , ['provider_id' => $provider_details->id])}}"> 
							      			{{ $provider_details->name }}

							      			@if( $provider_details->is_available == PROVIDER_AVAILABLE )
							      				<span class="text-green pull-right"><i class="fa fa-circle text-success"></i></span>

							      			@else
							      				<span class="text-red pull-right"><i class="fa fa-circle"></i></span>

							      			@endif
							      		</a>
							      	</td>

							      	<td>{{ $provider_details->email }}</td>

							      	<td>{{ $provider_details->mobile }}</td>

							      	<td>
							      		@if($provider_details->providerPayment)

							      			<?php

							      				$amount_details = get_provider_amount($provider_details->id);

							      				$provider_amount = $amount_details ? $amount_details->provider_amount : "0.00";

							      				$payout = $provider_amount - $provider_details->providerPayment->cod; 

			                					$payout = $payout - $provider_details->providerPayment->paid_amount; 

							      			?>

							      			{{ Setting::get('currency') }} {{ $payout ? $payout : 0.00 }}

							      		@else
							      			{{ Setting::get('currency') }} 0.00
							      		@endif					 
							      	</td>

							      	@if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON)

								      	<td>

									      	@if($provider_details->is_verified == PROVIDER_EMAIL_NOT_VERIFIED)

									      		<a href="{{route('admin.providers.verify' , ['provider_id' => $provider_details->id])}}" class="btn btn-xs btn-success" onclick="return confirm(&quot;{{ $provider_details->name }} - {{ tr('provider_email_confirmation') }}&quot;);">{{ tr('verify') }}</a>

									      	@else

									      		<span>{{ tr('verified') }}</span>

									      	@endif
								      	
								    	</td>

								    @endif

							      	<td>
							      		@if($provider_details->is_approved == PROVIDER_APPROVED)

							      			<span class="label label-success text-uppercase">{{ tr('approved') }}</span>

							       		@elseif($provider_details->is_approved == PROVIDER_STATUS_PENDING)

							       			<span class="label label-warning text-uppercase">{{ tr('pending') }}</span>

							       		@else
							       			<span class="label label-danger text-uppercase">{{ tr('declined') }}</span>
							       		@endif
							       	</td>

							       	@if(Setting::get('redeem_control'))

							       		<td><b>{{Setting::get('currency') }} {{$provider_details->providerPayment ? number_format($provider_details->providerPayment->wallet , 2) : "0.00"}}</b></td>

							       	@endif

									<td>

										<div class="dropdown @if($i < 2) dropdown @else dropup @endif">
											
											<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
												{{ tr('action') }}
												<span class="caret"></span>
											</button>

											<ul class="dropdown-menu" aria-labelledby="dropdownMenu">

												<li>
													<a href="{{route('admin.providers.view' , ['provider_id' => $provider_details->id])}}"><b>{{ tr('view') }}</b></a>
												</li>

												@if(Setting::get('admin_demo_control'))

													<li>
														<a href="javascript:;" class="btn disabled" style="text-align: left;"><b>{{ tr('edit') }}</b></a>
													</li>

													<li>
														<a href="javascript:;" class="btn disabled" style="text-align: left"><b>{{ tr('delete') }}</b></a>	
													</li>

												@else

													<li>

														<a href="{{ route('admin.providers.edit' ,['provider_id' => $provider_details->id]) }}"><b>{{ tr('edit') }}</b></a>

													</li>

													<li>
														<a onclick="return confirm(&quot;{{ tr('admin_provider_delete_confirmation' , $provider_details->name)}}&quot;);" href="{{ route('admin.providers.delete', ['provider_id' => $provider_details->id]) }}"><b>{{ tr('delete') }}</b></a>

													</li>

												@endif																	
												<li role="separator" class="divider"></li>

												@if(in_array($provider_details->is_approved , [PROVIDER_STATUS_PENDING , PROVIDER_DECLINED]))

													<li>
							                  			<a href="{{ route('admin.providers.approve' ,  ['provider_id' => $provider_details->id]) }}" class="text-green">
							                  				<b>{{ tr('approve') }}</b>
							                  			</a>
							                  		</li>

							                  	@else

							                  		<li>
							                  			<a href="{{ route('admin.providers.approve' , ['provider_id' => $provider_details->id]) }}" onclick="return confirm(&quot;{{$provider_details->name}} - {{ tr('provider_decline_confirmation') }}&quot;);">
							                  				<b>{{ tr('decline') }}</b>
							                  			</a>
							                  		</li>

							                  	@endif
							              
												<li role="separator" class="divider"></li>

												<li>
								              		<a href="{{route('admin.providers.services' , ['provider_id' => $provider_details->id] )}}">
								              			<b>{{ tr('services') }}</b>
								              		</a>
								              	</li>

								              	<li>
								              		<a href="{{route('admin.providers.gallery' , ['provider_id' => $provider_details->id])}}">
								              			<b>{{ tr('gallery') }}</b>
								              		</a>
								              	</li>


												@if(Setting::get('redeem_control'))

													<li>
														<a role="menuitem" tabindex="-1" href="{{route('admin.providers.redeems' , $provider_details->id)}}"><b>{{ tr('redeems') }}</b></a>
													</li>

													<li role="separator" class="divider"></li>

												@endif

												<li>
								              		<a href="{{route('admin.providers.document', ['provider_id' => $provider_details->id] )}}">
								              			<b>{{ tr('documents') }}</b>
								              		</a>
								              	</li>

								              	<li>
								              		<a href="{{route('admin.providers.history' , ['provider_id' => $provider_details->id])}}">
								              			<b>{{ tr('view_history') }}</b>
								              		</a>
								              	</li>

								              	<li>	
              										<a href="{{ route('admin.provider_subscriptions.plans' , ['provider_id' => $provider_details->id]) }}" >
								              		<b>{{ tr('plans') }}</b>
								              		</a>	       		
								              	</li>    	

								              	<li>	
              										<a href="{{ route('admin.providers.dashboard' , ['provider_id' => $provider_details->id]) }}" >
								              		<b>{{ tr('dashboard') }}</b>
								              		</a>	       		
								              	</li>

											</ul>

										</div>
									</td>
							    </tr>
							@endforeach
						</tbody>
					
					</table>
					<div align="right">{{ $providers->links()}}</div>
	            
	            </div>

          	</div>
        </div>
    </div>

@endsection
