@extends('layouts.admin')

@section('title', tr('user_payments'))

@section('content-header',tr('user_payments'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li class="active"> {{tr('user_payments')}}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

          	<div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
	                <b>{{tr('user_payments')}}</b>
	                <a href="{{route('admin.users.index')}}" style="float:right" class="btn btn-default">{{tr('view_users')}}</a>
	            </div>

	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      <th>{{tr('id')}}</th>
						      <th>{{tr('username')}}</th>
						      <th>{{tr('post')}}</th>
						      <th>{{tr('payment_id')}}</th>
						      <th>{{tr('amount')}}</th>
						    </tr>
						</thead>

						<tbody>

							@foreach($data as $i => $payment)

							    <tr>
							      	<td>{{showEntries($_GET,$i+1)}}</td>
							      	<td><a href="{{route('admin.users.view' , ['user_id' => $payment->user_id] )}}"> {{$payment->user->name ?? tr('user_not_available')}} </a></td>
							      	<td>
							      		<a href="{{route('admin.posts.view' , $payment->post_id)}}"> 
							      			{{tr('view')}} 
							      		</a>
							      	</td>
							      	<td>{{$payment->payment_id}}</td>
							      	<td>$ {{$payment->amount}}</td>
							    </tr>					

							@endforeach
						</tbody>
					
					</table>
					<div align="right">{{$data->links()}}</div>
	            </div>

          	</div>
        </div>
    </div>

@endsection


