    @extends('layouts.admin')

@section('title', tr('services'))

@section('content-header')

{{ tr('services') }}

<a href="{{ route('admin.providers.view' , ['provider_id' => $provider_details->id]) }}">

- {{ $provider_details->name }}

</a>

@endsection

@section('breadcrumb')

    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>

    <li><a href="{{ route('admin.providers.index') }}"><i class="fa fa-users"></i> {{ tr('providers') }}</a></li>

    <li class="active">{{ tr('services') }}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">
            
            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

	                <b>{{ tr('services') }}</b>

	                <a href="{{ route('admin.providers.index') }}" style="float:right" class="btn btn-default">{{ tr('view_providers') }}</a>
                    
	            </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                            <tr>
                                <th>{{ tr('s_no') }}</th>
                                <th>{{ tr('category') }}</th>
                                <th>{{ tr('sub_category') }}</th>
                                <th>{{ tr('price_per_hour') }}</th>
                                <th>{{ tr('description') }}</th>
                                <th>{{ tr('joined') }}</th>
                                <th>{{ tr('updated') }}</th>
                                <th>{{ tr('status') }}</th>
                            </tr>
                        </thead>

                        <tbody>

                            @foreach($provider_services as $i => $provider_service_details)
                            
                                <tr>

                                    <td>{{ showEntries($_GET,$i+1) }}</td>

                                    <td>
                                        {{ $provider_service_details->category ? $provider_service_details->category->name : " - " }}
                                    </td>
                                    
                                    <td>
                                        {{ $provider_service_details->subCategory ? $provider_service_details->subCategory->name : "-"  }}
                                    </td>                        

                                    <td>
                                        {{ $provider_service_details->price_per_hour ? $provider_service_details->price_per_hour : "0.00" }}
                                    </td>

                                    <td>
                                        {{ $provider_service_details->description ? $provider_service_details->description : " - " }}
                                    </td>

                                    <td>
                                        {{ date('d-m-Y H:i:s' , strtotime($provider_service_details->created_at)) }}
                                    </td>

                                    <td>
                                        {{ date('d-m-Y H:i:s' , strtotime($provider_service_details->updated_at)) }}
                                    </td>

                                    <td>
                                        @if($provider_service_details->status)
                                            <span class="label label-success">{{ tr('available') }}</span>
                                        @endif
                                    </td>
                                
                                </tr>
                            
                            @endforeach
                        
                        </tbody>

            		</table>

			         <div align="right">{{ $provider_services->links() }}</div>
                </div>

            </div>

        </div>
        
    </div>

@endsection
