@extends('layouts.admin')

@section('title', tr('provider_payments'))

@section('content-header',tr('provider_payments'))

@section('breadcrumb')
     
    <li class="active"><i class="fa fa-money"></i> {{ tr('provider_payments') }}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

        	<div class="box box-warning solid">

                <div class="box-header with-border">

                    <h3 class="box-title">{{ tr('provider_payments') }}</h3>
                
                </div>

	            <div class="box-body">

	            	<div class="table table-responsive">

	              	<table id="example1" class="table table-bordered table-striped ">

						<thead>
						    <tr>
								<th>{{ tr('id') }}</th>
								<th>{{ tr('provider') }}</th>
								<th>{{ tr('subscription') }}</th>
								<th>{{ tr('payment_id') }}</th>
								<th>{{ tr('total') }}</th>
								<th>{{ tr('date') }}</th>
								<th>{{ tr('status') }}</th>
						    </tr>
						</thead>

						<tbody>

							@if(count($provider_subscription_payments) > 0)

								@foreach($provider_subscription_payments as $i => $provider_subscription_payment_details)

								    <tr>

								      	<td>{{ $i+1 }}</td>
								      	
								      	<td>
								      	@if($provider_subscription_payment_details->provider)

								      		<a href="{{ route('admin.providers.view' ,['provider_id' => $provider_subscription_payment_details->provider->id] ) }}"> 

								      		{{ $provider_subscription_payment_details->provider->name }}

								      		</a>

								      	@else

								      		-

								      	@endif

								      	</td>

								      	<td>{{ $provider_subscription_payment_details->prividerSubscription ?   $provider_subscription_payment_details->prividerSubscription->title : '-' }} 

								      	</td>

								      	<td>{{ $provider_subscription_payment_details->payment_id }}</td
								      	>
								      	<td>{{ Setting::get('currency') }} {{ $provider_subscription_payment_details->amount }}</td>

								      	<td>@if($provider_subscription_payment_details->created_at) {{ $provider_subscription_payment_details->created_at->diffForHumans() }} @endif</td>
								  
								      	<td>
								      		@if($provider_subscription_payment_details->status) 
								      			<span style="color: green;"><b>{{ tr('paid') }}</b></span>
								      		@else
								      			<span style="color: red"><b>{{ tr('not_paid') }}</b></span>

								      		@endif
								      	</td>

								    </tr>					

								@endforeach

							@endif

						</tbody>
					
					</table>

					</div>

	            </div>

          	</div>

        </div>

    </div>

@endsection


