@extends('layouts.admin')

@section('title', tr('view_provider'))

@section('content-header', tr('view_provider'))

@section('breadcrumb')

    <li><a href="{{route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>

    <li><a href="{{route('admin.providers.index') }}"><i class="fa fa-users"></i> {{ tr('providers') }}</a></li>

    <li class="active"> {{ tr('view_provider') }}</li>

@endsection


@section('styles')

<link rel="stylesheet" href="{{asset('assets/css/star-rating.css') }}">

<style>
	
	dt {
		padding: 4px !important; 
	}

	dd {
		padding: 4px !important;
	}

	table {
	    font-family: arial, sans-serif;
	    border-collapse: collapse;
	    width: 100%;
	}

	td, th {
	    border: 1px solid #dddddd;
	    text-align: left;
	    padding: 8px;
	}

	tr:nth-child(even) {
	    background-color: #28ae5217;
	}

	td:nth-child(odd) {
	    color:#0000008a;
	}

	.rv-desc {
		line-height: 1.6;
	    letter-spacing: 0.6px;
	    font-size: 14px;
	}

	.timeline::before {
	    content: '';
	    position: absolute;
	    top: 0;
	    bottom: 0;
	    width: 0;
	    background: #fff;
	    left: 0px;
	    margin: 0;
	    border-radius: 0px;
	}

</style>

@endsection

@section('content')

	<div class="row">

		<div class="col-md-11">

			@include('notification.notify')

		</div>

	</div>
	
	<div class="row">

		<div class="col-md-6">

    		<div class="box box-widget widget-user-2">

            	<div class="widget-user-header bg-green-gradient">
              		<div class="widget-user-image">
                		<img class="img-circle" src="@if( $provider_details->picture) {{ $provider_details->picture}} @else {{asset('admin-css/dist/img/avatar.png') }} @endif" alt="User Avatar">
              		</div>

              		<h3 class="widget-user-username"><b>{{ $provider_details->name}} </b></h3>

      				<h5 class="widget-user-desc"><b>{{ tr('provider') }}</b></h5>

      				<p>
      					<input id="view_rating" name="rating" type="number" class="rating view_rating" min="1" max="5" step="1" value="{{provider_rating( $provider_details->id) }}">
      				</p>
            	</div>

            	<div class="box-footer no-padding">

            		<p style="margin: 10px">
            			{{ $provider_details->description}}
            		</p>

            		<table>
					    
				    	<tr>
					        <td>{{ tr('name') }}</td>
					        <td>{{ $provider_details->name}}</td>
					    </tr>

					    <tr>
					        <td>{{ tr('email') }}</td>

					        <td> 
					        	{{ $provider_details->email}} 
					        </td>
					    </tr>

					    <tr>
					        <td>{{ tr('paypal_email') }}</td>

					        <td> 
					        	{{ $provider_details->paypal_email}} 
					        </td>
					    </tr>

					    <tr>
					        <td>{{ tr('mobile') }}</td>

					        <td> 
					        	{{ $provider_details->mobile}} 
					        </td>
					    </tr>

					    <tr>
					    	<td>{{ tr('status') }}</td>

					    	<td>

			                    @if( $provider_details->is_approved == PROVIDER_APPROVED)

					      			<span class="label label-success text-uppercase"> 
					      				<i class="fa fa-check-circle"></i> {{ tr('approved') }}
					      			</span>

					       		@elseif( $provider_details->is_approved == PROVIDER_STATUS_PENDING)

					       			<span class="label label-warning text-uppercase">
					       				<i class="fa fa-times"></i> {{ tr('pending') }}
					       			</span>

					       		@else
					       			<span class="label label-danger text-uppercase">
					       				<i class="fa fa-times"></i> {{ tr('declined') }}
					       			</span>
					       		@endif
					    	</td>
					    </tr>

					    <tr>
					    	<td>{{ tr('is_verified') }}</td>

					    	<td>
							   	@if( $provider_details->is_verified == PROVIDER_EMAIL_VERIFIED)
			                       	
			                       	<span class="text-green text-uppercase"><i class="fa fa-check-circle"></i> {{ tr('yes') }}</span>

			                    @else
			                    	
			                    	<span class="text-red text-uppercase"><i class="fa fa-times"></i> {{ tr('no') }}</span>

			                    @endif
					    	</td>
					    </tr>

					    <tr>
					        <td>{{ tr('payment_mode') }}</td>

					        <td> 
					        	{{ $provider_details->payment_mode}} 
					        </td>
					    </tr>

					    <tr>
					        <td>{{ tr('device_type') }}</td>

					        <td> 
					        	<span class="text-uppercase">{{ $provider_details->device_type}} </span>
					        </td>
					    </tr>			    

					    <tr>
					        <td>{{ tr('login_by') }}</td>

					        <td> 
					        	<span class="text-uppercase">{{ $provider_details->login_by}} </span>
					        </td>
					    </tr>

					    <tr>
					        <td>{{ tr('login_status') }}</td>

					        <td> 
					        	<span class="text-uppercase">{{ $provider_details->login_status}} </span>
					        </td>
					    </tr>

					    <tr>
					        <td>{{ tr('register_type') }}</td>

					        <td> 
					        	<span class="text-uppercase">{{ $provider_details->register_type}} </span>
					        </td>
					    </tr>

					    <tr>
					        <td>{{ tr('timezone') }}</td>

					        <td> 
					        	{{ $provider_details->timezone}} 
					        </td>
					    </tr>

					    <tr>
					    	<td style="width: 40%">{{ tr('waiting_to_respond') }}</td>

					    	<td>
	                			@if( $provider_details->waiting_to_respond == WAITING_TO_RESPOND) 
					      			<span class="label label-success text-uppercase">{{ tr('yes') }}</span>
					       		@else 
					       			<span class="label label-warning text-uppercase">{{ tr('no') }}</span>
					       		@endif
					    	</td>
					    </tr>

					    <tr>
					    	<td>{{ tr('available') }}</td>
					    	<td>
					    		@if( $provider_details->is_available == PROVIDER_AVAILABLE && $provider_details->is_approved == PROVIDER_APPROVED) 
					      			<span class="label label-success text-uppercase">{{ tr('yes') }}</span>
					       		@else 
					       			<span class="label label-warning text-uppercase">{{ tr('no') }}</span>
					       		@endif
					    	</td>
					    </tr>

					    <tr>
					    	<td>{{ tr('video') }}</td>
					    	<td>
					    		@if( $provider_details->video)

					    			<a href="{{ $provider_details->video }}" target="_blank">{{ tr('view_video') }}</a>

					    		@else

					    			-

					    		@endif
					    	</td>
					    </tr>

					    <tr>
					    	<td>{{ tr('gallery') }}</td>
					    	<td>
					    		
					    		<a href="{{route('admin.providers.gallery' , ['provider_id' =>  $provider_details->id]) }}" target="_blank">
					    			{{ tr('view_gallery') }}
					    		</a>

					    	</td>
					    </tr>

					    <tr>
					    	<td>{{ tr('joined') }}</td>
					    	<td>
					    		{{common_date( $provider_details->created_at , Auth::guard('admin')->user()->timezone)}}
					    	</td>
					    </tr>

					    <tr>
					    	<td>{{ tr('updated_at') }}</td>
					    	<td>
					    		{{ common_date( $provider_details->updated_at , Auth::guard('admin')->user()->timezone) }}
					    	</td>
					    </tr>

					</table>
            	
            	</div>

            	<div class="box-footer">

					@if(Setting::get('admin_demo_control'))

						<a href="javascript:;" class="btn disabled" style="text-align: left;" class="btn btn-warning  text-center"><b>{{ tr('edit') }}</b></a>

						<a href="javascript:;" class="btn disabled" style="text-align: left" class="btn btn-danger text-center"><b>{{ tr('delete') }}</b></a>	

					@else

						<a href="{{ route('admin.providers.edit' ,['provider_id' => $provider_details->id]) }}" class="btn btn-warning  text-center"><b>{{ tr('edit') }}</b></a>

						<a onclick="return confirm(&quot;{{ tr('admin_provider_delete_confirmation' , $provider_details->name)}}&quot;);" href="{{ route('admin.providers.delete', ['provider_id' => $provider_details->id]) }}" class="btn btn-danger text-center"><b>{{ tr('delete') }}</b></a>

					@endif

					@if(in_array($provider_details->is_approved , [PROVIDER_STATUS_PENDING , PROVIDER_DECLINED]))

              			<a href="{{ route('admin.providers.approve' , ['provider_id' => $provider_details->id]) }}" class="btn btn-success text-center ">
              				<b>{{ tr('approve') }}</b>
              			</a>
                  	@else

              			<a href="{{ route('admin.providers.approve' ,['provider_id' => $provider_details->id]) }}" onclick="return confirm(&quot;{{$provider_details->name}} - {{ tr('provider_decline_confirmation') }}&quot;);" class="btn btn-danger text-center ">
              				<b>{{ tr('decline') }}</b>
              			</a>

                  	@endif

                  	<a href="{{route('admin.providers.history' , ['provider_id' => $provider_details->id])}}" class="btn btn-info text-center pull-right">
              			<b>{{ tr('view_history') }}</b>
              		</a>

              		<a href="{{route('admin.provider_subscriptions.plans' , ['provider_id' => $provider_details->id])}}" class="btn btn-success text-center pull-right" style="margin-right: 4px;">
              			<b>{{ tr('plans') }}</b>
              		</a>

            	</div>
          	
          	</div>

		</div>

		<div class="col-md-5">

			<div class="box box-success">

                <div class="box-header with-border admin-panel-success">
					<h4 class="text-uppercase"><b>{{ tr('provider_location') }}</b></h4>
				</div>

				<div class="box-body">

					<p>{{ $provider_details->address }}</p>
					<p>{{ tr('latitude') }}: {{ $provider_details->latitude }}</p>
					<p>{{ tr('longitude') }}: {{ $provider_details->longitude }}</p>

					<img src='https://maps.googleapis.com/maps/api/staticmap?center={{ $provider_details->latitude }},{{ $provider_details->longitude}}&zoom=19&size=400x200&markers=color:dark-green%7Clabel:S%7C{{ $provider_details->latitude }},{{ $provider_details->longitude }}&markers=size:mid%7Ccolor:0x00a65a%7Clabel:S%7C,AK"&key={{ Setting::get('GOOGLE_API_KEY') }}' class="img img-responsive img-thumbnail">

				</div>

			</div>

			<div class="clearfix"></div>

    		<div class="box box-widget widget-user-2">

    			<div class="box box-success">

	                <div class="box-header with-border admin-panel-success">
						<h4 class="text-uppercase"><b>{{ tr('provider_payout') }}</b></h4>
					</div>

	            	<div class="box-footer no-padding">
	            		
	              		<ul class="nav nav-stacked">

	              			@if(count( $provider_details->providerPayment) > 0)
	            
			                <li>
			                	<a><b>{{ tr('paypal_email') }}</b> <span class="pull-right">{{ $provider_details->paypal_email}}</span></a>
			                </li>

			                <li>
			                	<a><b>{{ tr('cod') }}</b> <span class="pull-right">{{Setting::get('currency') }} {{ $provider_details->providerPayment->cod}}</span></a>
			                </li>
			                
			                <li>
			                	<a><b>{{ tr('card') }}</b> <span class="pull-right">{{Setting::get('currency') }} {{ $provider_details->providerPayment->card}}</span></a>
			                </li>

			                <li>
			                	<a><b>{{ tr('total') }}</b> <span class="pull-right">{{Setting::get('currency') }} {{ $provider_details->providerPayment->total}}</span></a>
			                </li>
			            
			                <li>
			                	<a>
			                		<b>{{ tr('admin_commission') }}</b>
			                		
			                		<span class="pull-right">
			                			{{Setting::get('currency') }} {{$amount_details->admin_amount}}
			                		</span>
			                	</a>
			                </li>

			                <li>		                

			                	<a>
			                		<b>{{ tr('provider_amount') }}</b>
			                		<span class="pull-right">
			                			{{Setting::get('currency') }} {{$amount_details->provider_amount}}
			                		</span>		                
			                	</a>
			                </li> 
			                
			                <li>
			                	<a style="color: blue"><b>{{ tr('paid') }}</b> <span class="pull-right">{{Setting::get('currency') }} {{ $provider_details->providerPayment->paid_amount}}</span>
			                	</a>
			                </li>

			                <?php 
			                		
		                		$payout = $amount_details->provider_amount -  $provider_details->providerPayment->cod; 

		                		$payout = $payout -  $provider_details->providerPayment->paid_amount; 

		                	?>

			                <li>
			                	<a style="color: brown"><b>{{ tr('pending_amount') }}</b> 
			                		<span class="pull-right">{{Setting::get('currency') }} {{$payout < 0 ? $payout : 0}}</span>
			                	</a>
			                	
			                </li>

			                <li>
			                	<!--  -->

			                	<a style="color: green">
			                		<b>
			                			{{ tr('payout') }}
			                			<span class="pull-right">{{Setting::get('currency') }} {{$payout >= 0 ? $payout : 0}}</span>
			                		</b> 
			                	</a>
			                </li>

			                <li style="padding: 10px;">
			                	
			                	<form class="" action="@if($payout <= 0) #  @else {{route('admin.providers.pay') }} @endif" method="POST">

			                		<span>

			                			<input type="hidden" name="provider_id" value="{{ $provider_details->id }}">
			                			
			                			<input type="hidden" name="payout" value="{{$payout }}">
			                			
			                			<input type="number"  min="1" required name="amount" class="form-control pull-left" style="width: 70%;margin-bottom: 10px" placeholder="{{ tr('enter_amount_pay') }}" onkeydown="return isNumber(event)" @if($payout <=0) disabled @endif>

			                			@if($payout <=0)

			                				<a href="javascript:void(0);" disabled="true" class="btn btn-success pull-right" style="width: 20%">
			                					<i class="fa fa-thumbs-up"></i> 
			                					{{ tr('submit') }}
			                				</a>

			                			@else

				                			<button type="submit" class="btn btn-success pull-right" style="width: 20%"><i class="fa fa-thumbs-up"></i> {{ tr('submit') }}</button>	

			                			@endif

			                		</span>	                		
			                	</form>

			                </li>

			                @else 
			                	<p style="padding: 10px">{{ tr('no_payment_provider') }}</p>
			                @endif		          
	              		</ul>
	            	
	            	</div>

	            </div>
          	
          	</div>

          	@if($provider_details->promo_video != '')
          	<div class="col-md-5">

          		<iframe width="400" height="315" src="{{ $provider_details->promo_video }}" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
          		
          	</div>
          	@endif
		</div>

    </div>

@endsection


@section('scripts')

    <script type="text/javascript" src="{{asset('assets/js/star-rating.js') }}"></script>

    <script type="text/javascript">
        $('.view_rating').rating({disabled: true, showClear: false});
    </script>
@endsection

