@extends('layouts.admin')

@section('title', tr('ondemand_requests'))

@section('content-header', tr('ondemand_requests'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li class="active"><i class="fa fa-map"></i> {{ tr('ondemand_requests') }}</li>
@endsection

@section('content')

    @include('notification.notify')

    <div class="row">

        <div class="col-xs-12">
    
            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b>{{ tr('ondemand_requests') }}</b>

                    <!-- EXPORT OPTION START -->

                    @if(count($requests) > 0 )
                    
                        <ul class="admin-action btn btn-warning pull-right" style="margin-right: 40px">
                            
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                                  <b> {{ tr('export') }} </b> <span class="caret"></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li role="presentation">
                                        <a role="menuitem" tabindex="-1" href="{{ route('admin.requests.export' , ['job_type'=> REQUEST_NOW,'format' => 'xlsx']) }}">
                                            <span class="text-red"><b>{{ tr('excel_sheet') }}</b></span>
                                        </a>
                                    </li>

                                    <li role="presentation">
                                        <a role="menuitem" tabindex="-1" href="{{ route('admin.requests.export' , ['job_type'=> REQUEST_NOW,'format' => 'csv']) }}">
                                            <span class="text-blue"><b>{{ tr('csv') }}</b></span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            
                        </ul>

                    @endif

                <!-- EXPORT OPTION END -->
                </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                            <tr>
                                <th>{{ tr('s_no') }}</th>
                                <th>{{ tr('title') }}</th>                                
                                <th class="min">{{ tr('user') }}</th>
                                <th class="min">{{ tr('provider') }}</th>
                                <th class="min">{{ tr('request_date') }}</th>
                                <th>{{ tr('status') }}</th>
                                <th>{{ tr('total') }}</th>
                                <th>{{ tr('action') }}</th>
                            </tr>
                        </thead>

                        <tbody>

                            @foreach($requests as $index => $request_details)
                            
                                <tr>

                                    <td>{{ showEntries($_GET,$index + 1) }}</td>

                                    <td> 
                                        <a href="{{ route('admin.requests.view' , ['request_unique_id' => $request_details->unique_id] ) }}">{{ $request_details->name  }}</a>
                                    </td>

                                    <td>
                                        <a href="{{ route('admin.users.view' , ['user_id' => $request_details->user_id] ) }}">{{ $request_details->user->name ?? tr('user_not_available')}}</a>
                                    </td>

                                    <td>
                                        @if($request_details->provider_id)
                                            <a href="{{ route('admin.providers.view' ,['provider_id' =>  $request_details->provider_id ]) }}">{{ $request_details->provider ? $request_details->provider->name : "" }} </a>
                                        @else 
                                            - 
                                        @endif
                                    </td>

                                    <td>
                                        {{ common_date($request_details->request_date, Auth::guard('admin')->user()->timezone) }}
                                    </td>

                                    <td>{{ request_status($request_details->status) }}</td>

                                    <td>{{ $request_details->currency }} {{ $request_details->total }}</td>

                                    <td>
                                        <a href="{{ route('admin.requests.view' , ['request_unique_id' => $request_details->unique_id] ) }}" class="btn btn-success"><i class="fa fa-eye"></i> <b>{{ tr('view') }}</b></a>

                                        <?php $allowed_cancel_status = [PROVIDER_NONE,PROVIDER_ASSIGNED,PROVIDER_ACCEPTED,PROVIDER_STARTED];
                                            ?>

                                        @if(in_array($request_details->provider_status, $allowed_cancel_status)) 

                                            @if($request_details->status != REQUEST_CANCELLED )
                                                                                       
                                                <a data-toggle="modal" data-target="#{{ $request_details->id }}_cancel_request" class="pull-right btn btn-sm btn-danger"> {{ tr('cancel') }} </a>
                                            @endif
      
                                        @endif
                                            
                                            <div class="modal fade error-popup" id="{{ $request_details->id }}_cancel_request" role="dialog">

                                                <div class="modal-dialog">

                                                    <div class="modal-content">

                                                        <form method="post" action="{{ route('admin.requests.cancel', ['request_id' => $request_details->id]) }}">

                                                            <div class="modal-body">

                                                                <div class="media">

                                                                    <div class="media-body">

                                                                       <h4 class="media-heading">{{ tr('reason') }} *</h4>

                                                                       <textarea rows="5" name="cancel_reason" id='cancel_reason' required style="width: 100%"></textarea>

                                                                   </div>

                                                                </div>

                                                                <div class="text-right">

                                                                    <br>

                                                                   <button type="submit" class="btn btn-primary top">{{ tr('submit') }}</button>

                                                               </div>

                                                            </div>

                                                        </form>

                                                    </div>

                                                </div>

                                            </div>

                                    </td>
                                
                                </tr>
                            
                            @endforeach
                        
                        </tbody>

                    </table>

                    <div align="right">{{ $requests->links() }}</div>

                </div>

            </div>

        </div>
    
    </div>

@endsection
