@extends('layouts.admin')

@section('breadcrumb')

    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    
    <li ><a href="{{request()->headers->get('referer')}}"><i class="fa fa-diamond"></i> {{tr('requests')}}</a></li>
    
    <li class="active"><i class="fa fa-eye"></i> {{tr('view_request')}}</li>
@endsection

@section('title', tr('view_request'))

@section('content-header', tr('view_request'))

@section('content')

@include('notification.notify')

<div class="box box-success">

    <div class="box-header with-border admin-panel-success">

        <h4 style="word-wrap: break-word;">
        	<b>{{$request_details->name}}</b>
        </h4>

	</div>

    <div class="box-body">
       
        <div class="col-md-12">

            <div class="row">

            	@if($request_details->description)

		            <div class="col-md-12">

		            	<div style="box-shadow: 0px 0px 1px 1px #e0e0e0fa;word-wrap: break-word;">

		            		<p style="padding: 10px">

		            			<span class="text-uppercase" style="font-size: 16px"><b>{{tr('description')}}:</b></span>

		            			<br>

		            			<span class="rv-desc">{{$request_details->description}} </span>
		            		</p>

		            	</div>

		            	<br>
		            	
		            </div>

	            @endif

	            <div class="clearfix"></div> 

	            <div class="col-md-12">

	            	<table style="margin-bottom: 5px">
	            		<tr>
					        <td>{{ tr('address') }}</td>
					        <td>{{$request_details->s_address ? $request_details->s_address : '-' }}</td>
					    </tr>
	            	</table>

	           	</div>   

	            <div class="clearfix"></div> 

	            <div class="col-md-6">

	            	<table>
					    
					    <tr>
					        <td>{{tr('user')}}</td>
					        <td>{{$request_details->user ? $request_details->user->name : ""}}</td>
					    </tr>

					    <tr>
					        <td>{{tr('provider')}}</td>
					        <td> 
					        	{{$request_details->provider ? $request_details->provider->name : "-"}} 
					        </td>
					    </tr>

					    <tr>
					        <td>{{tr('job_type')}}</td>
					        <td>{{job_type($request_details->job_type)}}</td>
					    </tr>

					    <tr>
					        <td>{{tr('request_type')}}</td>
					        <td>{{request_type($request_details->request_type)}}</td>
					    </tr>

					    <tr>
					        <td>{{tr('category')}}</td>
					        <td>{{$request_details->category ? $request_details->category->name : "-"}}</td>
					    </tr>

					    <tr>
					        <td>{{tr('sub_category')}}</td>
					        <td>{{$request_details->subCategory ? $request_details->subCategory->name : "-"}}</td>
					    </tr>

					    <tr>
					        <td>{{tr('request_date')}}</td>
					        <td>
					        	@if($request_details->request_date != "0000-00-00 00:00:00") 
		                    		{{common_date($request_details->request_date , Auth::guard('admin')->user()->timezone) }} 
		                    	@endif
					        </td>
					    </tr>

					    <tr>
					        <td>{{tr('total_time')}}</td>
					        <td>
					        	{{$request_payment_details->total_time}}
					        </td>
					    </tr>

	                    <tr>
					        <td>{{tr('start_time')}}</td>
					        <td>
					        	@if($request_details->start_time != "0000-00-00 00:00:00") 
	                    			{{common_date($request_details->start_time , Auth::guard('admin')->user()->timezone) }}  
	                    		@else 
	                    			- 
	                    		@endif
					        </td>
					    </tr>

					    <tr>
					        <td>{{tr('end_time')}}</td>
					        <td>
					        	@if($request_details->end_time != "0000-00-00 00:00:00") 
	                    			{{common_date($request_details->end_time , Auth::guard('admin')->user()->timezone) }}  
	                    		@else 
	                    			- 
	                    		@endif
					        </td>


					    </tr>

					    <tr>
					        <td>{{tr('is_abused_provider')}}</td>
					        <td>
					        	@if($request_details->is_abused_provider == YES) 
	                    			{{tr('yes')}} 
	                    		@else 
	                    			{{tr('no')}}
	                    		@endif
					        </td>

					    </tr>

					    <tr>
					        <td>{{tr('is_fav_provider')}}</td>
					        <td>
					        	@if($request_details->is_fav_provider == YES) 
	                    			{{tr('yes')}} 
	                    		@else 
	                    			{{tr('no')}}
	                    		@endif
					        </td>


					    </tr>

					    @if($request_details->cancelled_by)

			                <tr>

			                	<td>{{tr('cancelled_by')}}</td>
			                	<td>{{$request_details->cancelled_by}}</td>
			                	
			                </tr>

			                <tr>

			                	<td>{{tr('cancelled_date')}}</td>
			                	<td>{{common_date($request_details->cancelled_date)}}</td>
			                	
			                </tr>

			                <tr>

			                	<td>{{tr('cancelled_reason')}}</td>
			                	<td>{{$request_details->cancelled_reason}}</td>
			                	
			                </tr>

		                @endif

		                <tr>
		                	<td>{{tr('is_coupon_applied')}}</td>

		                	<td>
		                		@if($request_payment_details->is_coupon_applied == COUPON_APPLIED)

		                			<span class="label label-success">{{tr('yes')}}</span>

		                		@else

		                			<span class="label label-danger">{{tr('no')}}</span>

		                		@endif
		                	</td>
		                
		                </tr>

		                <tr>
		                	<td>{{tr('coupon_code')}}</td>

		                	<td>{{$request_payment_details->coupon_code}}</td>
		                </tr>
					    
					</table>
	           
	            </div>

	            <div class="col-md-6">

	            	<table>

					    <tr>
					        <td>{{ tr('price_type') }}</td>
                    		<td>{{price_type($request_details->price_type)}}</td>
					    </tr>

					    <tr>
					        <td>{{ tr('price_per_hour') }}</td>
                    		<td>{{$request_details->currency}} {{$request_details->price_per_hour}}</td>
					    </tr>

					    <tr>
					        <td>{{ tr('time_price') }}</td>
                    		<td>{{$request_details->currency}} {{$request_payment_details->time_price}}</td>
					    </tr>

					    <tr>
					        <td>{{ tr('tax_price') }}</td>
                    		<td>{{$request_details->currency}} {{$request_payment_details->tax_price}}</td>
					    </tr>

					    <tr>
					        <td>{{ tr('actual_total') }}</td>
                    		<td>{{$request_details->currency}} {{$request_payment_details->actual_total}}</td>
					    </tr>

		                <tr>
		                	<td>{{tr('coupon_amount')}}</td>

		                	<td>{{$request_details->currency}} {{$request_payment_details->coupon_amount}}</td>
		                </tr>

					    <tr>
					        <td>{{ tr('paid_amount') }}</td>
                    		<td>{{$request_details->currency}} {{$request_details->total}}</td>
					    </tr>

					    <tr>
					        <td>{{ tr('admin_commission') }}</td>
                    		<td>{{$request_details->currency}} {{$request_payment_details->admin_amount}}</td>
					    </tr>

					    <tr>
					        <td>{{ tr('provider_amount') }}</td>
                    		<td>{{$request_details->currency}} {{$request_payment_details->provider_amount}}</td>
					    </tr>

					    <tr>
					        <td>{{ tr('status') }}</td>
                    		<td>{{request_status($request_details->status)}}</td>
					    </tr>

					    <tr>

		                    <td>{{tr('provider_status')}} : </td>
		                    <td>

		                    	@if(!in_array($request_details->status, [REQUEST_NO_PROVIDER_AVAILABLE,REQUEST_TIME_EXCEED_CANCELLED,REQUEST_CANCELLED]))

		                    		{{provider_status($request_details->provider_status) }}

		                    	@else
		                    		-
		                    	@endif
		                    </td>

		                </tr>
		                
					</table>
	            
	            </div>

        	</div>
        
	        @if($request_details->before_image !='')

		        <div class="col-md-6">
		            <div class="row">
		              <div class="col-md-12">
		                <section class="widget bg-white post-comments">

		                    <div class="widget btn btn-success text-center" style="width:100%;"><strong>{{ tr('before_service') }}</strong></div>

	                        <div class="media">
	                            <img style="width:100%;" src="{{$request_details->before_image}}" alt="">
	                        </div>

		                </section>
		              </div>
		            </div>
		        
		        </div>

		        <div class="col-md-6">
		            <div class="row">
		              <div class="col-md-12">
		                <section class="widget bg-white post-comments">
		                    <div class="widget btn btn-success text-center" style="width:100%;"><strong>{{ tr('after_service') }}</strong></div>
		                        <div class="media">
		                            <img style="width:100%;" src="{{$request_details->after_image}}" alt="">
		                        </div>
		                </section>
		              </div>
		            </div>
		        
		        </div>

	        @endif

	        <div class="row">
	            <div class="col-xs-12">
	            	<br>
	            	<h4>{{tr('location')}}</h4>
	                <div class="" id="map"></div>
	            </div>
	        
	        </div>

    	</div>

	</div>

</div>

@endsection

@section('styles')

<style>
	dt {
		padding: 4px !important; 
	}

	dd {
		padding: 4px !important;
	}

	table {
	    font-family: arial, sans-serif;
	    border-collapse: collapse;
	    width: 100%;
	}

	td, th {
	    border: 1px solid #dddddd;
	    text-align: left;
	    padding: 8px;
	}

	tr:nth-child(even) {
	    background-color: #28ae5217;
	}

	td:nth-child(odd) {
	    color:#0000008a;
	}

	.rv-desc {
		line-height: 1.6;
	    letter-spacing: 0.6px;
	    font-size: 14px;
	}

</style>

<style type="text/css">

    html, body {
        height: 100%;
        margin: 0;
        padding: 0;
    }

    #map {
        height: 100%;
        min-height: 400px; 
    }

</style>

@endsection

@section('scripts')

	<script>
	    var map;
    	
    	var serviceLocation = {lat: parseFloat("{{ $request_details->s_latitude }}"), lng: parseFloat("{{ $request_details->s_longitude }}")};
	    
	    function initMap() {
	        map = new google.maps.Map(document.getElementById('map'), {
	            center: serviceLocation,
	            zoom: 15
	        });

	        var marker = new google.maps.Marker({
	            map: map,
	            position: serviceLocation,
	            visible: true,
	            animation: google.maps.Animation.DROP,
	        });
	    }
	</script>

	<script src="https://maps.googleapis.com/maps/api/js?key={{ envfile('GOOGLE_API_KEY') }}&libraries=places&callback=initMap" async defer></script>
@endsection