@extends('layouts.admin')

@section('title', tr('revenue_system'))

@section('content-header',tr('revenue_system'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li class="active"><i class="fa fa-money"></i> {{tr('revenue_system')}}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

		  <div class="col-lg-3 col-xs-6">

    	    <div class="small-box bg-maroon">
    	        <div class="inner">
    	            <h3> {{ $data->today_earnings}} </h3>
    	            <p>{{ tr('total_earnings') }}</p>
    	        </div>

    	        <div class="icon">
    	            <i class="fa fa-dollar"></i>
    	        </div>
    	    </div>
    	
    	</div>	

    	<div class="col-lg-3 col-xs-6">

    	    <div class="small-box btn-primary">
    	        <div class="inner">
    	            <h3> {{ $data->total_upcoming_jobs}} </h3>
    	            <p>{{ tr('total_upcoming_jobs') }}</p>
    	        </div>

    	        <div class="icon">
    	            <i class="fa fa-diamond"></i>
    	        </div>
    	    </div>
    	
    	</div>			

    	<div class="col-lg-3 col-xs-6">

    	    <div class="small-box btn-success">
    	        <div class="inner">
    	            <h3> {{ $data->total_completed_jobs}} </h3>
    	            <p>{{ tr('total_completed_jobs') }}</p>
    	        </div>

    	        <div class="icon">
    	            <i class="fa fa-user"></i>
    	        </div>
    	    </div>
    	
    	</div>   

    	<div class="col-lg-3 col-xs-6">

    	    <div class="small-box btn-warning ">
    	        <div class="inner">
    	            <h3> {{ $data->total_cancelled_jobs}} </h3>
    	            <p>{{ tr('total_cancelled_jobs') }}</p>
    	        </div>

    	        <div class="icon">
    	            <i class="fa fa-user"></i>
    	        </div>
    	    </div>
    	
    	</div>	

  		<div class="col-md-6">
  		    
  		    <div class="box">

  		        <div class="box-header with-border">		            
  		            <h3 class="box-title">{{tr('revenues')}}</h3>
  		            <div class="box-tools pull-right">		                
  		                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
  		                </button>		                
  		            </div>
  		        </div>

  		        <!-- /.box-header -->

  		        <div class="box-body">
  		            <div class="row">
  		                <div class="col-md-12">
  		                    <p class="text-center">
  		                        <strong></strong>
  		                    </p>		                    
  		                    <div class="chart-responsive">
  		                        <canvas id="video_subscribe_payments" height="200px"></canvas>
  		                    </div>
  		                </div>
  		            </div>		        
  		        </div>

  		        <div class="box-footer no-padding">

  		            <ul class="nav nav-pills nav-stacked">
  		                <li>
  		                    <a>
  		                        <strong class="text-red">{{tr('total_amount')}}</strong>
  		                        <span class="pull-right text-red">
  		                            <i class="fa fa-angle-right"></i> 
                                    {{ formatted_amount($total_revenue) }}
  		                        </span>
  		                    </a>
  		                </li>

  		                <li>
  		                    <a>
  		                        <strong class="text-green">{{tr('total_admin_amount')}} </strong>
  		                        <span class="pull-right text-green">
  		                            <i class="fa fa-angle-right"></i> 
                                    {{ formatted_amount($admin_amount) }}
  		                        </span>
  		                    </a>
  		                </li>

  		                <li>
                            <a>
                                <strong class="text-yellow">{{tr('total_provider_amount')}}</strong>
                                <span class="pull-right text-yellow">
                                    <i class="fa fa-angle-right"></i> 
                                    {{ formatted_amount($provider_amount) }}
                                </span>
                            </a>
                        </li>  

                        <li>
  		                    <a>
  		                        <strong class="text-primary">{{tr('total_provider_subscription_payments')}}</strong>
  		                        <span class="pull-right text-primary">
  		                            <i class="fa fa-angle-right"></i> 
                                    
                                    {{ formatted_amount($provider_subscription_payments) }}

  		                        </span>
  		                    </a>
  		                </li>

  		          	</ul>

  		        </div>

  		    </div>     
  		    
  		</div>
      


	</div>

@endsection

@section('scripts')

    <script type="text/javascript">
          
        //-------------
        //- PIE CHART -
        //-------------
        // Get context with jQuery - using jQuery's .get() method.
        var subscribe_canvas = $("#video_subscribe_payments").get(0).getContext("2d");
        var subscribeChart = new Chart(subscribe_canvas);
        var subscribeData = [
          {
            value: {{$total_revenue}},
            color: "#00a65a",
            highlight: "#00a65a",
            label: "Admin Commission"
          },
          {
            value: {{$provider_amount}},
            color: "#f39c12",
            highlight: "#f39c12",
            label: "Provider Commission"
          } 

          {
            value: {{$provider_subscription_payments}},
            color: "#154275",
            highlight: "#154275",
            label: "Provider Subscrition Revenue"
          }
        ];
        var subscribeOptions = {
          //Boolean - Whether we should show a stroke on each segment
          segmentShowStroke: true,
          //String - The colour of each segment stroke
          segmentStrokeColor: "#fff",
          //Number - The width of each segment stroke
          segmentStrokeWidth: 1,
          //Number - The percentage of the chart that we cut out of the middle
          percentageInnerCutout: 50, // This is 0 for Pie charts
          //Number - Amount of animation steps
          animationSteps: 100,
          //String - Animation easing effect
          animationEasing: "easeOutBounce",
          //Boolean - Whether we animate the rotation of the Doughnut
          animateRotate: true,
          //Boolean - Whether we animate scaling the Doughnut from the centre
          animateScale: false,
          //Boolean - whether to make the chart responsive to window resizing
          responsive: true,
          // Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
          maintainAspectRatio: false,
          //String - A legend template
          legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<segments.length; i++){%><li><span style=\"background-color:<%=segments[i].fillColor%>\"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>",
          //String - A tooltip template
          tooltipTemplate: "<%=label%> - $<%=value %>"
        };
        //Create pie or douhnut chart
        // You can switch between pie and douhnut using the method below.
        subscribeChart.Doughnut(subscribeData, subscribeOptions);
        //-----------------
        //- END PIE CHART -
        //-----------------

         //-----------------------
        //- MONTHLY SALES CHART -
        //-----------------------

    </script>

@endsection