@extends('layouts.admin')

@section('title', tr('redeems'))

@section('content-header', tr('redeems'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li><a href="{{ route('admin.providers.index') }}"><i class="fa fa-user"></i> {{ tr('providers') }}</a></li>
    <li class="active"><i class="fa fa-user"></i> {{ tr('redeems') }}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

          	<div class="box box-success">

            	<div class="box-header with-border admin-panel-success">

	                <b style="font-size:18px;">{{ tr('redeems') }}</b>

	                <a href="{{ route('admin.providers.index') }}" class="btn btn-warning pull-right">{{ tr('view_providers') }}</a>
	                
	            </div>
            	
            	<div class="box-body">

					<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      <th>{{ tr('id') }}</th>
						      <th>{{ tr('provider_name') }}</th>
						      <th>{{ tr('redeem_amount') }}</th>
						      <th>{{ tr('paid_amount') }}</th>
						      <th>{{ tr('sent_date') }}</th>
						      <th>{{ tr('status') }}</th>
						      <th>{{ tr('action') }}</th>
						    </tr>
						
						</thead>

						<tbody>

							@foreach($redeems_requests as $i => $redeem_request_details)

							    <tr>

							      	<td>{{ showEntries($_GET,$i+1) }}</td>

							      	<td>

							      		<a href="{{ route('admin.providers.view' , ['provider_id' => $redeem_request_details->provider_id]) }}">
							      			{{ $redeem_request_details->provider ? $redeem_request_details->provider->name : "" }}
							      		</a>

							      	</td>

							      	<td><b>{{ Setting::get('currency') }}{{ $redeem_request_details->request_amount }}</b></td>

							      	<td><b>{{ Setting::get('currency') }}{{ $redeem_request_details->paid_amount }}</b></td>

							      	<td>{{ $redeem_request_details->created_at ? $redeem_request_details->created_at->diffForHumans() : "" }}</td>

							      	<td><b>{{ redeem_request_status($redeem_request_details->status) }}</b></td>
							 
							      	<td>

							      		@if(in_array($redeem_request_details->status ,[REDEEM_REQUEST_SENT , REDEEM_REQUEST_PROCESSING]))

								      		<form action="{{ route('admin.providers.payout.invoice') }}" method="POST">

								      			<input type="hidden" name="redeem_request_id" value="{{ $redeem_request_details->id }}">

								      			<input type="hidden" name="paid_amount" value="{{ $redeem_request_details->request_amount }}">

								      			<input type="hidden" name="provider_id" value="{{ $redeem_request_details->provider_id }}">

								      			<button type="submit" class="btn btn-success btn-sm">{{ tr('paynow') }}</button>
								      			
								      		</form>

								      	@else
								      		<span>-</span>
							      		@endif

							      	</td>

							    </tr>

							@endforeach
						
						</tbody>

					</table>

					<div align="right">{{ $redeems_requests->links() }}</div>

				</div>

			</div>

		</div>

	</div>

@endsection