@extends('layouts.admin')

@section('title', tr('request_payments'))

@section('content-header',tr('request_payments'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li class="active"><i class="fa fa-money"></i> {{tr('request_payments')}}</li>
@endsection

@section('content')

@include('notification.notify')

	<div class="row">

        <div class="col-xs-12">

	        <div class="box box-success">

	            <div class="box-header with-border admin-panel-success">

	                <b>{{tr('request_payments')}}</b>

	                <!-- EXPORT OPTION START -->

                    @if(count($request_payments) > 0 )
                    
                        <ul class="admin-action btn btn-warning pull-right" style="margin-right: 40px;">
                            
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                                  {{tr('export')}} <span class="caret"></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li role="presentation">
                                        <a role="menuitem" tabindex="-1" href="{{route('admin.payments.export' , ['format' => 'xlsx'])}}">
                                            <span class="text-red"><b>{{tr('excel_sheet')}}</b></span>
                                        </a>
                                    </li>

                                    <li role="presentation">
                                        <a role="menuitem" tabindex="-1" href="{{route('admin.payments.export' , ['format' => 'csv'])}}">
                                            <span class="text-blue"><b>{{tr('csv')}}</b></span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        
                        </ul>

                    @endif

                <!-- EXPORT OPTION END -->
	            </div>

	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
								<th>{{tr('id')}}</th>
								<th>{{tr('request')}}</th>
								<th>{{tr('payment_id')}}</th>
								<th>{{tr('username')}}</th>
								<th>{{tr('payment_mode')}}</th>
								<th>{{tr('admin_commission')}}</th>
								<th>{{tr('provider_amount')}}</th>
								<th>{{tr('total')}}</th>
								<th>{{tr('status')}}</th>
						    </tr>
						</thead>

						<tbody>

							@if(count($request_payments) > 0)

								@foreach($request_payments as $i => $request_payment_details)

								    <tr>
								      	<td>{{showEntries($_GET,$i+1)}}</td>

								      	<td>
								      		@if( $request_payment_details->requests)
								      		
								      			<a href="{{route('admin.requests.view' , ['request_unique_id' =>  $request_payment_details->requests->unique_id ] )}}">{{ $request_payment_details->requests->name}}
								      			</a>

								      		@endif
								      	</td>
								      	
								      	<td>{{ $request_payment_details->payment_id}}</td>

								      	<td><a href="{{route('admin.users.view' ,[ 'user_id' =>  $request_payment_details->user_id ])}}"> @if( $request_payment_details->user) {{ $request_payment_details->user->name}} @endif</a></td>

								      	<td>{{ $request_payment_details->payment_mode }} </td>

								      	<td>
								      		@if( $request_payment_details->requests)
								      			 	{{ $request_payment_details->requests->currency}}
								      			 	{{ $request_payment_details->admin_amount ?  $request_payment_details->admin_amount : "0.00"}}
								      		@endif
								      	</td>
								      	<td>
								      		@if( $request_payment_details->requests) {{ $request_payment_details->requests->currency}}{{ $request_payment_details->provider_amount ?  $request_payment_details->provider_amount : "0.00"}}
								      		@endif
								      	</td>
								      	<td>
								      		@if( $request_payment_details->requests) {{ $request_payment_details->requests->currency}}{{ $request_payment_details->total ?  $request_payment_details->total : "0.00"}} 
								      		@endif
								      	</td>

								      	<td>
								      		@if( $request_payment_details->status) 
								      			<span style="color: green;"><b>{{tr('paid')}}</b></span>
								      		@else
								      			<span style="color: red"><b>{{tr('not_paid')}}</b></span>
								      		@endif
								      	</td>
								    </tr>					

								@endforeach

							@endif

						</tbody>
					
					</table>
					<div align="right">{{$request_payments->links()}}</div>
	            </div>

          	</div>
        </div>
    </div>

@endsection


