@extends('layouts.admin')

@if(isset($name))

  @section('title', tr('user_review'))

@else

  @section('title', tr('provider_review'))

@endif

@if(isset($name))

  @section('content-header', tr('user_review'))

@else

  @section('content-header', tr('provider_review'))

@endif


@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    @if(isset($name))
      <li class="active"><i class="fa fa-thumbs-up"></i> {{ tr('user_review') }}</li>
    @else
      <li class="active"><i class="fa fa-thumbs-up"></i> {{ tr('provider_review') }}</li>
    @endif

@endsection

@section('styles')

<link rel="stylesheet" href="{{ asset('admin-css/dist/css/star-rating.css') }}">

@endsection

@section('content')

    @include('notification.notify')

    <div class="row">

        <div class="col-xs-12">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    @if(isset($name)) <b>{{ tr('user_review') }}</b> @else <b>{{ tr('provider_review') }}</b> @endif

                </div>

                <div class="box-body">

                    @if(count($reviews) > 0)

                        <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                            <thead>
                              <tr>
                                <th>{{ tr('id') }}</th>
                                @if(isset($name))
                                <th>{{ tr('title') }}</th>
                                <th class="min">{{ tr('provider') }}</th>
                                <th class="min">{{ tr('user') }}</th>
                                @else
                                <th>{{ tr('title') }}</th>
                                <th>{{ tr('user') }}</th>
                                <th>{{ tr('provider') }}</th>
                                @endif
                               
                                <th>{{ tr('rating') }}</th>
                                <th class="min">{{ tr('date') }}</th>
                                <th class="min">{{ tr('comment') }}</th>
                                <th>{{ tr('action') }}</th>
                                </tr>
                            
                            </thead>

                            <tbody>
                               
                                @foreach($reviews as $index => $review)
                                
                                    <tr>
                                        <td>{{ showEntries($_GET,$index+1) }}</td>

                                        @if(isset($name))
                                           
                                            <td>
                                                @if($review->requests)

                                                    <a href="{{ route('admin.requests.view', ['request_unique_id' => $review->requests->unique_id ,'job_type' => $review->requests->job_type]) }}"> {{ $review->requests->name }}
                                                @else
                                                    <center> - </center>
                                                @endif
                                            </td>

                                            <td>
                                                @if($review->provider_name)

                                                    <a href="{{ route('admin.providers.view' , ['provider_id' => $review->provider_id]) }}">
                                                        {{ $review->provider_name }}
                                                    </a>
                                                @else
                                                     <center> - </center>
                                                @endif
                                            </td>

                                            <td> 
                                                    <a href="{{ route('admin.users.view' , 
                                                    ['user_id' => $review->user_id ] ) }}">
                                                        {{ $review->user_name }}
                                                    </a>
                                            </td>

                                        @else

                                            <td>

                                                @if($review->requests)

                                                    <a href="{{ route('admin.requests.view', ['request_unique_id' => $review->requests->unique_id ,'job_type' => $review->requests->job_type]) }}">{{ $review->requests->name }}
                                                @else
                                                   -
                                                    
                                                @endif
                                            </td>

                                            <td>
                                                
                                                <a href="{{ route('admin.users.view' , [ 'user_id' => $review->user_id ] ) }}">
                                                    {{ $review->user_name }}

                                                </a>
                                            </td>

                                            <td>
                                                <a href="{{ route('admin.providers.view' , ['provider_id' => $review->provider_id]) }}">
                                                    {{ $review->provider_name }}
                                                </a>
                                            </td>

                                        @endif

                                        <!-- <td>{{ $review->rating }}</td> -->

                                        <td>
                                            <span style="display: none;">{{ $review->rating }}</span>
                                            <input id="view_rating" name="rating" type="number" class="rating view_rating" min="1" max="5" step="1" value="{{ $review->rating }}">
                                        </td>

                                        <td>{{ $review->created_at }}</td>

                                        <td>{{ $review->comment }}</td>

                                        <td>

                                            <div class="input-group-btn">

                                                @if(isset($name))

                                                    <a class="btn btn-danger" onclick="return confirm('{{ tr('user_review_delete_confirmation') }}')" href="{{ route('admin.user_reviews.delete', ['user_rating_id' => $review->review_id] ) }}">
                                                        {{ tr('delete') }} 
                                                    </a>

                                                @else

                                                    <a class="btn btn-danger" onclick="return confirm('{{ tr('provider_review_delete_confirmation') }}')" href="{{ route('admin.provider_reviews.delete', [ 'provider_rating_id' => $review->review_id] ) }}">
                                                        {{ tr('delete')  }}
                                                    </a> 

                                                @endif

                                            </div>

                                        </td>

                                    </tr>
                                
                                @endforeach

                            </tbody>
                        
                        </table>

                        <div align="right">{{ $reviews->links() }}</div>

                    @else

                        <h3 class="no-result">{{ tr('no_result_found') }}</h3>

                    @endif
                
                </div>

            </div>
        
        </div>
    
    </div>

@endsection


@section('scripts')

    <script type="text/javascript" src="{{ asset('admin-css/dist/js/star-rating.js') }}"></script>

    <script type="text/javascript">
        $('.view_rating').rating({disabled: true, showClear: false});
    </script>

@endsection