@extends('layouts.admin')

@section('title', tr('settings'))

@section('content-header', tr('settings'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li class="active"><i class="fa fa-gears"></i> {{tr('settings')}}</li>
@endsection

@section('content')

    @include('notification.notify')

    <div class="row">

        <div class="col-md-6">

            <div class="box box-danger">

                <div class="box-header with-border">

                    <h3 class="box-title">{{tr('settings')}}</h3>

                </div>

                <form action="{{route('admin.save.control')}}" method="POST" role="form">
                    <div class="box-body">
                        <div class="form-group">
                            <label>{{ tr('admin_demo_control') }}</label>
                            <br>
                            <label>
                                <input required type="radio" name="admin_demo_control" value="1" @if(Setting::get('admin_demo_control') == 1) checked @endif>
                                {{tr('yes')}}
                            </label>

                            <label>
                                <input required type="radio" name="admin_demo_control"  value="0" @if(Setting::get('admin_demo_control') == 0) checked @endif>
                                {{tr('no')}}
                            </label>
                        </div>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">{{tr('submit')}}</button>
                    </div>
                </form>
                
            </div>
        </div>

    </div>


@endsection