@extends('layouts.admin')

@section('title', tr('settings'))

@section('content-header') 

{{tr('settings')}} 

@endsection

@section('styles')

<style>
    
    .settings-sub-header { 
        margin-top: 0;
        font-size: 20px;
        color: #8a1818;
    }

    /*  streamview tab */

    div.streamview-tab-container{
        z-index: 10;
        background-color: #ffffff;
        padding: 0 !important;
        border-radius: 4px;
        -moz-border-radius: 4px;
        border:1px solid #ddd;
        margin-top: 20px;
        margin-left: 50px;
        -webkit-box-shadow: 0 6px 12px rgba(0,0,0,.175);
        box-shadow: 0 6px 12px rgba(0,0,0,.175);
        -moz-box-shadow: 0 6px 12px rgba(0,0,0,.175);
        background-clip: padding-box;
        opacity: 0.97;
        filter: alpha(opacity=97);
    }

    div.streamview-tab-menu{
        padding-right: 0;
        padding-left: 0;
        padding-bottom: 0;
    }

    div.streamview-tab-menu div.list-group{
        margin-bottom: 0;
    }

    div.streamview-tab-menu div.list-group>a{
        margin-bottom: 0;
    }

    div.streamview-tab-menu div.list-group>a .glyphicon,
    div.streamview-tab-menu div.list-group>a .fa {
        color: #449d44;
    }
    div.streamview-tab-menu div.list-group>a:first-child{
        border-top-right-radius: 0;
        -moz-border-top-right-radius: 0;
    }
    div.streamview-tab-menu div.list-group>a:last-child{
        border-bottom-right-radius: 0;
        -moz-border-bottom-right-radius: 0;
    }
    div.streamview-tab-menu div.list-group>a.active,
    div.streamview-tab-menu div.list-group>a.active .glyphicon,
    div.streamview-tab-menu div.list-group>a.active .fa{
        background-color: #449d44;
        background-image: #449d44;
        border-color: #008d4c;
        color: #ffffff;
    }
    div.streamview-tab-menu div.list-group>a.active:after{
        content: '';
        position: absolute;
        left: 100%;
        top: 50%;
        margin-top: -13px;
        border-left: 0;
        border-bottom: 13px solid transparent;
        border-top: 13px solid transparent;
        border-left: 10px solid #449d44;
    }

    div.streamview-tab-content{
        background-color: #ffffff;
        padding-left: 20px;
        padding-top: 10px;
    }

    .box-body {
        padding: 0px;
    }

    div.streamview-tab div.streamview-tab-content:not(.active){
        display: none;
    }

    .sub-title {
        width: fit-content;
        color: #2c648c;
        font-size: 18px;
        /*border-bottom: 2px dashed #285a86;*/
        padding-bottom: 5px;
    }

    hr {
        margin-top: 15px;
        margin-bottom: 15px;
    }

</style>

@endsection

@section('breadcrumb')

    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>

    <li class="active"><i class="fa fa-gears"></i> {{tr('settings')}}</li>
    
@endsection

@section('content')

    <div class="row">

        <div class="col-md-12">

            @include('notification.notify')

        </div>

        <div class="col-lg-11 col-md-11 col-sm-11 col-xs-11 streamview-tab-container">

            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 streamview-tab-menu">
                
                <div class="list-group">
                    <a href="#" class="list-group-item active text-left">

                        {{tr('site_settings')}}
                    </a>

                    <a href="#" class="list-group-item text-left">
                        {{tr('job_settings')}}
                    </a>
                    <a href="#" class="list-group-item text-left">

                        {{tr('notification_settings')}}
                    </a>
                    <a href="#" class="list-group-item text-left">

                        {{tr('social_settings')}}
                    </a>
                    <a href="#" class="list-group-item text-left">

                        {{tr('payment_settings')}}
                    </a>

                   <a href="#" class="list-group-item text-left">
                        {{tr('seo_settings')}}
                    </a>

                    <a href="#" class="list-group-item text-left">

                        {{tr('email_settings')}}
                    </a>

                    <a href="#" class="list-group-item text-left">
                        {{tr('other_settings')}}
                    </a>

                </div>

            </div>

            <div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 streamview-tab">
                
                <!-- Site Settings  section -->
                
                <div class="streamview-tab-content active">

                    <form action="{{(Setting::get('admin_demo_control') == 1) ? '' : route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        <div class="box-body">

                            <div class="row">

                                <div class="col-md-12">

                                    <h3 class="settings-sub-header text-uppercase"><b>{{tr('site_settings')}}</b></h3>

                                    <hr>

                                </div>

                                <div class="col-md-12">

                                    <div class="form-group">

                                        <label for="sitename" class="text-uppercase">{{tr('site_name')}}</label>

                                        <input type="text" class="form-control" name="site_name" value="{{ Setting::get('site_name')  }}" id="sitename" placeholder="{{tr('enter_site_name')}}">

                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">

                                        <label for="site_logo" class="text-uppercase">{{tr('site_logo')}}</label>

                                        <input type="file" id="site_logo" name="site_logo" accept="image/x-png, image/jpeg">

                                        <p class="help-block">{{tr('image_upload_png_jpeg')}}</p>

                                        @if(Setting::get('site_logo'))
                                            <img class="img img-responsive img-thumbnail" src="{{Setting::get('site_logo')}}">

                                        @endif

                                        <br>

                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">

                                        <label for="site_icon" class="text-uppercase">{{tr('site_icon')}}</label>
                                        
                                        <input type="file" id="site_icon" name="site_icon" accept="image/png">
                                        
                                        <p class="help-block">{{tr('upload_image_png_only')}}</p>

                                        @if(Setting::get('site_icon'))
                                            <img class="img img-responsive img-thumbnail" src="{{Setting::get('site_icon')}}">

                                        @endif

                                        <br>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <!-- /.box-body -->

                        <div class="box-footer">

                            <button type="reset" class="btn btn-warning">{{tr('reset')}}</button>
                            
                            @if(Setting::get('admin_demo_control') == 1)
                                <button type="submit" class="btn btn-primary pull-right" disabled>{{tr('submit')}}</button>
                            @else
                                <button type="submit" class="btn bg-blue pull-right">{{tr('submit')}}</button>
                            @endif
                        </div>
                    
                    </form>

                </div>

                <!-- Job Settings -->

                <div class="streamview-tab-content">
                    
                    <form action="{{ (Setting::get('admin_demo_control') == 1) ? '' : route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        <div class="box-body">

                            <div class="row">

                                <div class="col-md-12">

                                    <h3 class="settings-sub-header text-uppercase"><b>{{tr('job_settings')}}</b></h3>

                                    <hr>

                                </div>

                                <div class="col-md-4">

                                    <input type="hidden" name="request_now" value="{{YES}}">

                                    <!-- <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('request_now')}}</h5>

                                        <label>

                                            <input type="radio" name="request_now"  @if(Setting::get('request_now') == 1) checked @endif class="flat-red" id="request_now" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="request_now"  @if(Setting::get('request_now') == 0) checked @endif class="flat-red" id="request_now" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div> -->

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('request_later')}}</h5>

                                        <label>

                                            <input type="radio" name="request_later"  @if(Setting::get('request_later') == 1) checked @endif class="flat-red" id="request_later" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="request_later"  @if(Setting::get('request_later') == 0) checked @endif class="flat-red" id="request_later" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('request_type_location')}}</h5>

                                        <label>

                                            <input type="radio" name="request_type_location"  @if(Setting::get('request_type_location') == 1) checked @endif class="flat-red" id="request_type_location" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="request_type_location"  @if(Setting::get('request_type_location') == 0) checked @endif class="flat-red" id="request_type_location" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('request_type_direct')}}</h5>

                                        <label>

                                            <input type="radio" name="request_type_direct"  @if(Setting::get('request_type_direct') == 1) checked @endif class="flat-red" id="request_type_direct" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="request_type_direct"  @if(Setting::get('request_type_direct') == 0) checked @endif class="flat-red" id="request_type_direct" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                    <div class="form-group" style="display: none;">

                                        <label for="request_type_category">{{tr('request_type_category')}}</label>

                                        <div class="radio">

                                            <label>
                                                <input type="radio" @if(Setting::get('request_type_category') == 1) checked @endif name="request_type_category" id="request_type_category" value="1">
                                                {{tr('enable')}}
                                            </label>

                                            <label style="margin-left: 15px">
                                                <input type="radio" @if(Setting::get('request_type_category') == 0) checked @endif name="request_type_category" id="request_type_category" value="0">
                                                {{tr('disable')}}
                                            </label>
                                        </div>
                                        
                                    </div>

                                    <div class="form-group" style="display: none;">

                                        <label for="request_type_all">{{tr('request_type_all')}}</label>

                                        <div class="radio">

                                            <label>
                                                <input type="radio" @if(Setting::get('request_type_all') == 1) checked @endif name="request_type_all" id="request_type_all" value="1">
                                                {{tr('enable')}}
                                            </label>

                                            <label style="margin-left: 15px">
                                                <input type="radio" @if(Setting::get('request_type_all') == 0) checked @endif name="request_type_all" id="request_type_all" value="0">
                                                {{tr('disable')}}
                                            </label>
                                        </div>
                                        
                                    </div>
                                
                                </div>

                                <div class="col-md-4">

                                    <div class="form-group">

                                        <label>{{ tr('provider_time') }}</label>

                                        <p class="note">{{tr('provider_timeout_note')}}</p>

                                        <input type="number" name="provider_timeout" value="{{ Setting::get('provider_timeout', '')  }}" class="form-control" min="1">
                                    </div>

                                    <div class="form-group">

                                        <label>{{ tr('admin_commission') }} {{tr('in_percentage')}}</label>

                                        <p class="note">{{tr('admin_commission_note')}}</p>

                                        <input type="number" step="any" min="0" max="99" name="admin_commission" value="{{ Setting::get('admin_commission', '')  }}" required class="form-control">
                                    </div>

                                </div>

                                <div class="col-md-4">

                                    <div class="form-group">
                                        <label>{{ tr('search_radius') }}</label>

                                        <p class="note">{{tr('search_radius_note')}}</p>

                                        <input type="number" name="search_radius" min="5" value="{{ Setting::get('search_radius', '')  }}" class="form-control">
                                    </div>

                                    <div class="form-group">

                                        <label>{{ tr('tax_in_percentage') }}</label>

                                        <p class="note">{{tr('admin_tax_price_note')}}</p>

                                        <input type="number" step="any" min="0" max="99" title=" " name="tax_price" value="{{ Setting::get('tax_price', '')  }}"  class="form-control">
                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="box-footer">

                            <button type="reset" class="btn btn-warning">{{tr('reset')}}</button>

                            @if(Setting::get('admin_demo_control') == 1)
                                <button type="submit" class="btn btn-primary pull-right" disabled>{{tr('submit')}}</button>
                            @else
                                <button type="submit" class="btn bg-blue pull-right">{{tr('submit')}}</button>
                            @endif
                        
                        </div>
                    
                    </form>

                </div>

                <!-- Notification settings -->

                <div class="streamview-tab-content">

                    <form action="{{ (Setting::get('admin_demo_control') == 1) ? '' : route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">
                        
                        <div class="box-body">

                            <div class="row">

                                <div class="col-md-12">

                                    <h3 class="settings-sub-header text-uppercase">
                                        <b>{{tr('notification_settings')}}</b>
                                    </h3>

                                    <hr>

                                </div>
                                <div class="col-md-12">

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('push_notification')}}</h5>

                                        <label>

                                            <input type="radio" name="push_notification"  @if(Setting::get('push_notification') == 1) checked @endif class="flat-red" id="push_notification" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="push_notification"  @if(Setting::get('push_notification') == 0) checked @endif class="flat-red" id="push_notification" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('email_notification')}}</h5>

                                        <label>

                                            <input type="radio" name="email_notification"  @if(Setting::get('email_notification') == 1) checked @endif class="flat-red" id="email_notification" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="email_notification"  @if(Setting::get('email_notification') == 0) checked @endif class="flat-red" id="email_notification" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                </div>

                            </div>
                            
                        </div>

                        <div class="box-footer">

                            <button type="reset" class="btn btn-warning">{{tr('reset')}}</button>

                            @if(Setting::get('admin_demo_control') == 1)
                                <button type="submit" class="btn btn-primary pull-right" disabled>{{tr('submit')}}</button>
                            @else
                                <button type="submit" class="btn bg-blue pull-right">{{tr('submit')}}</button>
                            @endif
                        </div>

                    </form>
                
                </div>

                <!-- Social settings -->

                <div class="streamview-tab-content">
                    
                    <form action="{{ (Setting::get('admin_demo_control') == 1) ? '' : route('admin.common-settings.save')}}" method="POST" enctype="multipart/form-data" role="form">
                        <div class="box-body">

                            <div class="row">

                                <div class="col-md-12">

                                    <h3 class="settings-sub-header text-uppercase"><b>{{tr('social_settings')}}</b></h3>

                                    <hr>

                                </div>

                                <div class="col-md-12">

                                    <h5 class="sub-title" >{{tr('fb_settings')}}</h5>

                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="fb_client_id">{{tr('FB_CLIENT_ID')}}</label>
                                        <input type="text" class="form-control" name="FB_CLIENT_ID" id="fb_client_id" placeholder="{{tr('FB_CLIENT_ID')}}" value="{{envfile('FB_CLIENT_ID')}}">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="fb_client_secret">{{tr('FB_CLIENT_SECRET')}}</label>    
                                        <input type="text" class="form-control" name="FB_CLIENT_SECRET" id="fb_client_secret" placeholder="{{tr('FB_CLIENT_SECRET')}}" value="{{envfile('FB_CLIENT_SECRET')}}">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="fb_call_back">{{tr('FB_CALL_BACK')}}</label>    
                                        <input type="text" class="form-control" name="FB_CALL_BACK" id="fb_call_back" placeholder="{{tr('FB_CALL_BACK')}}" value="{{envfile('FB_CALL_BACK')}}">
                                    </div>
                                </div>

                            </div>
                        
                        </div>
                       
                        <div class="box-footer">

                            <button type="reset" class="btn btn-warning">{{tr('reset')}}</button>

                            @if(Setting::get('admin_demo_control') == 1)
                                <button type="submit" class="btn btn-primary pull-right" disabled>{{tr('submit')}}</button>
                            @else
                                <button type="submit" class="btn bg-blue pull-right">{{tr('submit')}}</button>
                            @endif
                        </div>

                    </form>
                
                </div>

                <!-- Payment settings -->

                <div class="streamview-tab-content">
                    
                    <form action="{{ (Setting::get('admin_demo_control') == 1) ? '' : route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">
                       
                        <div class="box-body">

                            <div class="row">

                                <div class="col-md-12">

                                    <h3 class="settings-sub-header text-uppercase"><b>{{tr('payment_settings')}}</b></h3>

                                    <hr>

                                </div>

                                <div class="col-md-12">

                                    <h5 class="sub-title" >{{tr('stripe_settings')}}</h5>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label for="stripe_publishable_key">{{tr('stripe_publishable_key')}}</label>
                                        <input type="text" value="{{ Setting::get('stripe_publishable_key')}}" class="form-control" name="stripe_publishable_key" id="stripe_publishable_key" placeholder="Enter {{tr('stripe_publishable_key')}}">
                                    </div>

                                </div>

                                <div class="col-md-6">
                                    
                                    <div class="form-group">
                                        
                                        <label for="stripe_secret_key">{{tr('stripe_secret_key')}}</label>
                                       
                                        <input type="text" value="{{ Setting::get('stripe_secret_key')}}" class="form-control" name="stripe_secret_key" id="stripe_secret_key" placeholder="Enter {{tr('stripe_secret_key')}}">
                                    </div>
                                </div>

                                <div class="clearfix"></div>

                                    <hr>

                                    <div class="col-md-12">

                                        <h5 class="sub-title" >{{tr('payment_mode_settings')}}</h5>
                                        <p class="note">{{tr('note')}} : {{tr('payment_mode_access_note')}}</p>
                                    </div>


                                    <div class="col-md-6">

                                        <div class="form-group">

                                            <label class="text-uppercase">{{ tr('card_payment') }}</label>

                                            <br>

                                            <select name="card" value="" required class="form-control select2">

                                                <option value="">{{ tr('select') }}</option>

                                                @if(Setting::get('card')!='')

                                                    @if(Setting::get('card') == YES)
                                                        <option value="1" selected="true">{{tr('enable')}}</option>
                                                        <option value="2" >{{tr('disable')}}</option>
                                                    @else
                                                        <option value="1" >{{tr('enable')}}</option>
                                                        <option value="2" selected="true">{{tr('disable')}}</option>
                                                    @endif
                                                @else
                                                    <option value="1">{{tr('enable')}}</option>
                                                    <option value="2">{{tr('disable')}}</option>
                                                @endif

                                            </select>

                                        </div>

                                    </div>

                                    <?php /*<div class="col-md-3">

                                        <div class="form-group">
                                            
                                            <label class="text-uppercase">{{ tr('cod') }}</label>

                                            <br>
                                            
                                            <select name="cod"  required class="form-control select2">
                                                
                                                <option value="">{{ tr('select') }}</option>
                                                
                                                @if(Setting::get('cod')!='')
                                                    @if(Setting::get('cod') == 1)
                                                        <option value="1" selected="true">{{tr('yes')}}</option>
                                                        <option value="2" >{{tr('no')}}</option>
                                                    @else
                                                        <option value="1" >{{tr('yes')}}</option>
                                                        <option value="2" selected="true">{{tr('no')}}</option>
                                                    @endif
                                                @else
                                                    <option value="1">{{tr('yes')}}</option>
                                                    <option value="2">{{tr('no')}}</option>
                                                @endif
                                            
                                            </select>

                                        </div>

                                    </div> */?>

                                <!-- @todo Wallet modeule to be done hence hidden referral_settings -->
                            <!--     <div class="col-md-12" >

                                    <h5 class="sub-title" >{{tr('referral_settings')}}</h5>

                                </div>
                                <div class="col-md-6">
                                
                                    <div class="form-group">
                                        
                                         <label for="referral_commission">{{ tr('referral_commission') }}</label>
                                    <input type="number" class="form-control" name="referral_commission" value="{{ Setting::get('referral_commission') }}" id="referral_commission" placeholder="{{ tr('referral_commission') }}"  min="0">
                                    </div>

                                </div> -->

                            </div>

                        </div>

                        <div class="box-footer">

                            <button type="reset" class="btn btn-warning">{{tr('reset')}}</button>

                            @if(Setting::get('admin_demo_control') == 1)
                                <button type="submit" class="btn btn-primary pull-right" disabled>{{tr('submit')}}</button>
                            @else
                                <button type="submit" class="btn bg-blue pull-right">{{tr('submit')}}</button>
                            @endif
                        </div>
                    </form>
                
                </div>

                <!-- SEO Settings -->

                <div class="streamview-tab-content">

                    <form action="{{ (Setting::get('admin_demo_control') == 1) ? '' : route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        <div class="box-body">

                            <div class="row">

                                <div class="col-md-12">

                                    <h3 class="settings-sub-header text-uppercase"><b>{{tr('seo_settings')}}</b></h3>

                                    <hr>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>{{ tr('meta_title') }} *</label>
                                         <input type="text" name="meta_title" value="{{ Setting::get('meta_title', '')  }}" required class="form-control" placeholder="{{tr('meta_title')}}">
                                    </div>
                                   
                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label for="meta_author">{{tr('meta_author')}}</label>
                                        <input type="text" class="form-control" value="{{Setting::get('meta_author')  }}" name="meta_author" id="meta_author" placeholder="{{tr('meta_author')}}">
                                    </div> 
                                
                                </div>

                                <div class="clearfix"></div>

                                <div class="col-md-12">

                                    <div class="form-group">
                                        <label for="meta_keywords">{{tr('meta_keywords')}}</label>
                                        <textarea class="form-control" id="meta_keywords" name="meta_keywords">{{Setting::get('meta_keywords')}}</textarea>
                                    </div>

                                    <div class="form-group">
                                        <label for="meta_description">{{tr('meta_description')}}</label>
                                        <textarea class="form-control" id="meta_description" name="meta_description">{{Setting::get('meta_description')}}</textarea>
                                    </div>  

                                </div>

                                <div class="clearfix"></div>


                            </div>
                        
                        </div>

                        <div class="box-footer">

                            <button type="reset" class="btn btn-warning">{{tr('reset')}}</button>

                            @if(Setting::get('admin_demo_control') == 1)
                                <button type="submit" class="btn btn-primary pull-right" disabled>{{tr('submit')}}</button>
                            @else
                                <button type="submit" class="btn bg-blue pull-right">{{tr('submit')}}</button>
                            @endif
                        </div>

                    </form>
                </div>

                <!-- Email settings -->

                <div class="streamview-tab-content">

                    <form action="{{ (Setting::get('admin_demo_control') == 1) ? '' : route('admin.common-settings.save')}}" method="POST" enctype="multipart/form-data" role="form">
                                
                        <div class="box-body">

                            <div class="row">

                                <div class="col-md-12">

                                    <h3 class="settings-sub-header text-uppercase"><b>{{tr('email_settings')}}</b></h3>

                                    <hr>

                                </div>


                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label for="paypal_client_id">{{tr('MAIL_DRIVER')}}</label>
                                        <input type="text" value="{{ envfile('MAIL_DRIVER')}}" class="form-control" name="MAIL_DRIVER" id="MAIL_DRIVER" placeholder="Enter {{tr('MAIL_DRIVER')}}">
                                    </div>

                                    <div class="form-group">
                                        <label for="MAIL_HOST">{{tr('MAIL_HOST')}}</label>
                                        <input type="text" class="form-control" value="{{envfile('MAIL_HOST')}}" name="MAIL_HOST" id="MAIL_HOST" placeholder="{{tr('MAIL_HOST')}}">
                                    </div>

                                    <div class="form-group">
                                        <label for="MAIL_PORT">{{tr('MAIL_PORT')}}</label>
                                        <input type="text" class="form-control" value="{{envfile('MAIL_PORT')}}" name="MAIL_PORT" id="MAIL_PORT" placeholder="{{tr('MAIL_PORT')}}">
                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label for="MAIL_USERNAME">{{tr('MAIL_USERNAME')}}</label>
                                        <input type="text" class="form-control" value="{{envfile('MAIL_USERNAME')}}" name="MAIL_USERNAME" id="MAIL_USERNAME" placeholder="{{tr('MAIL_USERNAME')}}">
                                    </div>

                                    <div class="form-group">
                                        <label for="MAIL_PASSWORD">{{tr('MAIL_PASSWORD')}}</label>
                                        <input type="password" class="form-control" name="MAIL_PASSWORD" id="MAIL_PASSWORD" placeholder="{{tr('MAIL_PASSWORD')}}">
                                    </div>

                                    <div class="form-group">
                                        <label for="MAIL_PORT">{{tr('MAIL_ENCRYPTION')}}</label>
                                        <input type="text" class="form-control" value="{{envfile('MAIL_ENCRYPTION')}}" name="MAIL_ENCRYPTION" id="MAIL_ENCRYPTION" placeholder="{{tr('MAIL_ENCRYPTION')}}">
                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="box-footer">

                            <button type="reset" class="btn btn-warning">{{tr('reset')}}</button>

                            @if(Setting::get('admin_demo_control') == 1)
                                <button type="submit" class="btn btn-primary pull-right" disabled>{{tr('submit')}}</button>
                            @else
                                <button type="submit" class="btn bg-blue pull-right">{{tr('submit')}}</button>
                            @endif

                        </div>

                    </form>
                
                </div>

                <!-- OTHER Settings -->

                <div class="streamview-tab-content">
                    <form action="{{(Setting::get('admin_demo_control') == 1) ? '' : route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">
                                
                        <div class="box-body"> 
                            <div class="row"> 

                                <div class="col-md-12">

                                    <h3 class="settings-sub-header text-uppercase"><b>{{tr('other_settings')}}</b></h3>

                                    <hr>

                                </div>

                                <div class="col-md-6">

                                    @if(Setting::get('admin_language_control') == 0)

                                        <div class="form-group">

                                            <label for="amount">{{tr('default_lang')}}</label>

                                            <select class="form-control" name="default_lang" id="default_lang">

                                                <option value="">{{tr('language')}}</option>
                                                    @foreach($languages as $h => $language)
                                                        <option value="{{$language->folder_name}}" {{(Setting::get('default_lang') == $language->folder_name) ? 'selected' : Setting::get('default_lang')}}>{{$language->language}}({{$language->folder_name}})</option>
                                                    @endforeach
                                                
                                                </select>
                                        
                                        </div> 

                                    @endif

                                     <div class="form-group">

                                        <label for="browser_key">{{tr('browser_key')}}</label>

                                        <input type="text" class="form-control" value="{{Setting::get('browser_key')}}" name="browser_key" id="browser_key" placeholder="{{tr('browser_key')}}">

                                    </div>  

                                    <div class="form-group">

                                        <label for="GOOGLE_API_KEY">{{tr('GOOGLE_API_KEY')}}</label>

                                        <input type="text" class="form-control" value="{{Setting::get('GOOGLE_API_KEY')}}" name="GOOGLE_API_KEY" id="GOOGLE_API_KEY" placeholder="{{tr('GOOGLE_API_KEY')}}">

                                    </div>

                                    <div class="form-group">

                                        <label for="SOCKET_SERVER">{{tr('SOCKET_SERVER')}}</label>

                                        <input type="text" class="form-control" value="{{Setting::get('SOCKET_SERVER')}}" name="SOCKET_SERVER" id="SOCKET_SERVER" placeholder="{{tr('SOCKET_SERVER')}}">

                                    </div>

                                </div>

                                <div class="col-md-6 ">

                                    <div class="form-group">
                                        <label>{{ tr('user_playstore') }}</label>
                                        <input type="text" name="playstore" value="{{ Setting::get('playstore', '')  }}"  class="form-control">
                                    </div>

                                    <div class="form-group">
                                        <label>{{ tr('provider_playstore') }}</label>
                                        <input type="text" name="playstore_provider" value="{{ Setting::get('playstore_provider', '')  }}"  class="form-control">
                                    </div>

                                     <div class="form-group">
                                        <label>{{ tr('user_appstore') }}</label>
                                        <input type="text" name="appstore" value="{{ Setting::get('appstore', '')  }}"  class="form-control">
                                    </div>

                                    <div class="form-group">
                                        <label>{{ tr('provider_appstore') }}</label>
                                        <input type="text" name="appstore_provider" value="{{ Setting::get('appstore_provider', '')  }}"  class="form-control">
                                    </div>

                                </div>

                                <div class="col-md-12">

                                    <div class="form-group">
                                        
                                        <label for="google_analytics">{{tr('google_analytics')}}</label>

                                        <textarea class="form-control" id="google_analytics" rows="6" name="google_analytics" style="resize: none;">{{Setting::get('google_analytics')}}</textarea>
                                    </div>  

                                </div>

                            </div>
                        </div>
                              <!-- /.box-body -->

                        <div class="box-footer">

                            <button type="reset" class="btn btn-warning">{{tr('reset')}}</button>

                            @if(Setting::get('admin_demo_control') == 1)
                                <button type="submit" class="btn btn-primary pull-right" disabled>{{tr('submit')}}</button>
                            @else
                                <button type="submit" class="btn bg-blue pull-right">{{tr('submit')}}</button>
                            @endif
                        </div>
                    </form>
                
                </div>

            </div>
        
        </div>
        
        <div class="clearfix"></div>

    </div>

@endsection

@section('scripts')

    <script type="text/javascript">
        
        $(document).ready(function() {
            $("div.streamview-tab-menu>div.list-group>a").click(function(e) {
                e.preventDefault();
                $(this).siblings('a.active').removeClass("active");
                $(this).addClass("active");
                var index = $(this).index();
                $("div.streamview-tab>div.streamview-tab-content").removeClass("active");
                $("div.streamview-tab>div.streamview-tab-content").eq(index).addClass("active");
            });
        });
    </script>

@endsection