<!-- NOT USING - FOR BACKUP PURPOSE -->

@extends('layouts.admin')

@section('title', tr('settings'))

@section('content-header', tr('settings'))

@section('breadcrumb')

    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>

    <li class="active"><i class="fa fa-gears"></i> {{tr('settings')}}</li>

@endsection

@section('styles')

<style>
    
    label {
        font-weight: 550;
    }
    
</style>
@endsection 

@section('content')

@include('notification.notify')

    <div class="row">

        <div class="col-md-12">

            <div class="nav-tabs-custom">

                <ul class="nav nav-tabs">

                    <li class="active">
                        <a href="#site_settings" data-toggle="tab" aria-expanded="true">{{tr('site_settings')}}</a>
                    </li>

                    <li class="">
                        <a href="#job_settings" data-toggle="tab" aria-expanded="false">{{tr('job_settings')}}</a>
                    </li>

                    <li class="">
                        <a href="#notification_settings" data-toggle="tab" aria-expanded="false">{{tr('notification_settings')}}</a>
                    </li>

                    <li class="">
                        <a href="#payment_settings" data-toggle="tab" aria-expanded="false">{{tr('payment_settings')}}</a>
                    </li>

                    <li class="">
                        <a href="#social_settings" data-toggle="tab" aria-expanded="false">{{tr('social_settings')}}</a>
                    </li>

                    <li class="">
                        <a href="#email_settings" data-toggle="tab" aria-expanded="false">{{tr('email_settings')}}</a>
                    </li>

                    <li class="">
                        <a href="#other_settings" data-toggle="tab" aria-expanded="false">{{tr('other_settings')}}</a>
                    </li>

                    <li class="pull-right"><a href="#" class="text-muted"><i class="fa fa-gear"></i></a></li>
                
                </ul>

                <div class="tab-content">

                    <div class="tab-pane active" id="site_settings">

                        @if(Setting::get('admin_demo_control'))

                            <form class="" action="#" role="form">

                        @else

                            <form action="{{route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        @endif

                            <div class="box-body">

                                <div class="col-md-12">

                                    <div class="form-group">

                                        <label for="sitename" class="text-uppercase">{{tr('site_name')}}</label>

                                        <input type="text" class="form-control" name="site_name" value="{{ Setting::get('site_name')  }}" id="sitename" placeholder="{{tr('enter_site_name')}}">

                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">

                                        <label for="site_logo" class="text-uppercase">{{tr('site_logo')}}</label>

                                        <input type="file" id="site_logo" name="site_logo" accept="image/x-png, image/jpeg">

                                        <p class="help-block">{{tr('image_upload_png_jpeg')}}</p>

                                        @if(Setting::get('site_logo'))
                                            <img class="img img-responsive img-thumbnail" src="{{Setting::get('site_logo')}}">

                                        @endif

                                        <br>

                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">

                                        <label for="site_icon" class="text-uppercase">{{tr('site_icon')}}</label>
                                        
                                        <input type="file" id="site_icon" name="site_icon" accept="image/png">
                                        
                                        <p class="help-block">{{tr('upload_image_png_only')}}</p>

                                        @if(Setting::get('site_icon'))
                                            <img class="img img-responsive img-thumbnail" src="{{Setting::get('site_icon')}}">

                                        @endif

                                        <br>

                                    </div>
                                </div>

                            </div>
                            
                            <!-- /.box-body -->

                            <div class="box-footer">
                                <button type="reset" class="btn btn-warning">{{tr('cancel')}}</button>
                                <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>
                            </div>
                        </form>
                        
                    </div>

                    <div class="tab-pane" id="job_settings">

                        @if(Setting::get('admin_demo_control'))

                            <form class="form-horizontal" action="#" role="form">

                        @else
                        
                            <form action="{{route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        @endif

                            <div class="box-body">

                                <div class="col-md-3">

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('request_now')}}</h5>

                                        <label>

                                            <input type="radio" name="request_now"  @if(Setting::get('request_now') == 1) checked @endif class="flat-red" id="request_now" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="request_now"  @if(Setting::get('request_now') == 0) checked @endif class="flat-red" id="request_now" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('request_later')}}</h5>

                                        <label>

                                            <input type="radio" name="request_later"  @if(Setting::get('request_later') == 1) checked @endif class="flat-red" id="request_later" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="request_later"  @if(Setting::get('request_later') == 0) checked @endif class="flat-red" id="request_later" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('request_type_location')}}</h5>

                                        <label>

                                            <input type="radio" name="request_type_location"  @if(Setting::get('request_type_location') == 1) checked @endif class="flat-red" id="request_type_location" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="request_type_location"  @if(Setting::get('request_type_location') == 0) checked @endif class="flat-red" id="request_type_location" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                    <div class="form-group">

                                        <h5 class="text-uppercase">{{tr('request_type_direct')}}</h5>

                                        <label>

                                            <input type="radio" name="request_type_direct"  @if(Setting::get('request_type_direct') == 1) checked @endif class="flat-red" id="request_type_direct" value="1">

                                            {{tr('enable')}}

                                        </label>

                                        <label>

                                            <input type="radio" name="request_type_direct"  @if(Setting::get('request_type_direct') == 0) checked @endif class="flat-red" id="request_type_direct" value="0">

                                            {{tr('disable')}}

                                        </label>
                                    
                                    </div>

                                    <div class="form-group" style="display: none;">

                                        <label for="request_type_category">{{tr('request_type_category')}}</label>

                                        <div class="radio">

                                            <label>
                                                <input type="radio" @if(Setting::get('request_type_category') == 1) checked @endif name="request_type_category" id="request_type_category" value="1">
                                                {{tr('enable')}}
                                            </label>

                                            <label style="margin-left: 15px">
                                                <input type="radio" @if(Setting::get('request_type_category') == 0) checked @endif name="request_type_category" id="request_type_category" value="0">
                                                {{tr('disable')}}
                                            </label>
                                        </div>
                                        
                                    </div>

                                    <div class="form-group" style="display: none;">

                                        <label for="request_type_all">{{tr('request_type_all')}}</label>

                                        <div class="radio">

                                            <label>
                                                <input type="radio" @if(Setting::get('request_type_all') == 1) checked @endif name="request_type_all" id="request_type_all" value="1">
                                                {{tr('enable')}}
                                            </label>

                                            <label style="margin-left: 15px">
                                                <input type="radio" @if(Setting::get('request_type_all') == 0) checked @endif name="request_type_all" id="request_type_all" value="0">
                                                {{tr('disable')}}
                                            </label>
                                        </div>
                                        
                                    </div>
                                
                                </div>

                                <div class="col-md-4">

                                    <div class="form-group">

                                        <label>{{ tr('provider_time') }}</label>

                                        <p class="note">{{tr('provider_timeout_note')}}</p>

                                        <input type="number" name="provider_timeout" value="{{ Setting::get('provider_timeout', '')  }}" class="form-control">
                                    </div>

                                    <div class="form-group">

                                        <label>{{ tr('admin_commission') }} {{tr('in_percentage')}}</label>

                                        <p class="note">{{tr('admin_commission_note')}}</p>

                                        <input type="number" step="any" min="0" max="99" name="admin_commission" value="{{ Setting::get('admin_commission', '')  }}" required class="form-control">
                                    </div>

                                </div>

                                <div class="col-md-4">

                                    <div class="form-group">
                                        <label>{{ tr('search_radius') }}</label>

                                        <p class="note">{{tr('search_radius_note')}}</p>

                                        <input type="number" name="search_radius" value="{{ Setting::get('search_radius', '')  }}" class="form-control">
                                    </div>

                                    <div class="form-group">

                                        <label>{{ tr('tax_in_percentage') }}</label>

                                        <p class="note" style="margin-bottom: 30px">{{tr('admin_tax_price_note')}}</p>

                                        <input type="number" step="any" min="0" max="99" title=" " name="tax_price" value="{{ Setting::get('tax_price', '')  }}"  class="form-control">
                                    </div>

                                </div>

                            </div>

                            <div class="box-footer">

                                <button type="reset" class="btn btn-warning">{{tr('cancel')}}</button>

                                <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>                            
                            </div>
                        
                        </form>

                    </div>

                    <div class="tab-pane" id="notification_settings">

                        @if(Setting::get('admin_demo_control'))

                            <form class="form-horizontal" action="#" role="form">

                        @else

                        <form action="{{route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        @endif

                            <div class="box-body">

                                <div class="form-group">

                                    <h5 class="text-uppercase">{{tr('push_notification')}}</h5>

                                    <label>

                                        <input type="radio" name="push_notification"  @if(Setting::get('push_notification') == 1) checked @endif class="flat-red" id="push_notification" value="1">

                                        {{tr('enable')}}

                                    </label>

                                    <label>

                                        <input type="radio" name="push_notification"  @if(Setting::get('push_notification') == 0) checked @endif class="flat-red" id="push_notification" value="0">

                                        {{tr('disable')}}

                                    </label>
                                
                                </div>

                                <div class="form-group">

                                    <h5 class="text-uppercase">{{tr('email_notification')}}</h5>

                                    <label>

                                        <input type="radio" name="email_notification"  @if(Setting::get('email_notification') == 1) checked @endif class="flat-red" id="email_notification" value="1">

                                        {{tr('enable')}}

                                    </label>

                                    <label>

                                        <input type="radio" name="email_notification"  @if(Setting::get('email_notification') == 0) checked @endif class="flat-red" id="email_notification" value="0">

                                        {{tr('disable')}}

                                    </label>
                                
                                </div>

                                <!-- <div class="form-group">

                                    <label for="sms_notification">{{tr('sms_notification')}}</label>

                                    <div class="radio">

                                        <label>
                                            <input type="radio" @if(Setting::get('sms_notification') == 1) checked @endif name="sms_notification" id="sms_notification" value="1">
                                            {{tr('enable')}}
                                        </label>

                                        <label style="margin-left: 15px">
                                            <input type="radio" @if(Setting::get('sms_notification') == 0) checked @endif name="sms_notification" id="sms_notification" value="0">
                                            {{tr('disable')}}
                                        </label>
                                    </div>
                                    
                                </div> -->

                            </div>
                                

                            <div class="box-footer">
                                <button type="reset" class="btn btn-warning">{{tr('cancel')}}</button>
                                <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>                            
                            </div>
                        </form>

                    </div>

                    <div class="tab-pane" id="social_settings">

                        <form action="{{ (Setting::get('admin_demo_control') == 1) ? '' : route('admin.common-settings.save')}}" method="POST" enctype="multipart/form-data" role="form">
                            <div class="box-body">
                                <h4>{{tr('fb_settings')}}</h4>
                                <hr>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="fb_client_id">{{tr('FB_CLIENT_ID')}}</label>
                                        <input type="text" class="form-control" name="FB_CLIENT_ID" id="fb_client_id" placeholder="{{tr('FB_CLIENT_ID')}}" value="{{envfile('FB_CLIENT_ID')}}">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="fb_client_secret">{{tr('FB_CLIENT_SECRET')}}</label>    
                                        <input type="text" class="form-control" name="FB_CLIENT_SECRET" id="fb_client_secret" placeholder="{{tr('FB_CLIENT_SECRET')}}" value="{{envfile('FB_CLIENT_SECRET')}}">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="fb_call_back">{{tr('FB_CALL_BACK')}}</label>    
                                        <input type="text" class="form-control" name="FB_CALL_BACK" id="fb_call_back" placeholder="{{tr('FB_CALL_BACK')}}" value="{{envfile('FB_CALL_BACK')}}">
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                            </div>
                            <div class="box-footer">
                                @if(Setting::get('admin_demo_control') == 1) 
                                    <button type="submit" class="btn btn-primary" disabled>{{tr('submit')}}</button>
                                @else
                                    <button type="submit" class="btn btn-primary">{{tr('submit')}}</button>
                                @endif
                          </div>
                        </form>

                    </div>

                    <div class="tab-pane" id="payment_settings">

                        @if(Setting::get('admin_demo_control'))

                            <form class="" action="#" role="form">

                        @else
                        
                            <form action="{{route('admin.common-settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        @endif

                            <div class="box-body">

                                <h4>{{tr('stripe_settings')}}</h4>

                                <hr>

                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label for="stripe_publishable_key">{{tr('stripe_publishable_key')}}</label>
                                        <input type="text" value="{{ Setting::get('stripe_publishable_key')}}" class="form-control" name="stripe_publishable_key" id="stripe_publishable_key" placeholder="Enter {{tr('stripe_publishable_key')}}">
                                    </div>

                                </div>

                                <div class="col-md-6">
                                    
                                    <div class="form-group">
                                        
                                        <label for="stripe_secret_key">{{tr('stripe_secret_key')}}</label>
                                       
                                        <input type="text" value="{{ Setting::get('stripe_secret_key')}}" class="form-control" name="stripe_secret_key" id="stripe_secret_key" placeholder="Enter {{tr('stripe_secret_key')}}">
                                    </div>
                                </div>

                                <div class="clearfix"></div>

                                <hr>

                                <div class="col-md-3">

                                    <div class="form-group">

                                        <label class="text-uppercase">{{ tr('card_payment') }}</label>

                                        <br>

                                        <select name="card" value="" required class="form-control select2">

                                            <option value="">{{ tr('select') }}</option>

                                            @if(Setting::get('card')!='')

                                                @if(Setting::get('card') == 1)
                                                    <option value="1" selected="true">{{tr('yes')}}</option>
                                                    <option value="2" >{{tr('no')}}</option>
                                                @else
                                                    <option value="1" >{{tr('yes')}}</option>
                                                    <option value="2" selected="true">{{tr('no')}}</option>
                                                @endif
                                            @else
                                                <option value="1">{{tr('yes')}}</option>
                                                <option value="2">{{tr('no')}}</option>
                                            @endif

                                        </select>

                                    </div>

                                </div>

                                <?php /*<div class="col-md-3">                                
                                    <div class="form-group">
                                        
                                        <label class="text-uppercase">{{ tr('cod') }}</label>

                                        <br>
                                        
                                        <select name="cod"  required class="form-control select2">
                                            
                                            <option value="">{{ tr('select') }}</option>
                                            
                                            @if(Setting::get('cod')!='')
                                                @if(Setting::get('cod') == 1)
                                                    <option value="1" selected="true">{{tr('yes')}}</option>
                                                    <option value="2" >{{tr('no')}}</option>
                                                @else
                                                    <option value="1" >{{tr('yes')}}</option>
                                                    <option value="2" selected="true">{{tr('no')}}</option>
                                                @endif
                                            @else
                                                <option value="1">{{tr('yes')}}</option>
                                                <option value="2">{{tr('no')}}</option>
                                            @endif
                                        
                                        </select>

                                    </div>

                                </div> */?>

                            </div>

                            <div class="box-footer">

                                <button type="reset" class="btn btn-warning">{{tr('cancel')}}</button>

                                <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>                            
                            </div>
                        
                        </form>

                    </div>

                    <div class="tab-pane" id="email_settings">

                       <form action="{{ (Setting::get('admin_demo_control') == 1) ? '' : route('admin.common-settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                            <div class="box-body">

                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label for="paypal_client_id">{{tr('MAIL_DRIVER')}}</label>
                                        <input type="text" value="{{ envfile('MAIL_DRIVER')}}" class="form-control" name="MAIL_DRIVER" id="MAIL_DRIVER" placeholder="Enter {{tr('MAIL_DRIVER')}}">
                                    </div>

                                    <div class="form-group">
                                        <label for="MAIL_HOST">{{tr('MAIL_HOST')}}</label>
                                        <input type="text" class="form-control" value="{{envfile('MAIL_HOST')}}" name="MAIL_HOST" id="MAIL_HOST" placeholder="{{tr('MAIL_HOST')}}">
                                    </div>

                                    <div class="form-group">
                                        <label for="MAIL_PORT">{{tr('MAIL_PORT')}}</label>
                                        <input type="text" class="form-control" value="{{envfile('MAIL_PORT')}}" name="MAIL_PORT" id="MAIL_PORT" placeholder="{{tr('MAIL_PORT')}}">
                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label for="MAIL_USERNAME">{{tr('MAIL_USERNAME')}}</label>
                                        <input type="text" class="form-control" value="{{envfile('MAIL_USERNAME')}}" name="MAIL_USERNAME" id="MAIL_USERNAME" placeholder="{{tr('MAIL_USERNAME')}}">
                                    </div>

                                    <div class="form-group">
                                        <label for="MAIL_PASSWORD">{{tr('MAIL_PASSWORD')}}</label>
                                        <input type="password" class="form-control" name="MAIL_PASSWORD" id="MAIL_PASSWORD" placeholder="{{tr('MAIL_PASSWORD')}}">
                                    </div>

                                    <div class="form-group">
                                        <label for="MAIL_PORT">{{tr('MAIL_ENCRYPTION')}}</label>
                                        <input type="text" class="form-control" value="{{envfile('MAIL_ENCRYPTION')}}" name="MAIL_ENCRYPTION" id="MAIL_ENCRYPTION" placeholder="{{tr('MAIL_ENCRYPTION')}}">
                                    </div>

                                </div>

                            </div>

                            <div class="box-footer">
                                
                                <button type="reset" class="btn btn-warning">{{tr('cancel')}}</button>
                                
                                <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>                            
                            </div>
                            
                        </form>

                    </div>

                    

                    <div class="tab-pane" id="other_settings">

                        @if(Setting::get('admin_demo_control'))

                            <form class="" action="#" role="form">

                        @else

                            <form action="{{route('admin.settings.save')}}" method="POST" enctype="multipart/form-data" role="form">

                        @endif

                        <div class="box-body">

                            <div class="col-md-6">

                                @if(Setting::get('admin_language_control') == 0)

                                    <div class="form-group">

                                        <label for="amount">{{tr('default_lang')}}</label>

                                        <select class="form-control" name="default_lang" id="default_lang">

                                            <option value="">{{tr('language')}}</option>
                                                @foreach($languages as $h => $language)
                                                    <option value="{{$language->folder_name}}" {{(Setting::get('default_lang') == $language->folder_name) ? 'selected' : Setting::get('default_lang')}}>{{$language->language}}({{$language->folder_name}})</option>
                                                @endforeach
                                            
                                            </select>
                                    
                                    </div> 

                                @endif

                                 <div class="form-group">

                                    <label for="browser_key">{{tr('browser_key')}}</label>

                                    <input type="text" class="form-control" value="{{Setting::get('browser_key')}}" name="browser_key" id="browser_key" placeholder="{{tr('browser_key')}}">

                                </div>  

                                <div class="form-group">

                                    <label for="GOOGLE_API_KEY">{{tr('GOOGLE_API_KEY')}}</label>

                                    <input type="text" class="form-control" value="{{Setting::get('GOOGLE_API_KEY')}}" name="GOOGLE_API_KEY" id="GOOGLE_API_KEY" placeholder="{{tr('GOOGLE_API_KEY')}}">

                                </div>

                                <div class="form-group">

                                    <label for="SOCKET_SERVER">{{tr('SOCKET_SERVER')}}</label>

                                    <input type="text" class="form-control" value="{{Setting::get('SOCKET_SERVER')}}" name="SOCKET_SERVER" id="SOCKET_SERVER" placeholder="{{tr('SOCKET_SERVER')}}">

                                </div>  

                                <!-- <div class="form-group" style="display: none;">
                                        <label>
                                          {{ tr('currency') }} ( <strong>{{ Setting::get('currency', '')  }} </strong>)
                                        </label>
                                         <select name="currency" value="" required class="form-control">
                                            @if(Setting::get('currency')!='')
                                            <option value="{{ $symbol }}">{{ $currency }}</option>
                                            @else
                                            <option value="">{{ tr('select') }}</option>
                                            @endif
                                            <option value="$">US Dollar (USD)</option>
                                            <option value="₹"> Indian Rupee (INR)</option>
                                            <option value="د.ك">Kuwaiti Dinar (KWD)</option>
                                            <option value="د.ب">Bahraini Dinar (BHD)</option>
                                            <option value="﷼">Omani Rial (OMR)</option>
                                            <option value="£">British Pound (GBP)</option>
                                            <option value="€">Euro (EUR)</option>
                                            <option value="CHF">Swiss Franc (CHF)</option>
                                            <option value="ل.د">Libyan Dinar (LYD)</option>
                                            <option value="B$">Bruneian Dollar (BND)</option>
                                            <option value="S$">Singapore Dollar (SGD)</option>
                                            <option value="AU$"> Australian Dollar (AUD)</option>
                                            </select>
                                </div> -->
                               

                            </div>

                            <div class="col-md-6 ">

                                <div class="form-group">
                                    <label>{{ tr('user_playstore') }}</label>
                                    <input type="text" name="playstore" value="{{ Setting::get('playstore', '')  }}"  class="form-control">
                                </div>

                                <div class="form-group">
                                    <label>{{ tr('provider_playstore') }}</label>
                                    <input type="text" name="playstore_provider" value="{{ Setting::get('playstore_provider', '')  }}"  class="form-control">
                                </div>

                                 <div class="form-group">
                                    <label>{{ tr('user_appstore') }}</label>
                                    <input type="text" name="appstore" value="{{ Setting::get('appstore', '')  }}"  class="form-control">
                                </div>

                                <div class="form-group">
                                    <label>{{ tr('provider_appstore') }}</label>
                                    <input type="text" name="appstore_provider" value="{{ Setting::get('appstore_provider', '')  }}"  class="form-control">
                                </div>

                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    
                                    <label for="google_analytics">{{tr('google_analytics')}}</label>

                                    <textarea class="form-control" id="google_analytics" rows="6" name="google_analytics" style="resize: none;">{{Setting::get('google_analytics')}}</textarea>
                                </div>  

                            </div>

                        </div>

                            <div class="box-footer">
                                <button type="reset" class="btn btn-warning">{{tr('cancel')}}</button>
                                
                                <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_demo_control')) disabled @endif>{{tr('submit')}}</button>                            
                            </div>
                        </form>

                    </div>
                
                </div>

                <!-- /.tab-content -->
            </div>

        </div>
    
    </div>


@endsection