@extends('layouts.admin')

@section('title', tr('sub_admins'))

@section('content-header', tr('sub_admins'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li class="active"><i class="fa fa-user"></i> {{ tr('sub_admins') }}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">
		
        <div class="col-xs-12">

	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
                
	                <b>{{ tr('sub_admins') }}</b>

	                
	                <a href="{{ route('admin.sub_admins.create') }}" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-plus"></i> {{ tr('sub_admin_create') }}</b>
	                </a>
	           
            	</div>
            
	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">
						<thead>
						    <tr>
								<th>{{ tr('id') }}</th>
								<th>{{ tr('username') }}</th>
								<th>{{ tr('email') }}</th>
								<th>{{ tr('mobile') }}</th>
								<th>{{ tr('status') }}</th>
								<th>{{ tr('action') }}</th>
						    </tr>
						
						</thead>

						<tbody>
							
							@foreach($sub_admins as $i => $sub_admin_details)

							    <tr>
							      	<td>{{  $i+1  }}</td>
							      	<td>
							      		<a href="{{ route('admin.sub_admins.view' , ['sub_admin_id' => $sub_admin_details->id]) }}">
							      			{{ $sub_admin_details->name }}
							      		</a>
							      	</td>

							      	<td>{{ $sub_admin_details->email }}</td>
							      											      
							      	<td>
							      		{{ $sub_admin_details->mobile }}
							      	</td>
							      	
							      	<td>
								      	@if($sub_admin_details->status)

								      		<span class="label label-success">{{ tr('approved') }}</span>

								      	@else

								      		<span class="label label-warning">{{ tr('pending') }}</span>

								      	@endif
							     	</td>
							     	<td>											
										<div class="dropdown @if($i < 2) dropdown @else dropup @endif">	

											<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">	
												{{ tr('action') }}<span class="caret"></span>
											</button>

											<ul class="dropdown-menu" aria-labelledby="dropdownMenu">
												
												<li>
													<a href="{{ route('admin.sub_admins.view' , [ 'sub_admin_id' => $sub_admin_details->id ] ) }}">		
														<b>{{ tr('view') }}</b>
													</a>
												</li>

							                  	@if(Setting::get('admin_delete_control') == YES)

								                  	<li role="presentation"><a role="menuitem" tabindex="-1" href="javascript:;"> <b> {{ tr('edit') }}</b> </a></li>

								                  	<li role="presentation"><a role="menuitem" tabindex="-1" href="javascript:;"> <b> {{ tr('delete') }}</b> </a></li>

							                  	@else
							                  	
								                  	<li role="presentation"><a role="menuitem" tabindex="-1" href="{{ route('admin.sub_admins.edit' , ['sub_admin_id'=>$sub_admin_details->id] ) }}"> <b> {{ tr('edit') }}</b> </a></li>

								                  	<li role="presentation"><a role="menuitem" tabindex="-1" href="{{ route('admin.sub_admins.delete' , ['sub_admin_id' => $sub_admin_details->id]) }}" onclick="return confirm(&quot;{{ tr('admin_sub_admin_delete_confirmation' , $sub_admin_details->name) }}&quot;);" > <b> {{ tr('delete') }}</b> </a></li>
							                  	
							                  	@endif
							                  
							                  	<li role="presentation" class="divider"></li>

							                  	@if($sub_admin_details->status == YES )
							                  		<li role="presentation"><a role="menuitem" onclick="return confirm(&quot;{{ $sub_admin_details->name }} - {{ tr('admin_sub_admin_decline_confirmation') }}&quot;);" tabindex="-1" href="{{ route('admin.sub_admins.status' , ['sub_admin_id' => $sub_admin_details->id]) }}"> <b>{{ tr('decline') }}</b></a></li>
							                  	 @else 
							                  	 	<li role="presentation"><a role="menuitem" onclick="return confirm(&quot;{{ $sub_admin_details->name }} - {{ tr('admin_sub_admin_approve_confirmation') }}&quot;);" tabindex="-1" href="{{ route('admin.sub_admins.status' , ['sub_admin_id'=>$sub_admin_details->id]) }}"> <b>
							                  		{{ tr('approve') }} </b></a></li>
							                  	@endif
											</ul>

										</div>

									</td>

								</tr>

						    @endforeach
						
						</tbody>

					</table>

            
	            </div>
         	
         	</div>

        </div>
        
    </div>


@endsection

