 <form action="{{ route('admin.sub_categories.save') }}" method="POST" enctype="multipart/form-data" role="form">

    <input type="hidden" name="sub_category_id" value="{{  $sub_category_details->id }}">

    <div class="box-body">

        <div class="form-group">

            <label>{{ tr('select_category') }} * </label>
            
            <select name="category_id" required class="form-control select2" autofocus>

                <option value="">{{  tr('select_category') }} </option>

                @foreach($categories as $category)

                    @if( $sub_category_details->category_id == $category->category_id)
                        <option value="{{ $category->category_id }}" selected>{{ $category->category_name }}</option>
                    @else
                        <option value="{{ $category->category_id }}">{{ $category->category_name }}</option>
                    @endif

                @endforeach

            </select>                           
            
        </div>

        <div class="form-group">
            <label for="sub_categoryname">{{ tr('name') }} * </label>

            <input type="text" required name="name" class="form-control" id="sub_categoryname" value="{{  old('name') ?: $sub_category_details->name }}" placeholder="{{ tr('sub_category_name') }}">
        </div>

        <div class="form-group">

            <label for="price">{{ tr('price') }} * </label>

            <input type="number" step="any" min="1" title="This must be a number with up to 2 decimal places and/or %" required name="price" class="form-control" id="price" value="{{  old('price') ?: $sub_category_details->price }}" placeholder="{{ tr('price_per_hour') }}" onkeypress="return isNumber(event)">

        </div>

        <div class="form-group">
            <label for="email">{{ tr('description') }} * </label>
            <input type="text" required class="form-control" id="description" name="description" value="{{  old('description') ?: $sub_category_details->description }}" placeholder="{{ tr('description') }}">
        </div>

        <div class="form-group">
            
            <label for="picture">{{ tr('picture') }} * </label>
            
            <input type="file" class="form-control" name="picture" id="picture" accept="image/png,image/jpeg" onchange="loadFile(this,'image_preview')" accept="image/*">
            
            <br>
            
            @if( $sub_category_details->id != '' )
                <img id="image_preview" style="height: 90px; margin-bottom: 15px; border-radius:2em;" src="{{  $sub_category_details->picture}}">
            @endif

        </div>
    
    </div>

    <div class="box-footer">
    
        <button type="reset" class="btn btn-danger">{{ tr('reset') }}</button>
        @if(Setting::get('admin_demo_control'))
        <button type="button" class="btn btn-success pull-right" disabled>{{tr('submit')}}</button>
        @else
        <button type="submit" class="btn btn-success pull-right">{{ tr('submit') }}</button>
        @endif

    </div>

</form>