@extends('layouts.admin')

@section('title', tr('edit_sub_category'))

@section('content-header', tr('edit_sub_category'))

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li><a href="{{route('admin.sub_categories.index')}}"><i class="fa fa-suitcase"></i> {{tr('sub_categories')}}</a></li>
    <li class="active">{{tr('edit_sub_category')}}</li>
@endsection

@section('content')
    <div class="row">

        <div class="col-md-10 col-md-offset-1">
            
            @include('notification.notify')

        </div>

    </div>

    <div class="row">

        <div class="col-md-10 col-md-offset-1">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b>{{tr('edit_sub_category')}}</b>

                    <a href="{{route('admin.sub_categories.index')}}" style="float:right" class="btn btn-warning"><b><i class="fa fa-eye"></i>
                        {{tr('view_sub_categories')}}</b>
                    </a>

                </div>

                @include('admin.sub_categories._form')
                          
            </div>

        </div>

    </div>

@endsection

@section('scripts')

    <script type="text/javascript">
        
        function loadFile(event, id){

        $("#"+id).show();
        
          var reader = new FileReader();

          reader.onload = function(){

          var output = document.getElementById(id);
        
            output.src = reader.result;
            
          };
          
          reader.readAsDataURL(event.files[0]);
        }
    </script>

@endsection