@extends('layouts.admin')

@section('title', tr('sub_categories'))

@section('content-header')

{{tr('sub_categories')}}

	@if($category_details)

	<a href="{{route('admin.categories.index')}}">
		- {{$category_details->name}}
	</a>

	@endif

@endsection

@section('breadcrumb')
    <li><a href="{{route('admin.dashboard')}}"><i class="fa fa-dashboard"></i>{{tr('home')}}</a></li>
    <li class="active"><i class="fa fa-suitcase"></i> {{tr('sub_categories')}}</li>
@endsection

@section('content')

@include('notification.notify')

<div class="row">
    
    <div class="col-xs-12">
        
        <div class="box box-success">

           	<div class="box-header with-border admin-panel-success">

                <b>{{tr('sub_categories')}}</b>

                <a href="{{route('admin.sub_categories.create')}}" style="float:right" class="btn btn-warning">
                	<b><i class="fa fa-plus"></i> {{tr('add_sub_category')}}</b>
                </a>
                
            </div>
            
            <div class="box-body">

				@if(count($sub_category) > 0)

					<div class="table table-responsive">

		              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

							<thead>
							    <tr>
							      <th>{{tr('id')}}</th>
							      <th>{{tr('sub_category')}}</th>
							      <th>{{tr('category')}}</th>
							      <th>{{tr('price')}}</th>
							      <th>{{tr('status')}}</th>
							      <th>{{tr('image')}}</th>
							      <th>{{tr('action')}}</th>
							    </tr>
							</thead>

							<tbody>

								@foreach($sub_category as $i => $sub_category_details)

								    <tr>
	                                    <td>{{showEntries($_GET,$i + 1)}}</td>
								      	
								      	<td>{{ $sub_category_details->name}}</td>
								      	
								      	<td>
								      		@if($sub_category_details->category) 
								      		{{ $sub_category_details->category->name}}
								      		@else
								      		{{ tr('category_not_available')}}
								      		@endif
								      	</td>
								      	
								      	<td>{{ Setting::get('currency') }} {{ $sub_category_details->price}}</td>

								      	<td>
								      		@if( $sub_category_details->status == COMMON_APPROVED)
								      			<span class="label label-success">{{tr('approved')}}</span>
								       		@else
								       			<span class="label label-warning">{{tr('pending')}}</span>
								       		@endif
								       </td>
								      	
							      		<td>
		                                	<img style="height: 30px;" src="{{ $sub_category_details->picture}}">
		                            	</td>
								      	
									    <td>

									    	<div class="dropdown">
											
												<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
													{{tr('action')}}
													<span class="caret"></span>
												</button>

												<ul class="dropdown-menu" aria-labelledby="dropdownMenu">
												
													@if(Setting::get('admin_demo_control'))
														<li>
															<a href="javascript:;" class="btn disabled" style="text-align: left;">	<b>{{tr('edit')}}</b>
															</a>
														</li>
														<li>
															<a href="javascript:;" class="btn disabled" style="text-align: left">
									                  			<b>{{tr('delete')}}</b>
									                  		</a>
														</li>
													@else
														<li>
															<a href="{{route('admin.sub_categories.edit' , ['sub_category_id' =>  $sub_category_details->id] )}}"><b>{{tr('edit')}}</b></a>
														</li>
														<li>
															<a 
															onclick="return confirm(&quot;{{ tr('admin_sub_category_delete_confirmation' , $sub_category_details->name) }}&quot;)"
															href="{{route('admin.sub_categories.delete' , ['sub_category_id' =>  $sub_category_details->id] )}}"><b>{{tr('delete')}}</b></a>
														</li>
													@endif
																											
													<li class="divider" role="presentation"></li>

								                  	@if( $sub_category_details->status == COMMON_APPROVED)
								                  		<li>
								                  			<a 
								                  			onclick="return confirm(&quot;{{$sub_category_details->name}} - {{tr('sub_category_decline_confirmation')}}&quot;);"
								                  			href="{{route('admin.sub_categories.status' , ['sub_category_id' =>  $sub_category_details->id] )}}">
								                  				<b>{{tr('decline')}}</b>
								                  			</a>
								                  		</li>
								                  	@else
								                  		<li>
								                  			<a href="{{route('admin.sub_categories.status' ,['sub_category_id' =>  $sub_category_details->id] )}}">
								                  				<b>{{tr('approve')}}</b>
								                  			</a>
								                  		</li>
								                  	@endif

													<li class="divider" role="presentation"></li>

												</ul>

											</div>

									    </td>

								    </tr>

								@endforeach
							
							</tbody>
					
						</table>
					
						<div align="right">{{$sub_category->links()}}</div>
					
					</div>

				@else
					<h3 class="no-result">{{tr('no_sub_category_found')}}</h3>
				@endif
			
            </div>

      	</div>

    </div>
    
</div>

@endsection
