

<form class="" action="{{ Setting::get('admin_demo_control') == YES ? '#' : route('admin.users.save') }}" method="POST" enctype="multipart/form-data" role="form">

    <div class="box-body">

        <div class="row">

            <div class="col-md-6">

                <input type="hidden" name="user_id" value="{{ $user_details->id }}">

                @if(!$user_details->id)

                    <input type="hidden" name="login_by" value="manual">

                    <input type="hidden" name="device_type" value="web">

                @endif

                <div class="form-group">

                    <label for="username">{{ tr('username') }} *</label>

                    <input type="text" required name="name" value="{{ old('name') ?: $user_details->name }}" class="form-control" id="username" placeholder="{{ tr('username') }}" onkeydown="return alphaOnly(event);" autofocus>   

                </div>

                <div class="form-group">

                    <label for="email">{{ tr('email') }} *</label>
                    <input type="email" required class="form-control" value="{{ old('email') ?: $user_details->email }}" id="email" name="email" placeholder="{{ tr('email') }}">
        
                </div>

                <div class="form-group">

                    <label for="description">{{ tr('description') }}</label>

                    <textarea rows="5" class="form-control" name="description" id="description" placeholder="{{tr('description')}}">{{ old('description') ?: $user_details->description }}</textarea>                        
                </div>

            </div>

            <div class="col-md-6">

                <div class="form-group">

                    <label for="mobile">{{ tr('mobile') }} *</label>

                    <input type="number" onkeypress="return isNumber(event)" minlength="4" maxlength="16" pattern="[0-9]{4,16}" required name="mobile" value="{{ old('mobile') ?: $user_details->mobile }}" class="form-control" id="mobile" placeholder="{{ tr('mobile') }}">

                </div>

                @if(!$user_details->id)
                
                    <div class="form-group">
                        <label for="password" class="">{{tr('password')}} *</label>

                        <input type="password" minlength="6" required name="password" class="form-control" id="password" placeholder="{{tr('password')}}" accept="image/image/jpeg">
                    </div>

                    <div class="form-group">
                        
                        <label for="confirm-password" class="">{{tr('confirm_password')}} *</label>

                        <input type="password" minlength="6" required name="password_confirmation" class="form-control" id="confirm-password" placeholder="{{tr('confirm_password')}}">
                    </div>

                @endif

                <div class="form-group">

                    <label for="picture">{{ tr('picture') }}</label>
                    
                    <input type="file" name="picture" class="form-control" id="picture" placeholder="{{ tr('picture') }}" onchange="loadFile(this)" accept="image/*">
        
                </div>               

            </div>

        </div>

    </div>

    <div class="box-footer">

        <button type="reset" class="btn btn-danger">{{tr('reset')}}</button>
        @if(Setting::get('admin_demo_control'))
        <button type="button" class="btn btn-success pull-right" disabled>{{tr('submit')}}</button>
        @else
        <button type="submit" class="btn btn-success pull-right">{{tr('submit')}}</button>
        @endif

    </div>

</form>