@extends('layouts.admin')

@section('title', tr('fav_providers'))

@section('content-header')

{{ tr('fav_providers') }} 

@if(count($user_details) > 0)

- <a href="{{ route('admin.users.view' , ['user_id' => $user_details->id]) }}">{{ $user_details->name }}</a>

@endif

@endsection

@section('breadcrumb')

    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>

    @if(count($user_details) > 0)

	    <li> <a href="{{ route('admin.users.index') }}"><i class="fa fa-user"></i> {{ tr('users') }}</a></li>

	    <li>
	    	<a href="{{ route('admin.users.view' , ['user_id' => $user_details->id]) }}">
	    		<i class="fa fa-dashboard"></i>
	    		{{ tr('view_user') }}
	    	</a>
	    </li>

    @else

		<li> <a href="{{ route('admin.requests.bidding') }}"><i class="fa fa-diamond"></i> {{ tr('requests') }}</a></li>

    @endif

    <li class="active"><i class="fa fa-star"></i> {{ tr('fav_providers') }}</li>

@endsection

@section('content')

	@include('notification.notify')

	<div class="row">
		
        <div class="col-xs-12">

        	<div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
                
	                <b class="text-uppercase">{{ tr('fav_providers') }}</b>

	                @if(count($user_details) > 0)
	                
	                <a href="{{ route('admin.users.index') }}" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-eye"></i> {{ tr('view_users') }}</b>
	                </a>

	                @endif
            	</div>
            
	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      	<th>{{ tr('id') }}</th>
						      	<th>{{ tr('provider') }}</th>
						      	<th>{{ tr('email') }}</th>
						      	<th>{{ tr('mobile') }}</th>
						      	<th>{{ tr('request') }}</th>
						      	<th>{{ tr('date') }}</th>
						      	<th>{{ tr('action') }}</th>
						    </tr>
						</thead>

						<tbody>

							@foreach($fav_providers as $i => $fav_provider_details)
								
							    <tr>

							      	<td>{{ showEntries($_GET,$i + 1) }}</td>
							      	
									<td>
										<a href="{{ route('admin.providers.view' , ['provider_id' =>  $fav_provider_details->provider_id]) }}" target="_blank" class="">
											{{ $fav_provider_details->provider_name }}
										</a>
									</td>

									<td>{{ $fav_provider_details->provider_email }}</td>

									<td>{{ $fav_provider_details->provider_mobile }}</td>

									<td>
										<a href="{{ route('admin.requests.view' , ['request_unique_id' =>  $fav_provider_details->request_unique_id] ) }}" target="_blank" class="">
											{{ $fav_provider_details->request_name }}
										</a>
									</td>

									<td>{{ $fav_provider_details->created_at }}</td>

									<td>
										<a href="{{ route('admin.users.fav_providers.remove' , ['user_fav_provider_id' => $fav_provider_details->user_fav_provider_id] ) }}" class="btn btn-danger" onclick="return confirm(&quot;{{ tr('user_fav_provider_remove_confirmation') }}&quot; );">
											{{ tr('remove') }}
										</a>
									</td>

							    </tr>

							@endforeach
							
						</tbody>
					
					</table>
	            
	            </div>
	            
         	</div>

        </div>

    </div>

@endsection
