@extends('layouts.admin')

@section('title', tr('view_history'))

@section('content-header')
{{ tr('view_history')  }} -  {{ $user_details->name }}
@endsection

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li><a href="{{ route('admin.users.index') }}"><i class="fa fa-user"></i> {{ tr('users') }}</a></li>
    <li class="active"> {{ tr('view_history') }}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">
	
        <div class="col-xs-12">

	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">

	                <b>{{ tr('history') }}</b>

	                <a href="{{ route('admin.users.index') }}" style="float:right" class="btn btn-warning"><b><i class="fa fa-eye"></i> {{ tr('view_users') }}</b></a>

	            </div>

	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>
						    <tr>
						      	<th>{{ tr('id') }}</th>
						      	<th>{{ tr('title') }}</th>
						      	<th>{{ tr('provider') }}</th>
						      	<th>{{ tr('job_type') }}</th>
						      	<th>{{ tr('request_date') }}</th>
						      	<th>{{ tr('price_per_hour') }}</th>
                                <th>{{ tr('payment_mode') }}</th>						      	
						      	<th>{{ tr('total') }}</th>
						      	<th>{{ tr('action') }}</th>
						    </tr>
						</thead>

						<tbody>

							@foreach($history as $i => $history_details)

							    <tr>
							      	<td>{{ showEntries($_GET,$i + 1) }}</td>

                                    <td>
                                    	<a href="{{ route('admin.requests.view' ,['request_unique_id' =>  $history_details->unique_id] ) }}"> {{ $history_details->name  }}</a>
                                    </td>

							      	<td>@if($history_details->provider) <a href="{{ route('admin.providers.view' , ['provider_id' => $history_details->provider_id]) }}">{{ $history_details->provider->name }}</a> @endif
							      	</td>

							      	<td>{{ job_type($history_details->job_type) }}</td>

							      	<td>{{ common_date($history_details->request_date , Auth::guard('admin')->user()->timezone) }}</td>

							      	<td>
							      		{{ $history_details->currency }} {{ $history_details->price_per_hour }}{{ $history_details->price_per_symbol }}
							      	</td>

							      	<td>{{ $history_details->payment_mode }}</td>

							      	<td>
							      		{{ $history_details->currency }} {{ $history_details->total }}
							      	</td>

								    <td>
	        							<a class="btn btn-success" href="{{ route('admin.requests.view' , ['request_unique_id' => $history_details->unique_id] ) }}"><i class="fa fa-eye"></i> {{ tr('view') }}</a>
								    </td>

							    </tr>					

							@endforeach

						</tbody>
					
					</table>

					<div align="right">{{ $history->appends(['user_id' => $user_details->id])->links() }}</div>
					
	            </div>

          	</div>

        </div>

    </div>

@endsection


