@extends('layouts.admin')

@section('title', tr('users'))

@section('content-header', tr('users'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li class="active"><i class="fa fa-user"></i> {{ tr('users') }}</li>
@endsection

@section('content')

	@include('notification.notify')

	<div class="row">
		
        <div class="col-xs-12">

	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
                
	                <b>{{ tr('users') }}</b>

	                
	                <a href="{{ route('admin.users.create') }}" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-plus"></i> {{ tr('add_user') }}</b>
	                </a>

	                <!-- EXPORT OPTION START -->

					@if(count($users) > 0 )
	                
		                <ul class="admin-action btn btn-danger pull-right" style="margin-right: 20px">
		                 	
							<li class="dropdown">
				                <a class="dropdown-toggle text-white" data-toggle="dropdown" href="#">
				                  	<b>
				                  		{{ tr('export') }}
				                  		<span class="caret"></span>
				                  	</b>
				                </a>
				                <ul class="dropdown-menu">
				                  	<li role="presentation">
				                  		<a role="menuitem" tabindex="-1" href="{{ route('admin.users.export' , ['format' => 'xlsx']) }}">
				                  			<span class="text-red"><b>{{ tr('excel_sheet') }}</b></span>
				                  		</a>
				                  	</li>

				                  	<li role="presentation">
				                  		<a role="menuitem" tabindex="-1" href="{{ route('admin.users.export' , ['format' => 'csv']) }}">
				                  			<span class="text-blue"><b>{{ tr('csv') }}</b></span>
				                  		</a>
				                  	</li>
				                </ul>
							</li>
						</ul>

					@endif

		            <!-- EXPORT OPTION END -->
	           
            	</div>
            
	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>

						    <tr>
						      	<th>{{ tr('id') }}</th>
						      	<th>{{ tr('username') }}</th>
						      	<th>{{ tr('email') }}</th>
						      	<th>{{ tr('mobile') }}</th>
						      	<th>{{ tr('total_jobs') }}</th>
						      	@if(Setting::get('email_verify_control'))
							      	<th>{{ tr('email_verification') }}</th>
							    @endif
						      	<th>{{ tr('status') }}</th>
						      	<th>{{ tr('action') }}</th>
						    </tr>

						</thead>

						<tbody>

							@if(count($users) > 0 )

								@foreach($users as $i => $user_details)

								    <tr>
								      	<td>{{ showEntries($_GET,$i + 1) }}</td>

								      	<td>
								      		<a href="{{ route('admin.users.view' , ['user_id' => $user_details->id ] ) }}"> 
								      			{{ $user_details->name }}

												@if($user_details->status == USER_APPROVED)
								      				<span class="text-green pull-right"><i class="fa fa-check-circle"></i></span>

								      			@else
								      				<span class="text-red pull-right"><i class="fa fa-times"></i></span>

								      			@endif

								      		</a>

								      	</td>

								      	<td>{{ $user_details->email }}</td>

								      	<td>{{ $user_details->mobile }}</td>

								      	<td><a href="{{ route('admin.users.history', ['user_id' => $user_details->id ] ) }}">{{ $user_details->userRequests ? $user_details->userRequests->count() : "0" }}</a></td>

										@if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON)

									      	<td>

										      	@if($user_details->is_verified == USER_EMAIL_NOT_VERIFIED)

										      		<a href="{{ route('admin.users.verify' , [ 'user_id' => $user_details->id] ) }}" 
										      		class="btn btn-xs btn-success" onclick="return confirm(&quot;{{  $user_details->name  }} - {{ tr('user_email_confirmation') }}&quot;);">{{ tr('verify') }}
										      		</a>

										      	@else

										      		<span>{{ tr('verified') }}</span>

										      	@endif
									      	
									    	</td>

									    @endif

								       	<td>
								      		@if($user_details->status == USER_APPROVED)
								      			<span class="label label-success">{{ tr('approved') }}</span>
								       		@else
								       			<span class="label label-warning">{{ tr('pending') }}</span>
								       		@endif
								       	</td>
								      	
										<td>
											
											<div class="dropdown @if($i < 2) dropdown @else dropup @endif">
												
												<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">	
													{{ tr('action') }}<span class="caret"></span>
												</button>

												<ul class="dropdown-menu" aria-labelledby="dropdownMenu">
													<li>
														<a href="{{ route('admin.users.view' , [ 'user_id' => $user_details->id ] ) }}">		
															<b>{{ tr('view') }}</b>
														</a>
													</li>
													
													@if(Setting::get('admin_demo_control'))

														<li>
															<a href="javascript:;" class="btn disabled" style="text-align: left;"><b>{{ tr('edit') }}</b></a>
														</li>

														<li>
															<a href="javascript:;" class="btn disabled" style="text-align: left">
									                  			<b>{{ tr('delete') }}</b>
									                  		</a>
														</li>

													@else

														<li>
															<a href="{{  route('admin.users.edit' , [ 'user_id' => $user_details->id ] )  }}"><b>{{ tr('edit') }}</b>
															</a>
														</li>

														<li>
															<a  onclick="return confirm(&quot;{{ tr('admin_user_delete_confirmation' , $user_details->name) }}&quot;);" href="{{  route('admin.users.delete', [ 'user_id' => $user_details->id ] ) }}">
								                  				<b>{{ tr('delete') }}</b>
								                  			</a>
														</li>

													@endif
												
													<li role="separator" class="divider"></li>

								      				@if($user_details->status == USER_APPROVED)
								                  	
								                  		<li>
								                  			<a href="{{ route('admin.users.status' , [ 'user_id' => $user_details->id ] ) }}" onclick="return confirm(&quot;{{ $user_details->name }} - {{ tr('user_decline_confirmation') }}&quot;);"><b>{{ tr('decline') }}</b></a>
								                  		</li>

								                  	@else

								                  		<li>
								                  			<a href="{{ route('admin.users.status' , [ 'user_id' => $user_details->id ] ) }}"><b>{{ tr('approve') }}</b></a>
								                  		</li>

								                  	@endif

													<li class="divider" role="presentation"></li>

													<li>
									              		<a href="{{ route('admin.users.history', ['user_id' => $user_details->id ] ) }}">
									              			<b>{{ tr('view_history') }}</b>
									              		</a>
									              	</li>
									              	
									              	<li>
									              		<a href="{{ route('admin.users.fav_providers', [ 'user_id' => $user_details->id ] ) }}">
									              			<b>{{ tr('fav_providers') }}</b>
									              		</a>
									              	</li>

												</ul>
											</div>
					
										</td>

								    </tr>
								@endforeach

							@else

								<tr>{{  tr('user_not_found')  }}</tr>

							@endif

						</tbody>
					
					</table>

					<div align="right">{{ $users->links() }}</div>
	            
	            </div>
         	
         	</div>

        </div>
        
    </div>

@endsection
