@extends('layouts.admin')

@section('title', tr('view_user'))

@section('content-header', tr('view_user'))

@section('breadcrumb')
    <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i>{{ tr('home') }}</a></li>
    <li><a href="{{ route('admin.users.index') }}"><i class="fa fa-user"></i> {{ tr('users') }}</a></li>
    <li class="active"> {{ tr('view_user') }}</li>
@endsection

@section('content')

	<style type="text/css">
		.timeline::before {
		    content: '';
		    position: absolute;
		    top: 0;
		    bottom: 0;
		    width: 0;
		    background: #fff;
		    left: 0px;
		    margin: 0;
		    border-radius: 0px;
		}
	</style>

	<div class="row">

		<div class="col-md-9 col-md-offset-1">

		@include('notification.notify')

    		<div class="box box-widget widget-user-2">

            	<div class="widget-user-header bg-primary">

              		<div class="widget-user-image">

                		<img class="img-circle" src="@if($user_details->picture) {{ $user_details->picture }} @else {{ asset('admin-css/dist/img/avatar.png') }} @endif" alt="User Avatar">

              		</div>

              		<h3 class="widget-user-username">{{ $user_details->name }} </h3>

      				<h5 class="widget-user-desc">{{ tr('user') }}</h5>

            	</div>

            	<div class="box-footer no-padding">

            		<div class="col-md-7">
            		
	              		<ul class="nav nav-stacked">

			                <li><a>{{ tr('unique_id') }} <b><span class="pull-right">{{ $user_details->unique_id }}</span></b></a></li>

			                <li><a>{{ tr('username') }} <b><span class="pull-right">{{ $user_details->name }}</span></b></a></li>

			                <li><a >{{ tr('email') }} <b><span class="pull-right">{{ $user_details->email }}</span></b></a></li>

			                <li><a>{{ tr('mobile') }} <b><span class="pull-right">{{ $user_details->mobile }}</span></b></a></li>
			               
			                <li>
			                	<a>{{ tr('is_verified') }} 
				                @if($user_details->is_verified == USER_EMAIL_VERIFIED)
				                	<b><span class="label label-success pull-right">{{ tr('yes') }}</span></b>
				            	@else 			                		
			                		{{ tr('verified') }}
			                		<b><span class="label label-warning pull-right">{{ tr('no') }}</span></b>
								@endif 
								</a>
							</li>
							
							<li>
								<a>
								@if($user_details->status == USER_APPROVED)
			                		{{ tr('status') }}
				                	<span class="label label-success pull-right">{{ tr('approved') }}</span>
				            	@else 
			                		{{ tr('status') }}
			                		<span class="label label-warning pull-right">{{ tr('pending') }}</span>
								@endif
								</a>
							</li>

			                <li>
			                	<a>{{ tr('joined') }} 
			                		<b>
			                			<span class="pull-right">
			                				{{ common_date($user_details->created_at , Auth::guard('admin')->user()->timezone) }}
			                			</span>
			                		</b>
			                	</a>
			                </li>

			                <li>
			                	<a>{{ tr('updated') }} 
			                		<b>
			                			<span class="pull-right">
			                				{{ common_date($user_details->updated_at , Auth::guard('admin')->user()->timezone) }}
			                			</span>
			                		</b>
			                	</a>
			                </li>

	              		</ul>

              		</div>

              		<div class="col-md-5">

              			<ul class="nav nav-stacked">

			                <li><a>{{ tr('payment_mode') }} <span class="pull-right text-uppercase"><b>{{ $user_details->payment_mode }}</span></b></a></li>

			                <li><a>{{ tr('device_type') }} <span class="pull-right text-uppercase"><b>{{ $user_details->device_type }}</span></b></a></li>

			                <li><a>{{ tr('login_by') }} <span class="pull-right text-uppercase"><b>{{ $user_details->login_by }}</span></b></a></li>

			                <li><a>{{ tr('login_status') }} <span class="pull-right text-uppercase"><b>{{ $user_details->login_status }}</span></b></a></li>

			                <li><a>{{ tr('register_type') }} <span class="pull-right text-uppercase"><b>{{ $user_details->register_type }}</span></b></a></li>

			                <li><a>{{ tr('timezone') }} <span class="pull-right text-uppercase"><b>{{ $user_details->timezone }}</span></b></a></li>

	              		</ul>

              		</div>

              		<div class="clearfix"></div>

              		<div class="col-md-7">

              			<ul class="nav nav-stacked">

			                <li>
			                	<a>{{ tr('user_email_notification') }} 
			                		 
		                			@if($user_details->email_notification_status == ON)			                		
		                				<b><span class="label label-success pull-right">{{ tr('on') }}</span></b>

		                			@else

				                		<b><span class="label label-danger pull-right">{{ tr('off') }}</span></b>
		                			@endif
			                	</a>
			                </li>

			                <li>
			                	<a>{{ tr('user_push_notification') }} 

			                		@if($user_details->push_notification_status == ON)
	                			
		                				<b><span class="label label-success pull-right">{{ tr('on') }}</span></b>

		                			@else
		                				
		                				<b><span class="label label-danger pull-right">{{ tr('on') }}</span></b>

		                			@endif
			                	</a>
			                </li>

			                <li>
			                	<a>
			                		<b>{{ tr('userdescription') }} : </b> <p class="text-justify">{{$user_details->description}}</p>
			                	</a>
			                </li>

	              		</ul>

              		</div>

              		<!-- Totally job request status information part 
              		 Totall number of request , cancelled request , completed request -->

              		<div class="col-md-5">

              			<ul class="nav nav-stacked">

              				<li>
			                	<div style="padding: 10px 20px"><b>{{ tr('job_info') }}</b></div>
			                </li>

			                <li>
			                	<a>{{ tr('total') }} <span class="pull-right">{{ $user_details->userRequests()->count() }}</span></a>
			                </li>

			                <li>
			                	<a>{{ tr('completed_jobs') }} <span class="pull-right">{{ $user_details->userRequests()->whereIn('requests.status',[REQUEST_COMPLETED,REQUEST_RATING])->count() }}</span></a>
			                </li>
			                
			                <li>
			                	<a>{{ tr('cancelled_jobs') }} <span class="pull-right">{{ $user_details->userRequests()->whereIn('requests.status',[REQUEST_CANCELLED])->count() }}</span></a>
			                </li>

	              		</ul>


						@if(count($users_referral_details) > 0 )
						 <!-- @todo Wallet modeule to be done hence hidden referral_settings -->

						<ul class="nav nav-stacked" style="display: none">

              				<li>
			                	<div style="padding: 10px 20px"><b>{{ tr('referral_details') }}</b></div>
			                </li>

						
							<li>
			            		<a>{{ tr('referral_code') }}<span class="pull-right">
			            		 {{ $users_referral_details->referral_code }} </span></a>
			            	</li>	

			                <li>
			            		<a>{{ tr('referral_earnings') }}<span class="pull-right">
			            		{{ Setting::get('currency') }} {{ $users_referral_details->total_referrals_earnings }} </span></a>
			            	</li>
			            	
			            	<li>
			            		<a href="{{ route('admin.users.referral.index',['user_id' => $users_referral_details->user_id, 'user_referrer_id' => $users_referral_details->id ])}}">{{ tr('referral_count') }}
			            		
			            		<span class="pull-right" class="text-info"> {{ $users_referral_details->total_referrals }} </span></a> 

			            		
			            	</li>
		            		</ul>
		            	@endif

              		</div>

            	</div>

            	<div class="box-footer label-default">

            		@if(Setting::get('admin_demo_control'))

						<a href="javascript:;" class="btn btn-warning  disabled  text-center"><b>{{ tr('edit') }}</b></a>

						<a href="javascript:;" class="btn btn-danger disabled text-center"><b>{{ tr('delete') }}</b></a>

					@else

						<a href="{{ route('admin.users.edit' , ['user_id' => $user_details->id] ) }}" class="btn btn-warning  text-center"><b>{{ tr('edit') }}</b></a>

						<a class="btn btn-danger text-center" onclick="return confirm(&quot;{{ tr('admin_user_delete_confirmation' , $user_details->name) }}&quot;);"  href="{{ route('admin.users.delete', ['user_id' => $user_details->id] ) }}">
						    <b>{{ tr('delete') }}</b>
						</a>

					@endif	

					@if($user_details->status == USER_APPROVED)
							
              			<a href="{{ route('admin.users.status' , [ 'user_id' => $user_details->id ] ) }}" onclick="return confirm(&quot;{{ $user_details->name }} - {{ tr('user_decline_confirmation') }}&quot;);" class="btn btn-danger text-center"><b>{{ tr('decline') }}</b></a>
             
                  	@else

              			<a href="{{ route('admin.users.status' , [ 'user_id' => $user_details->id ] ) }}" class="btn btn-success text-center"><b>{{ tr('approve') }}</b></a>
                  		
                  	@endif

					<a href="{{ route('admin.users.history', ['user_id' => $user_details->id] ) }}" class="btn btn-info  pull-right"><b>{{ tr('view_history') }}</b></a>

					<a href="{{ route('admin.users.fav_providers', ['user_id' => $user_details->id] ) }}" class="btn btn-success  text-center"><b>{{ tr('fav_providers') }}</b></a>


					
            	</div>
          	
          	</div>

		</div>

    </div>

@endsection


