<!DOCTYPE html>
<html>

<head>
    <title>{{$title}}</title>    
    <meta name="robots" content="noindex">

</head>
<style type="text/css">

    table{
        font-family: arial, sans-serif;
        border-collapse: collapse;
    }

    .first_row_design{
        background-color: #187d7d;
        color: #ffffff;
    }

    .row_col_design{
        background-color: #cccccc;
    }

    th{
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;
        font-weight: bold;

    }

    td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;

    }
    
</style>

<body>

    <table>

        <!-- HEADER START  -->

        <tr class="first_row_design">

            <th>{{tr('s_no')}}</th>
            <th>{{tr('request')}}</th>
            <th>{{tr('payment_id')}}</th>
            <th>{{tr('username')}}</th>
            <th>{{tr('payment_mode')}}</th>
            <th>{{tr('admin_commission')}}</th>
            <th>{{tr('provider_amount')}}</th>
            <th>{{tr('total')}}</th>
            <th>{{tr('status')}}</th>
            <th >{{tr('created')}}</th>
            <th >{{tr('updated')}}</th>
            
        </tr>

        <!--- HEADER END  -->

        @foreach($data as $i => $payment_details)
           
            <tr @if($i % 2 == 0) class="row_col_design" @endif >

                <td>{{$i+1}}</td>

                <td>{{$payment_details->requests ? $payment_details->requests->name : "-"}}</td>
                
                <td>{{$payment_details->payment_id}}</td>

                <td>{{$payment_details->user ? $payment_details->user->name : "-"}}</td>

                <td>{{$payment_details->payment_mode}}</td>

                <td>@if($payment_details->requests) {{$payment_details->requests->currency}}{{$payment_details->admin_amount}} @endif</td>

                <td>@if($payment_details->requests) {{$payment_details->requests->currency}}{{$payment_details->provider_amount}} @endif</td>

                <td>@if($payment_details->requests) {{$payment_details->requests->currency}}{{$payment_details->total}} @endif</td>

                <td>
                    @if($payment_details->status) 
                        <span style="color: green;"><b>{{tr('paid')}}</b></span>
                    @else
                        <span style="color: red"><b>{{tr('not_paid')}}</b></span>

                    @endif
                </td>
                <td>{{convertTimeToUSERzone($payment_details->created_at, Auth::guard('admin')->user()->timezone, 'd-m-Y H:i a')}}</td>

                <td>{{convertTimeToUSERzone($payment_details->updated_at, Auth::guard('admin')->user()->timezone, 'd-m-Y H:i a')}}</td>
            </tr>

        @endforeach
    </table>

</body>

</html>