<!DOCTYPE html>
<html>

<head>
    <title>{{$title}}</title>
    <meta name="robots" content="noindex">
</head>
<style type="text/css">

    table{
        font-family: arial, sans-serif;
        border-collapse: collapse;
    }

    .first_row_design{
        background-color: #187d7d;
        color: #ffffff;
    }

    .row_col_design{
        background-color: #cccccc;
    }

    th{
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;
        font-weight: bold;

    }

    td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;

    }
    
</style>

<body>

    <table>

        <!-- HEADER START  -->

        <tr class="first_row_design">

            <th>{{tr('s_no')}}</th>

            <th >{{tr('username')}}</th>

            <th>{{tr('email')}}</th>

            <th>{{tr('mobile')}}</th>

            <th>{{tr('provider_payout')}}</th>

            @if(Setting::get('email_verify_control'))
                <th>{{tr('email_verification')}}</th>
            @endif

            @if(Setting::get('redeem_control'))
                <th>{{tr('redeems')}}</th>
            @endif

            <th >{{tr('picture')}}</th>

            <th >{{tr('description')}}</th>

            <th >{{tr('address')}}</th>

            <th >{{tr('latitude')}}</th>

            <th >{{tr('longitude')}}</th>

            <th >{{tr('payment_mode')}}</th>

            <th >{{tr('device_type')}}</th>

            <th >{{tr('login_by')}}</th>

            <th >{{tr('timezone')}}</th>

            <th >{{tr('status')}}</th>

            <th >{{tr('login_status')}}</th>

            <th >{{tr('register_type')}}</th>

            <th >{{tr('created')}}</th>

            <th >{{tr('updated')}}</th>

        </tr>

        <!--- HEADER END  -->

        @foreach($data as $i => $provider_details)

            <tr @if($i % 2 == 0) class="row_col_design" @endif >

                <td>{{$i+1}}</td>

                <td>{{$provider_details->name}}</td>

                <td>{{$provider_details->email}}</td>

                <td>{{$provider_details->mobile}}</td>

                <td>
                    @if($provider_details->providerPayment)

                        <?php

                            $amount_details = get_provider_amount($provider_details->id);

                            $provider_amount = $amount_details ? $amount_details->provider_amount : "0.00";

                            $payout = $provider_amount - $provider_details->providerPayment->cod; 

                            $payout = $payout - $provider_details->providerPayment->paid_amount; 

                        ?>

                        {{Setting::get('currency')}} {{$payout ? $payout : 0.00}}

                    @else
                        {{Setting::get('currency')}} 0.00
                    @endif                   
                </td>

                @if(Setting::get('email_verify_control'))

                    <td>

                        @if(!$provider_details->is_verified)

                            <span>{{tr('verify')}}</span>

                        @else

                            <span>{{tr('verified')}}</span>

                        @endif
                    
                    </td>

                @endif

                @if(Setting::get('redeem_control'))

                    <td><b>{{Setting::get('currency')}} {{$provider_details->providerPayment ? number_format($provider_details->providerPayment->wallet , 2) : "0.00"}}</b></td>

                @endif

                <td>
                    @if($provider_details->picture) {{$provider_details->picture}} @else {{asset('admin-css/dist/img/avatar.png')}} @endif
                </td>

                <td>{{$provider_details->desription ? $provider_details->desription : "-"}}</td>

                <td>{{$provider_details->address ? $provider_details->address : "-"}}</td>

                <td>{{$provider_details->latitude}}</td>

                <td>{{$provider_details->longitude}}</td>

                <td>{{$provider_details->payment_mode ? $provider_details->payment_mode : " - "}}</td>

                <td>{{$provider_details->device_type ? $provider_details->device_type : "-"}}</td>

                <td>{{$provider_details->login_by ? $provider_details->login_by : "-"}}</td>

                <td>{{$provider_details->timezone ? $provider_details->timezone : " - "}}</td>

                 <td>
                @if($provider_details->is_approved) 

                    {{tr('approved')}}

                @else 

                    {{tr('pending')}}

                @endif
                </td>

                <td>{{$provider_details->login_status}}</td>

                <td>{{$provider_details->register_type ? $provider_details->register_type : "-"}}</td>
 
                <td>{{convertTimeToUSERzone($provider_details->created_at, Auth::guard('admin')->user()->timezone, 'd-m-Y H:i a')}}</td>

                <td>{{convertTimeToUSERzone($provider_details->updated_at, Auth::guard('admin')->user()->timezone, 'd-m-Y H:i a')}}</td>
            </tr>

        @endforeach
    </table>

</body>

</html>