<!DOCTYPE html>
<html>

<head>
    <title>{{$title}}</title>
    <meta name="robots" content="noindex">
</head>
<style type="text/css">

    table{
        font-family: arial, sans-serif;
        border-collapse: collapse;
    }

    .first_row_design{
        background-color: #187d7d;
        color: #ffffff;
    }

    .row_col_design{
        background-color: #cccccc;
    }

    th{
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;
        font-weight: bold;

    }

    td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;

    }
    
</style>

<body>

    <table>

        <!-- HEADER START  -->

        <tr class="first_row_design">

            <th>{{tr('s_no')}}</th>

            <th >{{tr('title')}}</th>

            <th>{{tr('user')}}</th>

            <th>{{tr('provider')}}</th>

            <th>{{tr('request_date')}}</th>

            <th >{{tr('job_type')}}</th>

            <th >{{tr('request_type')}}</th>

            <th >{{tr('category')}}</th>

            <th >{{tr('sub_category')}}</th>

            <th >{{tr('start_time')}}</th>

            <th >{{tr('end_time')}}</th>

            <th >{{tr('assign_time')}}</th>

            <th >{{tr('confirm_time')}}</th>

            <th >{{tr('latitude')}}</th>

            <th >{{tr('logitude')}}</th>

            <th >{{tr('address')}}</th>

            <th >{{tr('price_per_hour')}}</th>

            <th >{{tr('description')}}</th>

            <th >{{tr('note')}}</th>

            <th>{{tr('payment_mode')}}</th>

            <th >{{tr('time_price')}}</th>

            <th >{{tr('user_price')}}</th>

            <th >{{tr('tax_price')}}</th>

            <th>{{tr('total')}}</th>

            <th >{{tr('admin_commission')}}</th>

            <th >{{tr('provider_amount')}}</th>

            <th>{{tr('status')}}</th>

            <th>{{tr('provider_status')}}</th>

            <th>{{tr('after_image')}}</th>

            <th>{{tr('before_image')}}</th>

            <th >{{tr('cancelled_by')}}</th>

            <th >{{tr('created')}}</th>

            <th >{{tr('updated')}}</th>

        </tr>

        <!--- HEADER END  -->

        @foreach($data as $i => $request_details)
           
            <tr @if($i % 2 == 0) class="row_col_design" @endif >

                <td>{{$i+1}}</td>

                <td>{{$request_details->name}}</td>

                <td>{{$request_details->user ? $request_details->user->name : "-"}}</td>

                <td>{{$request_details->provider ? $request_details->provider->name : "-"}}</td>

                <td>@if($request_details->request_date != "0000-00-00 00:00:00") 
                    {{common_date($request_details->request_date , Auth::guard('admin')->user()->timezone) }} 
                    @endif
                </td>

                <td>
                    @if($request_details->job_type == 1)

                        {{job_type($request_details->job_type)}}
                    @else
                        {{job_type($request_details->job_type)}}
                    @endif

                </td>

                <td>{{request_type($request_details->request_type)}}</td>

                <td>{{$request_details->category ? $request_details->category->name : "-"}}</td>

                <td>{{$request_details->subCategory ? $request_details->subCategory->name : "-"}}</td>

                <td>@if($request_details->start_time != "0000-00-00 00:00:00") 
                    {{common_date($request_details->start_time , Auth::guard('admin')->user()->timezone) }}  
                    @else - @endif
                </td>

                <td>@if($request_details->end_time != "0000-00-00 00:00:00") 

                    {{common_date($request_details->end_time , Auth::guard('admin')->user()->timezone) }}  

                    @else - @endif

                </td>

                <td>@if($request_details->assign_time != "0000-00-00 00:00:00") 

                    {{common_date($request_details->assign_time , Auth::guard('admin')->user()->timezone) }}  

                    @else - @endif

                </td>
                <td>@if($request_details->confirm_time != "0000-00-00 00:00:00") 

                    {{common_date($request_details->confirm_time , Auth::guard('admin')->user()->timezone) }}  

                    @else - @endif

                </td>

                <td>{{$request_details->s_latitude ? $request_details->s_latitude : "-"}}</td>

                <td>{{$request_details->s_longitude ? $request_details->s_longitude : "-"}}</td>


                <td>{{$request_details->s_address ? $request_details->s_address : "-"}}</td>

                <td>{{$request_details->currency}} {{$request_details->price_per_hour}}</td>

                <td>{{$request_details->description}}</td>

                <td>{{$request_details->note}}</td>


                <td>{{$request_details->payment_mode}}</td>



                <td>{{$request_details->currency}} {{$request_details->payments ? $request_details->payments->time_price : "0.00"}}</td>

                <td>{{$request_details->currency}} {{$request_details->payments ? $request_details->payments->user_price : "0.00"}}</td>

                <td>{{$request_details->currency}} {{$request_details->payments ? $request_details->payments->tax_price : "0.00"}}</td>

                <td>{{$request_details->currency}} {{$request_details->total}}</td>

                <td>{{$request_details->currency}} {{$request_details->payments ? $request_details->payments->admin_amount : "0.00"}}</td>

                <td>{{$request_details->currency}} {{$request_details->payments ? $request_details->payments->provider_amount : "0.00"}}</td>

                <td>{{request_status($request_details->status)}}</td>

                <td>{{provider_status($request_details->provider_status)}}</td>

                <td>{{$request_details->after_image ? $request_details->after_image : "-"}}</td>

                <td>{{$request_details->before_image ? $request_details->before_image : "-"}}</td>

                <td>{{$request_details->cancelled_by ? $request_details->cancelled_by : "-"}}</td>

                <td>{{convertTimeToUSERzone($request_details->created_at, Auth::guard('admin')->user()->timezone, 'd-m-Y H:i a')}}</td>

                <td>{{convertTimeToUSERzone($request_details->updated_at, Auth::guard('admin')->user()->timezone, 'd-m-Y H:i a')}}</td>
            </tr>

        @endforeach
    </table>

</body>

</html>