<!DOCTYPE html>
<html>

<head>
    <title>{{$title}}</title>
    <meta name="robots" content="noindex">
</head>
<style type="text/css">

    table{
        font-family: arial, sans-serif;
        border-collapse: collapse;
    }

    .first_row_design{
        background-color: #187d7d;
        color: #ffffff;
    }

    .row_col_design{
        background-color: #cccccc;
    }

    th{
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;
        font-weight: bold;

    }

    td {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;

    }
    
</style>

<body>

    <table>

        <!-- HEADER START  -->

        <tr class="first_row_design">

            <th>{{tr('s_no')}}</th>

            <th >{{tr('username')}}</th>

            <th>{{tr('email')}}</th>

            <th>{{tr('mobile')}}</th>

            <th>{{tr('total_jobs')}}</th>

            @if(Setting::get('email_verify_control'))
                <th>{{tr('email_verification')}}</th>
            @endif

            <th >{{tr('picture')}}</th>

            <th >{{tr('description')}}</th>

            <th >{{tr('address')}}</th>

            <th >{{tr('latitude')}}</th>

            <th >{{tr('longitude')}}</th>

            <th >{{tr('payment_mode')}}</th>

            <th >{{tr('device_type')}}</th>

            <th >{{tr('login_by')}}</th>

            <th >{{tr('timezone')}}</th>

            <th >{{tr('status')}}</th>

            <th >{{tr('login_status')}}</th>

            <th >{{tr('register_type')}}</th>

            <th >{{tr('created')}}</th>

            <th >{{tr('updated')}}</th>
        </tr>

        <!--- HEADER END  -->

        @foreach($data as $i => $user_details)

            <tr @if($i % 2 == 0) class="row_col_design" @endif >

                <td>{{$i+1}}</td>

                <td>{{$user_details->name}}</td>

                <td>{{$user_details->email}}</td>

                <td>{{$user_details->mobile}}</td>

                <td>{{$user_details->userRequests ? $user_details->userRequests->count() : "0"}}</td>

                @if(Setting::get('email_verify_control'))

                    <td>

                        @if(!$user_details->is_verified)

                            <span>{{tr('verify')}}</span>

                        @else

                            <span>{{tr('verified')}}</span>

                        @endif
                    
                    </td>

                @endif

                <td>
                    @if($user_details->picture) {{$user_details->picture}} @else {{asset('admin-css/dist/img/avatar.png')}} @endif
                </td>

                <td>{{$user_details->desription ? $user_details->desription : "-"}}</td>

                <td>{{$user_details->address ? $user_details->address : "-"}}</td>

                <td>{{$user_details->latitude}}</td>

                <td>{{$user_details->longitude}}</td>

                <td>{{$user_details->payment_mode ? $user_details->payment_mode : " - "}}</td>

                <td>{{$user_details->device_type ? $user_details->device_type : "-"}}</td>

                <td>{{$user_details->login_by ? $user_details->login_by : "-"}}</td>

                <td>{{$user_details->timezone ? $user_details->timezone : " - "}}</td>

                 <td>
                @if($user_details->status) 

                    {{tr('approved')}}

                @else 

                    {{tr('pending')}}

                @endif
                </td>

                <td>{{$user_details->login_status}}</td>

                <td>{{$user_details->register_type ? $user_details->register_type : "-"}}</td>
 
                <td>{{convertTimeToUSERzone($user_details->created_at, Auth::guard('admin')->user()->timezone, 'd-m-Y H:i a')}}</td>

                <td>{{convertTimeToUSERzone($user_details->updated_at, Auth::guard('admin')->user()->timezone, 'd-m-Y H:i a')}}</td>
            </tr>

        @endforeach
    </table>

</body>

</html>