f<nav class="navbar navbar-default navbar-fixed-top" role="navigation">

	<div class="container">
		<div class="navbar-header">
			 
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
				<span class="sr-only">Toggle navigation</span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
			</button> 

			<a class="navbar-brand" href="{{url('/')}}">
				<div class="bg-img logo" style="background-image: url({{Setting::get('site_logo')}});"></div>

			</a>

		</div>
		
		<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">

			<ul class="nav navbar-nav navbar-right">

				@if(Auth::check())

					<li>
						<a href="{{route('user.profile')}}">{{tr('user')}}</a>
					</li>

				@elseif(Auth::guard('provider')->check())

					<li>
						<a href="{{route('provider.profile')}}">{{tr('provider')}}</a>
					</li>

				@else

					<li>
						<a href="{{route('user.register.form')}}">{{tr('signup')}}</a>
					</li>
					
					<li>
						<a href="{{route('user.login.form')}}">{{tr('login')}}</a>
					</li>

					<li>
						<a class="btn become-tasker-btn" href="{{route('provider.register.form')}}">{{tr('become_a_provider')}}</a>
					</li>

				@endif
				
				@if(Setting::get('admin_language_control') == 0)

					@if(count($languages = getActiveLanguages()) > 1) 
					
						<li class="dropdown">
		                    
					        <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-globe"></i>&nbsp;  <b class="caret"></b></a>
					        <ul class="dropdown-menu">
					        	@foreach($languages as $h => $language)
					          		<li class="{{(\Session::get('locale') == $language->folder_name) ? 'active' : ''}}" ><a href="{{route('user_session_language', $language->folder_name)}}" style="{{(\Session::get('locale') == $language->folder_name) ? 'background-color: #51af33' : ''}}">{{$language->folder_name}}</a></li>
					          	@endforeach
					        </ul>
						     
						</li>

					@endif
				
				@endif
			
			</ul>
			
		</div>
	</div>
</nav>

