<nav class="navbar navbar-default navbar-fixed-top" role="navigation">
	<div class="container">
		<div class="navbar-header">
	
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
				<span class="sr-only">Toggle navigation</span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
			</button> 
			<a class="navbar-brand" href="{{route('provider.dashboard')}}">
				<div class="bg-img logo" style="background-image: url({{Setting::get('site_logo')}});"></div>
			</a>
		</div>
		
		<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">

			<ul class="nav navbar-nav navbar-right">

				@if(Auth::guard('provider')->check())

					@if(Auth::guard('provider')->user()->step == PROVIDER_STEP_COMPLETE)

						<li id="provider_dashboard">
							<a href="{{route('provider.dashboard' , ['dashboard' => 1])}}">{{tr('dashboard')}}</a>
						</li>

						<li id="provider_history">
							<a href="{{route('provider.history')}}">{{tr('history')}}</a>
						</li>

						<li id="provider_account">
							<a href="{{route('provider.profile')}}">{{tr('account')}}</a>
						</li>

						@if(Setting::get('provider_notification_control'))

						<li>

							<?php $notification = get_provider_notifications(); ?>

							<ul class="nav navbar-nav">

						        <li class="dropdown">

						          	<a  id="notify_click" href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false" style="position: relative;"><i class="fa fa-bell notifi-bell"></i> 
						          	<div class="bell_badge"><span class="cnt" style="{{$notification['new_notify'] > 0 ? '' : 'display: none' }}">{{$notification['new_notify']}}</span></div>
						          	</a>

						          	<ul class="dropdown-menu notify-drop">
						            	<div class="notify-drop-title">
							            	<div class="row">
							            		<div class="col-md-12 col-sm-12 col-xs-12 text-uppercase">{{tr('notifications')}} (<b>&nbsp;<span class="cnt">{{$notification['new_notify']}}</span>&nbsp;</b>)</div>
							            		
							            	</div>
						            	</div>
							            <!-- end notify title -->
							            <!-- notify content -->
							            <div class="drop-content">

							            	<span id="append_value" style="font-size: 11px"></span>

							            	@if(count($notification['model']) > 0)

								            	@foreach($notification['model'] as $notify)
								            	
								            	<li>
								            		<a target="_blank" href="{{route('provider.requests.view' , ['request_unique_id' => $notify->unique_id])}}">

								            		<div style="padding: 3px 5px">

									            		<div class="col-md-2 col-sm-2 col-xs-2">

									            		<?php $img = $notify->picture ? $notify->picture : asset('placeholder.png');?>

									            			<div class="incoming-img bg-img" style="background-image:url({{$img}});width: 40px;height: 40px">
									            			</div>
									            		</div>

									            		<div class="col-md-8 col-sm-8 col-xs-8">

									            			<p class="notification_text"> <?= $notify->notification ;?></p>
									            		
											            		<!-- <hr> pd-l0-->

											            	<p>{{$notify->created_at->diffForHumans()}}</p>


									            		</div>

									            		<div class="clearfix"></div>

								            		</div>

								            		<!-- <hr> -->

								            		</a>
								            	</li>

								            	@endforeach

							            	@else

							            		<li><p class="text-center">{{tr('no_notification_found')}}</p></li>

							            	@endif
							            </div>
							            @if(count($notification['model']) > 10)
								            <div class="notify-drop-footer text-center">
								            	<a href="{{route('provider.notification.see_all')}}"><i class="fa fa-eye"></i> {{tr('see_all_notifications')}}</a>
								            </div>
							            @endif
						          	</ul>

						        </li>

					     	</ul>

						</li>

						@endif

						@if(Setting::get('admin_language_control') == 0)

							@if(count($languages = getActiveLanguages()) > 1)

							<li  class="dropdown" id="language">
	                    
						        <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-globe"></i>&nbsp;  <b class="caret"></b></a>
						        <ul class="dropdown-menu">
						        	@foreach($languages as $h => $language)
						          		<li class="{{(\Session::get('locale') == $language->folder_name) ? 'active' : ''}}" ><a href="{{route('user_session_language', $language->folder_name)}}" style="{{(\Session::get('locale') == $language->folder_name) ? 'background-color: #51af33' : ''}}">{{$language->folder_name}}</a></li>
						          	@endforeach
						        </ul>
						     
							</li>

							@endif

						@endif

						<li id="logout">
							<a href="{{route('provider.logout')}}"><i class="fa fa-sign-out"></i></a>
						</li>

					@else 

						<!-- <li>
							<a class="provider-head-disable" href="">{{tr('dashboard')}}</a>
						</li>

						<li>
							<a class="provider-head-disable" href="">{{tr('history')}}</a>
						</li>

						<li>
							<a class="provider-head-disable" href="">{{tr('account')}}</a>
						</li> -->
						<li id="logout">
							<a href="{{route('provider.logout')}}"><i class="fa fa-sign-out"></i></a>
						</li>
					@endif

				@else

					<li>
						<a href="{{route('choose.register')}}">{{tr('signup')}}</a>
					</li>

					<li>
						<a href="{{route('how_it_works')}}">{{tr('how_it_works')}}</a>
					</li>

					<li>
						<a href="{{route('choose.register')}}">{{tr('login')}}</a>
					</li>

					@if(Setting::get('admin_language_control') == 0)
					
					<li  class="dropdown">
                    
				        <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">{{tr('language')}} <b class="caret"></b></a>
				        <ul class="dropdown-menu">
				        	@foreach(getActiveLanguages() as $h => $language)
				          		<li class="{{(\Session::get('locale') == $language->folder_name) ? 'active' : ''}}" ><a href="{{route('user_session_language', $language->folder_name)}}" style="{{(\Session::get('locale') == $language->folder_name) ? 'background-color: #51af33' : ''}}">{{$language->folder_name}}</a></li>
				          	@endforeach
				        </ul>
				     
					</li>

					@endif

				@endif
			
			</ul>
			
		</div>
	</div>
</nav>