@extends('layouts.provider')

@section('after-styles')
<link rel="stylesheet" type="text/css" href="{{asset('common/css/grid-gallery.css')}}">

<style>

	.switch {
		position: relative;
		display: inline-block;
		width: 60px;
		height: 34px;
	}

	.switch input {display:none;}

	.slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #ccc;
		-webkit-transition: .4s;
		transition: .4s;
	}

	.slider:before {
		position: absolute;
		content: "";
		height: 26px;
		width: 26px;
		left: 4px;
		bottom: 4px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
	}

	input:checked + .slider {
		background-color: #51af33;
	}

	input:focus + .slider {
		box-shadow: 0 0 1px #2196F3;
	}

	input:checked + .slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(26px);
	}

	/* Rounded sliders */
	.slider.round {
		border-radius: 34px;
	}

	.slider.round:before {
		border-radius: 50%;
	}

	.block{
        text-align: center;
        vertical-align: middle;
    }
    .circle{
        background: #51af33;
        border-radius: 50%;
        color: white;
        height: 150px;
        font-weight: bold;
        width: 150px;
    }
	.circle span{
		display: table-cell;
		padding-top:40%;
		font-size: 20px;
	}

	.card-button {
		margin-left: 4%;
		margin-top: 3%;

	}
	.redeem-image{
		background-position: center;
		background-size: cover;
		background-repeat: no-repeat;
		height: 200px;
		width: 200px;
		margin: 0 auto;
		display: flex;
		align-items: center;
		justify-content: center;
	}

</style>

@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="dashboard row m-0 p-30">
		
		<div class="container">

		    @if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING)
		    
		        <div class="alert alert-danger text-uppercase">
		            {{tr('provider_waiting_for_admin_approval')}}
		        </div>

		    @endif
			    
			@include('notification.notify')

			<div class="dashboard-right-col col-lg-10 col-md-10 col-sm-12 col-xs-12 col-lg-offset-2 col-md-offset-2">   

				<div class="main">
				    
				    <div class="row">

				        <div class="{{Auth::guard('provider')->user()->subscription_expired ? 'col-12 col-xs-9 col-sm-9 col-md-9 col-lg-9 sec-space3 col-lg-offset-2' : 'col-12 col-xs-12 col-sm-12 col-md-10 col-lg-10 sec-space2'}}">
				            <div class="section-side-spacing section-top-bottom-spacing">
				                <!-- <h3 class="m-0 top text-center">{{tr('billing_info')}}</h3> -->
				                <div class="panel panel-default top1">
				                    <div class="panel-heading theme-heading">
				                        <h4>{{tr('billing_info')}}
				                        <span class="pull-right hidden-xs"><img src="{{asset('img/card-type.png')}}" class="card-img img-responsive"></span></h4>
				                        <div class="clear-both"></div>
				                    </div>
				                    <div class="panel-body">

				                        <form class="login-form" id="payment-form" method="POST" action="{{route('provider.add.card')}}">

				                            <div class="row">

				                                <div class="col-xs-12 col-sm-6 col-md-12">

				                                    <div class="card-wrapper"></div>

				                                </div>

				                                <div class="col-xs-12 col-sm-12 col-md-12">

				                                    <div class="form-group">
				                                    
				                                        <label for="name">{{tr('name')}}</label>

				                                        <div class="input-group">

				                                            <input  type="text" id="name" name="card_name" required class="form-control" placeholder="{{tr('name')}}" /><span class="input-group-addon"><i class="fa fa-user"></i></span>
				                                        </div>
				                                    
				                                    </div>
				                                    
				                                    <div class="form-group">

				                                        <label for="cardNumber">{{tr('card_number')}}</label>

				                                        <div class="input-group">

				                                            <input  type="tel" class="form-control" required name="number" placeholder="{{tr('card_number')}}" autocomplete="cc-number"  autofocus  data-stripe="number" id="number" maxlength="19" onkeyup="card_number_onkey(this.value)" /><span class="input-group-addon"><i class="fa fa-credit-card"></i></span>
				                                        </div>

				                                    
				                                    </div>

				                                    <div class="form-group row">
				                                        
				                                        <div class="col-lg-6 col-md-8 col-xs-12 col-sm-12">

				                                            <label for="cardExpiry">{{tr('expiry_date')}}</label>

				                                            <div class="row">

				                                                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">

				                                                    <input  type="tel"  class="form-control expiry" id="expiry_month"  name="expiry_month" placeholder="MM" autocomplete="cc-exp" required data-stripe="exp-month" maxlength="2" pattern="[0-9]{2,}"/>

				                                                </div>

				                                                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">

				                                                    <input  type="tel"  class="form-control expiry" id="expiry_year"  name="expiry_year" placeholder="YY" autocomplete="cc-exp" required data-stripe="exp-year" maxlength="2" pattern="[0-9]{2,}"/>

				                                                </div>

				                                            </div>

				                                        </div>

				                                        <div class="col-lg-6 col-md-4 col-sm-12 col-xs-12">

				                                            <label for="cardCVC">{{tr('cvv_number')}}</label>

				                                            <input type="text" size="4" id="cvc" data-stripe="cvc" class="form-control" name="cvc" placeholder="{{tr('cvv_number')}}" autocomplete="cc-csc" required maxlength="3" />

				                                        </div>
				                                   

				                                    </div>

				                                </div>

				                            </div>

				                            <div class="text-right">
				                                <a href="" class="btn btn-default">{{tr('cancel')}}</a>
				                                <button type="submit" class="btn btn-primary">{{tr('save')}}</button>
				                            </div>

				                        </form>

				                        <div class="clearfix"></div>

				                        <div class="top1">

				                        @if($cards->data)

				                            @foreach($cards->data->cards as $key => $card)

				                            <div class="media">

				                                <div class="media-left">
				                                    <img src="../img/credit-card.png" class="media-object1">
				                                </div>

				                                <div class="media-body">
				                                    <?php $delete = tr('are_your_sure'); ?>

				                                    @if(!$card->is_default) 
				                                    <p class="m-0 pull-right">

				                                    <a href="{{route('provider.delete.card', ['provider_card_id' => $card->provider_card_id])}}" title="{{tr('delete')}}" onclick="return confirm(&quot;{{$delete}} &quot);" class="black-clr"><i class="fa fa-trash" style="color: black"></i></a>
				                                    </p>

				                                    @endif
				                                    
				                                    <h4 class="media-heading uppercase">xxxx xxxx xxxx {{$card->last_four}}</h4>
				                                    
				                                    @if($card->is_default)
				                                        <p class="captalize m-0"><a class="green" title="{{tr('set_as_default')}}">{{tr('default')}}</a></p>
				                                    @else
				                                        <p class="captalize m-0"><a href="{{route('provider.default.card', ['provider_card_id'=> $card->provider_card_id])}}" class="red" title="{{tr('set_as_default')}}">{{tr('set_as_default')}}</a></p>
				                                    @endif

				                                </div>

				                            </div>

				                            <p class="grey-line"></p>

				                            @endforeach
				                        
				                        @endif

				                        </div>
				                    </div>
				                </div>
				            </div>
				        </div>
				    </div>

				</div>

			</div>

		</div>
	
	</div>

</div>

@endsection

@section('after-scripts')

<script src="https://cdnjs.cloudflare.com/ajax/libs/card/2.3.0/jquery.card.min.js"></script>

<script type="text/javascript" src="{{ asset('js/card.js') }}"></script>

<script>
    new Card({
        form: document.querySelector('form'),
        container: '.card-wrapper',
        formSelectors: {
            // numberInput: 'input#number', // optional — default input[name="number"]
            expiryInput: 'input.expiry', // optional — default input[name="expiry"]
            // cvcInput: 'input#cvc', // optional — default input[name="cvc"]
            nameInput: 'input#name' // optional - defaults input[name="name"]
        },
    });

</script>

<script>

    function card_number_onkey(value) {

        $('#number').html(value.replace(/\W/gi, '').replace(/(.{4})/g, '$1 '));
                
    }

</script>

<script type="text/javascript" src="https://js.stripe.com/v2/"></script>

<script type="text/javascript">

    // This identifies your website in the createToken call below
    Stripe.setPublishableKey('{{Setting::get("stripe_publishable_key")}}');
    
    var stripeResponseHandler = function (status, response) {

        var $form = $('#payment-form');

        console.log(response);

        if (response.error) {
            // Show the errors on the form
            // $form.find('.payment-errors').text(response.error.message);

            toastr.error(response.error.message);

            $form.find('button').prop('disabled', false);

            // alert(response.error.message);

        } else {
            // token contains id, last4, and card type
            var token = response.id;
            
            // Insert the token into the form so it gets submitted to the server
            $form.append($('<input type="hidden" id="stripeToken" name="stripeToken" />').val(token));
             // alert(token);
            // and re-submit

            jQuery($form.get(0)).submit();

        }
    
    };

    $('#payment-form').submit(function (e) {
        
        if ($('#stripeToken').length == 0) {

            var $form = $(this);
            // Disable the submit button to prevent repeated clicks
            $form.find('button').prop('disabled', true);

            console.log($form);

            Stripe.card.createToken($form, stripeResponseHandler);

            // Prevent the form from submitting with the default action
            return false;
        }
    
    });


</script>

@endsection