@extends('layouts.provider')

@section('content')

<div class="content-wrap gray-bg">

	<div class="provider-flow-section p-50">

		<div class="container">

			@if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING)
		    
		        <div class="alert alert-danger text-uppercase">
		            {{tr('provider_waiting_for_admin_approval')}}
		        </div>

		    @endif

			@include('notification.notify')

			<div class="provider-flow-terms">

				<h4>{{tr('set_location')}}</h4>

				<p class="theme-color no-margin">{{tr('address')}} : {{Auth::guard('provider')->user()->address}}</p>

				<div class="row">

					<div class="col-lg-9 col-md-8 col-sm-7 col-xs-12 top">

						<input type="text" style="width:100%" class="form-control" name="my_address" id="my-dest"  placeholder="Search Place" style="margin-bottom:10px;width:65%;float:left;">

					</div>

					<div class="col-lg-3 col-md-4 col-sm-5 col-xs-12 top">
						
						<form action="{{ route('provider.location.save') }}" method="POST" class="form-horizontal row-border">

							<input type="hidden" name="latitude" id="latitude">
							<input type="hidden" name="longitude" id="longitude">
							<input type="hidden" name="address" id="address">

							<span style="display: none;" id="latitude_text"> {{Auth::guard('provider')->user()->latitude}} </span>
							
							<span style="display: none;" id="longitude_text"> {{Auth::guard('provider')->user()->longitude}} </span>
								
							<button type="submit" style="width:100%" class="btn btn-lg btn-success">{{ tr('update_location') }}</button>

						</form>

					</div>

				</div>

				<br>

				<div id="update_location_map"></div>


			</div>

		</div>
	</div>

</div>

@endsection

@section('after-styles')

	<style type="text/css">
	    html, body {
	        height: 100%;
	        margin: 0;
	        padding: 0;
	    }

	    #update_location_map {
	        height: 100%;
	        min-height: 400px; 
	    }
	</style>

@endsection

@section('after-scripts')

	<script>

		var map;

		var center_point = {lat:11.8508117,lng:79.7854668};
		var input = document.getElementById('my-dest');
		var s_latitude = document.getElementById('latitude');
		var s_longitude = document.getElementById('longitude');
		var s_address = document.getElementById('address');
		var latitude_text = document.getElementById("latitude_text");
		var longitude_text = document.getElementById("longitude_text");

		@if(Auth::guard('provider')->user()->latitude != 0)
			center_point = { lat: {{Auth::guard('provider')->user()->latitude}}, lng: {{Auth::guard('provider')->user()->longitude}} };
			latitude_text.innertext = {{Auth::guard('provider')->user()->latitude}};
			longitude_text.innertext = {{Auth::guard('provider')->user()->longitude}};
			s_latitude.value = {{Auth::guard('provider')->user()->latitude}};
			address.value = {{Auth::guard('provider')->user()->longitude}};
		
		@endif

	    function start_map() {

	        map = new google.maps.Map(document.getElementById('update_location_map'), {
	            center: center_point,
	            zoom: 16
	        });
	        var service = new google.maps.places.PlacesService(map);
	        var autocomplete = new google.maps.places.Autocomplete(input);
	        var infowindow = new google.maps.InfoWindow();

	        autocomplete.bindTo('bounds', map);

	        var marker = new google.maps.Marker({
	            map: map,
	            position: center_point,
	            draggable: true,
	            anchorPoint: new google.maps.Point(0, -29)
	        });

	        var infowindow = new google.maps.InfoWindow({
	            content: "You are here",
	        });

	        google.maps.event.addListener(map, 'click', updateMarker);
	        
	        google.maps.event.addListener(marker, 'dragend', updateMarker);

	        function updateMarker(event) {

	            marker.setVisible(true);
	            marker.setPosition(event.latLng);
	            infowindow.open(map, marker);

	            var geocoder = new google.maps.Geocoder();
	            geocoder.geocode({'latLng': event.latLng}, function (results, status) {

	                if (status == google.maps.GeocoderStatus.OK) {
	                    if (results[0]) {
	                        input.value = results[0].formatted_address;
	                    } else {
	                        alert('No Address Found');
	                    }
	                } else {
	                    alert('Geocoder failed due to: ' + status);
	                }
	                
	            });

	            updateForm(event.latLng.lat(), event.latLng.lng());
	        }

	        autocomplete.addListener('place_changed', function(event) {
	            marker.setVisible(false);
	            var place = autocomplete.getPlace();

	            if (place.hasOwnProperty('place_id')) {
	                if (!place.geometry) {
	                    window.alert("Autocomplete's returned place contains no geometry");
	                    return;
	                }
	                updateLocation(place.geometry.location);
	            } else {
	                service.textSearch({
	                    query: place.name
	                }, function(results, status) {
	                    if (status == google.maps.places.PlacesServiceStatus.OK) {
	                        updateLocation(results[0].geometry.location);
	                        input.value = results[0].formatted_address;
	                    }
	                });
	            }
	        });

	        function updateLocation(location) {
	            map.setCenter(location);
	            marker.setPosition(location);
	            marker.setVisible(true);
	            infowindow.open(map, marker);
	            updateForm(location.lat(), location.lng());
	        }

	        function updateForm(lat, lng) {
	            s_latitude.value = lat;
	            s_longitude.value = lng;
	            latitude_text.textContent = lat;
	            longitude_text.textContent = lng;
	            s_address.value = input.value;
	        }

	    }

		setTimeout(function() { start_map(); },2000);

	</script>

<!-- 	<script src="https://maps.googleapis.com/maps/api/js?key={{ envfile('GOOGLE_API_KEY') }}&libraries=places" async defer></script>
 -->
@endsection


