@extends('layouts.provider')

@section('after-styles')
<link rel="stylesheet" type="text/css" href="{{asset('common/css/grid-gallery.css')}}">

<style>

	.switch {
		position: relative;
		display: inline-block;
		width: 60px;
		height: 34px;
	}

	.switch input {display:none;}

	.slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #ccc;
		-webkit-transition: .4s;
		transition: .4s;
	}

	.slider:before {
		position: absolute;
		content: "";
		height: 26px;
		width: 26px;
		left: 4px;
		bottom: 4px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
	}

	input:checked + .slider {
		background-color: #51af33;
	}

	input:focus + .slider {
		box-shadow: 0 0 1px #2196F3;
	}

	input:checked + .slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(26px);
	}

	/* Rounded sliders */
	.slider.round {
		border-radius: 34px;
	}

	.slider.round:before {
		border-radius: 50%;
	}

	.block{
        text-align: center;
        vertical-align: middle;
    }
    .circle{
        background: #51af33;
        border-radius: 50%;
        color: white;
        height: 150px;
        font-weight: bold;
        width: 150px;
    }
	.circle span{
		display: table-cell;
		padding-top:40%;
		font-size: 20px;
	}

	.card-button {
		margin-left: 4%;
		margin-top: 3%;

	}
	.redeem-image{
		background-position: center;
		background-size: cover;
		background-repeat: no-repeat;
		height: 200px;
		width: 200px;
		margin: 0 auto;
		display: flex;
		align-items: center;
		justify-content: center;
	}

</style>

@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="dashboard row m-0 p-30">
		
		<div class="container">

		    @if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING)
		    
		        <div class="alert alert-danger text-uppercase">
		            {{tr('provider_waiting_for_admin_approval')}}
		        </div>

		    @endif			    

			@include('notification.notify')

			@if( Auth::guard('provider')->user()->step == PROVIDER_STEP_COMPLETE)

			    <h3 class="dashboard-main-tit">{{tr('your_account')}}</h3>
			
			@endif
			<!-- Dashboard Left -->
			<div class="dashboard-left-col col-lg-3 col-md-3 col-sm-12 col-xs-12">
			
				<div class="dashboard-left">
					<!-- Nav tabs -->
					
					@include('provider.account.profile-nav')

				</div>

			</div>
			<!-- end of dashboard left -->

			<!-- Dashboard Right -->

			<div class="dashboard-right-col col-lg-9 col-md-9 col-sm-12 col-xs-12">
				
				<div class="dashboard-right tab-content white-bg p-f-30">
					
					<!-- Profile Tab -->

					@include('provider.account.sub_pages.profile')

					<!-- Profile Tab -->

					<!-- document tab -->

					@include('provider.account.sub_pages.document')

					<!-- End of document tab -->
					
					<!-- Billing Tab -->

					@include('provider.account.sub_pages.billing')

					<!-- Billing Tab -->

					@if(Setting::get('redeem_control'))

						@include('provider.account.sub_pages.redeems')

					@endif

					<!-- Change-pwd tab -->
					
					@include('provider.account.sub_pages.change-password')

					<!-- End of Change-pwd tab -->

					<!-- Delete account tab -->
					
					@include('provider.account.sub_pages.delete-account')

					<!-- End of Delete account tab -->
				</div>
				
			</div>
			<!-- End of dashboard right -->
		
		</div>
	
	</div>

</div>

@endsection

@section('after-scripts')

<script type="text/javascript">

	document.getElementById("uploadBtn").onchange = function () {
	    document.getElementById("uploadFile").value = this.value;
	};
	
	document.getElementById("uploadBtn1").onchange = function () {
	    document.getElementById("uploadFile1").value = this.value;
	};

</script>

<script>
	
	function change_availability() {

		var url = "{{route('provider.detect.request')}}";

		var id = "{{Auth::guard('provider')->user()->id}}";
		var token = "{{Auth::guard('provider')->user()->token}}";

		var change_availability = 1;

		$.ajax({
			url : url,
			method : "GET",
			data : {id : id , token : token},
			success : function(result) {

				if(result.success) {
					if(result.data) {
						change_availability = 0; 
					}
				}
			}

		});

		if(change_availability) {

			if($('#change_availability').is(':checked')) {

				$.ajax({url: "{{route('provider.change.state')}}", method: "POST",  data: { status : 1 }, success: function(result){
			    	}
			    });

			} else {
				$.ajax({url: "{{route('provider.change.state')}}", method: "POST",  data: { status : 0 }, success: function(result) {
			    	}
				});
			}
		} else {
			alert('Ongoing request.');
		}

	}

	function check_document_upload() {

	    data = $('#documents-data');

	    for (var i = 0; i < $("#documents-data").get(0).files.length; ++i) {

	        var documents_data=$("#documents-data").get(0).files[i].name;

	        if(documents_data) { 

	            var file_size=$("#documents-data").get(0).files[i].size;

	            console.log(file_size);

	            if(file_size < 53810750) {

	                var ext = documents_data.split('.').pop().toLowerCase(); 

	                console.log(ext);

	                if($.inArray(ext,['jpg','jpeg','gif' , 'pdf' , 'png'])===-1) {

	                    $('#documents-data-error').text("Invalid file extension : accepted formats : .png , .jpeg , .jpg, .gif , .pdf")

	                    data.replaceWith(data.val('').clone(true));

	                    return false;

	                } else {
	                    $('#documents-data-error').text("");
	                }

	            } else {

	                $('#documents-data-error').text("The upload file exists the max file size limit: Max - 50MB");

	                data.replaceWith(data.val('').clone(true));

	                return false;
	            
	            } 
	        }
	    
	    }

	}

</script>

<script type="text/javascript" src="{{asset('common/js/grid-gallery.min.js')}}"></script>

@endsection