@extends('layouts.provider')

@section('after-styles')
<link rel="stylesheet" type="text/css" href="{{asset('common/css/grid-gallery.css')}}">
@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="provider-flow-section p-50">

		<div class="container">
			
			@include('notification.notify')

			<div class="provider-flow-terms">

				@if(isset($register_flow))

					<h3 class="provider-flow-main-tit">{{tr('services')}}</h3>
				@else

					<h3 class="provider-flow-main-tit">{{tr('become_a_provider')}}</h3>

				@endif

				<div class="provider-terms-content white-bg">

					<!-- Provider-terms-block -->
					<div class="provider-terms-block border-bot">
						<h4 class="provider-flow-sub-tit">{{tr('provider_update_services')}}</h4>
					</div>
					<!-- End of provider-terms-block -->

					<form action="{{route('provider.services.save')}}" method="POST">

						<!-- Don't delete this, its used identify the whether this register flow or normal service update -->

						<input type="hidden" name="register_flow" @if(isset($register_flow)) value="" @else value="1" @endif>

						<!-- Pro Category Section -->
						<div class="panel-group pro-category-sec p-f-30" id="accordion" role="tablist" aria-multiselectable="true">

						@if($categories = getCategories())

							<?php $selected_ids = selected_service_categories(Auth::guard('provider')->user()->id);?>

							@foreach($categories as $c => $category)

								<?php 

								$category = get_category_details($category->category_id);

								$has_subscriptions = is_category_subscription($category->id);
								
								$is_subscribed = NO;
								
								if($has_subscriptions){

									$is_subscribed = check_provider_subscribed_category( \Auth::guard('provider')->user()->id, $category->id);
								}

								?>

								@if(count($sub_categories = $category->subCategory))

									<!-- Panel block -->
							        <div class="panel panel-default m-b-10">
							           
							            <div class="panel-heading" role="tab" id="headingOne">
							                
							                <h4 class="panel-title category-tit">
							                    <a role="button" data-toggle="collapse" data-parent="#accordion" href="#category-{{$category->id}}" aria-expanded="true" aria-controls="category-1">
							                        <i class="more-less ion-chevron-down"></i>
							                        
							                        @if(in_array($category->id, $selected_ids))
							                        <i class="fa fa-check-circle" style="color: rgb(81, 175, 51);" aria-hidden="true"></i>
							                        &nbsp; @endif {{$category->name}}
							                    </a>
							                    
							                </h4>

							                <p  class="category-txt" style="max-width: 70% ; display: inline-block;">{{$category->description}}</p>

							                @if($has_subscriptions)
						                    	<span class="pull-right" style="display: inline-grid;">

						                    	<a class="btn btn-success pull-right" href="{{route('provider.subscriptions.index', ['category_id'=>$category->id])}}">{{tr('subscriptions')}}</a>
						                    	
						                    	@if(!$is_subscribed)
						                    		{{tr('subscription_note')}}
						                    	@endif
						                    	</span>
											@endif

							            </div>

							            <div id="category-{{$category->id}}" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">

							                <div class="panel-body">
												
												@foreach($sub_categories as $sc => $sub_category)

						                		<div class="pro-sub-category-block">

													<div class="form-check">
													    <label class="form-check-label">
													      <input type="checkbox" name="sub_category_id_{{$sub_category->id}}" @if($provider_service = check_provider_service(Auth::guard('provider')->user()->id, $sub_category->id)) checked @endif value="{{$sub_category->id}}" class="form-check-input" @if($has_subscriptions && (!$is_subscribed)) disabled @endif> {{$sub_category->name}}  
													    </label>
													</div>

													<p class="category-txt1">{{$sub_category->description}}</p>

													<div class="hour-price-block row m-0">

														<h4 class="hr-price-tit">{{tr('price_per_hour')}}</h4>

														<div class="hr-price-col form-inline col-lg-4 col-md-5 col-sm-6 col-xs-10">
															<div class="form-group">
															    <label>{{Setting::get('currency')}}</label>
															    <input type="text" value="@if(isset($provider_service)) {{$provider_service->price_per_hour}} @endif" id="price_per_hour_{{$sub_category->id}}" name="{{$sub_category->id}}" class="form-control mx-sm-3" aria-describedby="sub_category" @if($has_subscriptions && (!$is_subscribed)) disabled @endif>
															    <small id="sub_category" class="text-muted">
															      .00/hr
															    </small>
															 </div>
														
														</div>

														<!-- <div class="hr-price-col col-lg-4 col-md-4 col-sm-4 col-xs-4">
															<div class="">
																<h4 class="hire-tit">Most Taskers with your experience hired at:</h4>
																<p class="hire-txt">$220</p>
															</div>
														</div>
														<div class="hr-price-col col-lg-4 col-md-4 col-sm-4 col-xs-4">
															<div class="">
																<h4 class="hire-tit">Task Home Rate</h4>
																<p class="hire-txt">$220</p>
															</div>
														</div> -->
													</div>
												
												</div>

						       	 				@endforeach

							                </div>
							            </div>
							        
							        </div>
						       	 	<!-- End of Panel block -->

						       	@endif

					        @endforeach

					    @endif
				    	
				    	</div>

						<!-- End of Pro Category Section -->
						<div class="continue-link-outer text-right">

							<button type="submit" class="continue-link common-bg-link">{{tr('submit')}}</button>
						
						</div>

					</form>

				</div>
			
			</div>

		</div>
	
	</div>

</div>

@endsection

@section('after-scripts')

<!-- <script type="text/javascript" src="{{asset('common/js/jquery-3.3.1.slim.js')}}"></script> -->

<script type="text/javascript" src="{{asset('common/js/grid-gallery.min.js')}}"></script>

@endsection