<div role="tabpanel" class="tab-pane fade @if(isset($profile_active)) @if($profile_active == 'document') in active @endif @endif" id="document">
	<div class="row m-0 border-bot">
		<h3 class="dashboard-sub-tit">{{tr('documents')}}</h3>
	</div>

	<div class="billing-sec dashboard-tab-sec row">

		<form class="billing-form p-f-30" method="post" action="{{route('provider.documents.upload')}}" enctype='multipart/form-data'>

			@if(count($documents = get_document_types()) > 0)

				@foreach($documents as $d => $document)

					<div class="form-group">

					    <label for="document">{{$document->name}}</label>

					    <br>

					    @if($provider_document = get_provider_document($document->id , Auth::guard('provider')->user()->id))

							<input type="hidden" name="document_url_{{$document->id}}">

							<span class="pull-left">

							<a class="btn btn-success" href="{{$provider_document->document_url}}" target="_blank" style="margin-right: 5px;">

								{{tr('view')}}

							</a>

							</span>

							@if(!Auth::guard('provider')->user()->is_approved)

								<span class="">

									<a class="btn btn-danger" onclick="return confirm('Are You Sure?');" href="{{route('provider.documents.delete' , $provider_document->id)}}">
										<i class="fa fa-times"></i>
									</a>
									
								</span>

							@endif

							<br>
							
							<br>

						@endif

					   	<input type="file" onchange="check_document_upload()" id="documents-data-{{$document->id}}" accept="image/png,image/gif,image/jpeg,application/pdf,text/csv" name="{{$document->id}}" class="">
					
					</div>

				@endforeach

				<div id="documents-data-error"></div>

				<div>
					<!-- <button class="cancel-btn form-btn">Cancel</button> -->
					<button type="submit" class="save-btn form-btn">{{tr('submit')}}</button>
				</div>

			@else 

				<p class="p-20">{{tr('no_result_found')}}</p>

			@endif
		
		</form>
	</div>
</div>